/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor;

import java.util.Map;
import java.util.Optional;
import shaded.com.google.common.collect.ImmutableMap;

public enum Format {
    JDBC("jdbc"),
    CSV("csv"),
    RAW("raw"),
    TABLE("table"),
    SIMPLE("simple"),
    STANDARD("standard"),
    EXTENDED("extended"),
    COST("cost");

    private final String formatName;
    public static final Map<String, Format> RESPONSE_FORMATS;
    public static final Map<String, Format> EXPLAIN_FORMATS;

    public static Optional<Format> of(String formatName) {
        return Optional.ofNullable(RESPONSE_FORMATS.getOrDefault(formatName, null));
    }

    public static Optional<Format> ofExplain(String formatName) {
        return Optional.ofNullable(EXPLAIN_FORMATS.getOrDefault(formatName, null));
    }

    private Format(String formatName) {
        this.formatName = formatName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    static {
        ImmutableMap.Builder<String, Format> builder = new ImmutableMap.Builder<String, Format>();
        builder.put(Format.JDBC.formatName, JDBC);
        builder.put(Format.CSV.formatName, CSV);
        builder.put(Format.RAW.formatName, RAW);
        builder.put(Format.TABLE.formatName, TABLE);
        RESPONSE_FORMATS = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put(Format.SIMPLE.formatName, SIMPLE);
        builder.put(Format.STANDARD.formatName, STANDARD);
        builder.put(Format.EXTENDED.formatName, EXTENDED);
        builder.put(Format.COST.formatName, COST);
        EXPLAIN_FORMATS = builder.build();
    }
}

