/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.agg;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.MetricParserHelper;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;

public class CompositeAggregationParser
implements OpenSearchAggregationResponseParser {
    private final MetricParserHelper metricsParser;

    public CompositeAggregationParser(MetricParser ... metricParserList) {
        this.metricsParser = new MetricParserHelper(Arrays.asList(metricParserList));
    }

    public CompositeAggregationParser(List<MetricParser> metricParserList) {
        this.metricsParser = new MetricParserHelper(metricParserList);
    }

    @Override
    public List<Map<String, Object>> parse(Aggregations aggregations) {
        return ((CompositeAggregation)aggregations.asList().get(0)).getBuckets().stream().map(this::parse).collect(Collectors.toList());
    }

    private Map<String, Object> parse(CompositeAggregation.Bucket bucket) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.putAll(bucket.getKey());
        resultMap.putAll(this.metricsParser.parse(bucket.getAggregations()));
        return resultMap;
    }

    @Generated
    public MetricParserHelper getMetricsParser() {
        return this.metricsParser;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeAggregationParser)) {
            return false;
        }
        CompositeAggregationParser other = (CompositeAggregationParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricParserHelper this$metricsParser = this.getMetricsParser();
        MetricParserHelper other$metricsParser = other.getMetricsParser();
        return !(this$metricsParser == null ? other$metricsParser != null : !((Object)this$metricsParser).equals(other$metricsParser));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CompositeAggregationParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        MetricParserHelper $metricsParser = this.getMetricsParser();
        result2 = result2 * 59 + ($metricsParser == null ? 43 : ((Object)$metricsParser).hashCode());
        return result2;
    }
}

