/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.optimizer;

import com.facebook.presto.matching.DefaultMatcher;
import com.facebook.presto.matching.Match;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.optimizer.PushDownPageSize;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.rule.EvalPushDown;
import org.opensearch.sql.planner.optimizer.rule.MergeFilterAndFilter;
import org.opensearch.sql.planner.optimizer.rule.PushFilterUnderSort;
import org.opensearch.sql.planner.optimizer.rule.read.CreateTableScanBuilder;
import org.opensearch.sql.planner.optimizer.rule.read.TableScanPushDown;
import org.opensearch.sql.planner.optimizer.rule.write.CreateTableWriteBuilder;

public class LogicalPlanOptimizer {
    private final List<Rule<?>> rules;

    public LogicalPlanOptimizer(List<Rule<?>> rules) {
        this.rules = rules;
    }

    public static LogicalPlanOptimizer create() {
        return new LogicalPlanOptimizer(Arrays.asList(new MergeFilterAndFilter(), new PushFilterUnderSort(), EvalPushDown.PUSH_DOWN_LIMIT, new CreateTableScanBuilder(), TableScanPushDown.PUSH_DOWN_FILTER, TableScanPushDown.PUSH_DOWN_AGGREGATION, TableScanPushDown.PUSH_DOWN_SORT, TableScanPushDown.PUSH_DOWN_LIMIT, new PushDownPageSize(), TableScanPushDown.PUSH_DOWN_HIGHLIGHT, TableScanPushDown.PUSH_DOWN_NESTED, TableScanPushDown.PUSH_DOWN_PROJECT, new CreateTableWriteBuilder()));
    }

    public LogicalPlan optimize(LogicalPlan plan) {
        LogicalPlan optimized = this.internalOptimize(plan);
        optimized.replaceChildPlans(optimized.getChild().stream().map(this::optimize).collect(Collectors.toList()));
        return this.internalOptimize(optimized);
    }

    public RelNode customOptimize(RelNode plan) {
        return plan;
    }

    private LogicalPlan internalOptimize(LogicalPlan plan) {
        LogicalPlan node = plan;
        boolean done = false;
        while (!done) {
            done = true;
            for (Rule<?> rule : this.rules) {
                Match<?> match = DefaultMatcher.DEFAULT_MATCHER.match(rule.pattern(), node);
                if (!match.isPresent() || (node = rule.apply(match.value(), match.captures())) == match.value()) continue;
                done = false;
            }
        }
        return node;
    }
}

