/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFieldsExcludeMeta;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.PatternMethod;
import org.opensearch.sql.ast.expression.PatternMode;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.DescribeRelation;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.lang.PPLLangSpec;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstExpressionBuilder;
import org.opensearch.sql.ppl.utils.ArgumentFactory;
import org.opensearch.sql.utils.SystemIndexUtils;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class AstBuilder
extends OpenSearchPPLParserBaseVisitor<UnresolvedPlan> {
    private final AstExpressionBuilder expressionBuilder = new AstExpressionBuilder(this);
    private final Settings settings;
    private final String query;

    public AstBuilder(String query) {
        this(query, null);
    }

    public AstBuilder(String query, Settings settings) {
        this.query = query;
        this.settings = settings;
    }

    @Override
    public UnresolvedPlan visitQueryStatement(OpenSearchPPLParser.QueryStatementContext ctx) {
        UnresolvedPlan pplCommand = (UnresolvedPlan)this.visit(ctx.pplCommands());
        return ctx.commands().stream().map(this::visit).reduce(pplCommand, (r, e) -> e.attach(e instanceof Join ? this.projectExceptMeta((UnresolvedPlan)r) : r));
    }

    @Override
    public UnresolvedPlan visitSubSearch(OpenSearchPPLParser.SubSearchContext ctx) {
        UnresolvedPlan searchCommand = (UnresolvedPlan)this.visit(ctx.searchCommand());
        return this.projectExceptMeta(ctx.commands().stream().map(this::visit).reduce(searchCommand, (r, e) -> e.attach((UnresolvedPlan)r)));
    }

    @Override
    public UnresolvedPlan visitSearchFrom(OpenSearchPPLParser.SearchFromContext ctx) {
        return (UnresolvedPlan)this.visitFromClause(ctx.fromClause());
    }

    @Override
    public UnresolvedPlan visitSearchFromFilter(OpenSearchPPLParser.SearchFromFilterContext ctx) {
        return new Filter(this.internalVisitExpression(ctx.logicalExpression())).attach((UnresolvedPlan)this.visit(ctx.fromClause()));
    }

    @Override
    public UnresolvedPlan visitSearchFilterFrom(OpenSearchPPLParser.SearchFilterFromContext ctx) {
        return new Filter(this.internalVisitExpression(ctx.logicalExpression())).attach((UnresolvedPlan)this.visit(ctx.fromClause()));
    }

    @Override
    public UnresolvedPlan visitDescribeCommand(OpenSearchPPLParser.DescribeCommandContext ctx) {
        Relation table = (Relation)this.visitTableSourceClause(ctx.tableSourceClause());
        QualifiedName tableQualifiedName = table.getTableQualifiedName();
        ArrayList<String> parts = new ArrayList<String>(tableQualifiedName.getParts());
        parts.set(parts.size() - 1, SystemIndexUtils.mappingTable(parts.get(parts.size() - 1), PPLLangSpec.PPL_SPEC));
        return new DescribeRelation(new QualifiedName(parts));
    }

    @Override
    public UnresolvedPlan visitShowDataSourcesCommand(OpenSearchPPLParser.ShowDataSourcesCommandContext ctx) {
        return new DescribeRelation(AstDSL.qualifiedName(".DATASOURCES"));
    }

    @Override
    public UnresolvedPlan visitWhereCommand(OpenSearchPPLParser.WhereCommandContext ctx) {
        return new Filter(this.internalVisitExpression(ctx.logicalExpression()));
    }

    @Override
    public UnresolvedPlan visitJoinCommand(OpenSearchPPLParser.JoinCommandContext ctx) {
        Join.JoinType joinType = this.getJoinType(ctx.joinType());
        if (ctx.joinCriteria() == null) {
            joinType = Join.JoinType.CROSS;
        }
        Join.JoinHint joinHint = this.getJoinHint(ctx.joinHintList());
        Optional<String> leftAlias = ctx.sideAlias().leftAlias != null ? Optional.of(this.internalVisitExpression(ctx.sideAlias().leftAlias).toString()) : Optional.empty();
        Optional<Object> rightAlias = Optional.empty();
        if (ctx.tableOrSubqueryClause().alias != null) {
            rightAlias = Optional.of(this.internalVisitExpression(ctx.tableOrSubqueryClause().alias).toString());
        }
        if (ctx.sideAlias().rightAlias != null) {
            rightAlias = Optional.of(this.internalVisitExpression(ctx.sideAlias().rightAlias).toString());
        }
        UnresolvedPlan rightRelation = (UnresolvedPlan)this.visit(ctx.tableOrSubqueryClause());
        UnresolvedPlan right = rightAlias.isEmpty() || rightRelation instanceof SubqueryAlias && ((String)rightAlias.get()).equals(((SubqueryAlias)rightRelation).getAlias()) ? rightRelation : new SubqueryAlias((String)rightAlias.get(), rightRelation);
        Optional<UnresolvedExpression> joinCondition = ctx.joinCriteria() == null ? Optional.empty() : Optional.of((UnresolvedExpression)this.expressionBuilder.visitJoinCriteria(ctx.joinCriteria()));
        return new Join(this.projectExceptMeta(right), leftAlias, rightAlias, joinType, joinCondition, joinHint);
    }

    private Join.JoinHint getJoinHint(OpenSearchPPLParser.JoinHintListContext ctx) {
        Join.JoinHint joinHint = ctx == null ? new Join.JoinHint() : new Join.JoinHint(ctx.hintPair().stream().map(this.expressionBuilder::visit).filter(e -> e instanceof EqualTo).map(e -> (EqualTo)e).collect(Collectors.toMap(k -> k.getLeft().toString(), v -> v.getRight().toString(), (v1, v2) -> v2, LinkedHashMap::new)));
        return joinHint;
    }

    private Join.JoinType getJoinType(OpenSearchPPLParser.JoinTypeContext ctx) {
        Join.JoinType joinType = ctx == null ? Join.JoinType.INNER : (ctx.INNER() != null ? Join.JoinType.INNER : (ctx.SEMI() != null ? Join.JoinType.SEMI : (ctx.ANTI() != null ? Join.JoinType.ANTI : (ctx.LEFT() != null ? Join.JoinType.LEFT : (ctx.RIGHT() != null ? Join.JoinType.RIGHT : (ctx.CROSS() != null ? Join.JoinType.CROSS : (ctx.FULL() != null ? Join.JoinType.FULL : Join.JoinType.INNER)))))));
        return joinType;
    }

    @Override
    public UnresolvedPlan visitFieldsCommand(OpenSearchPPLParser.FieldsCommandContext ctx) {
        return new Project(ctx.fieldList().fieldExpression().stream().map(this::internalVisitExpression).collect(Collectors.toList()), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedPlan visitRenameCommand(OpenSearchPPLParser.RenameCommandContext ctx) {
        return new Rename(ctx.renameClasue().stream().map(ct -> new Map(this.internalVisitExpression(ct.orignalField), this.internalVisitExpression(ct.renamedField))).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitStatsCommand(OpenSearchPPLParser.StatsCommandContext ctx) {
        ImmutableList.Builder aggListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.StatsAggTermContext aggCtx : ctx.statsAggTerm()) {
            UnresolvedExpression aggExpression = this.internalVisitExpression(aggCtx.statsFunction());
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier(aggCtx.alias.getText());
            Alias alias = new Alias(name, aggExpression);
            aggListBuilder.add(alias);
        }
        List<UnresolvedExpression> groupList = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::fieldList).map(expr -> expr.fieldExpression().stream().map(groupCtx -> new Alias(StringUtils.unquoteIdentifier(this.getTextInQuery((ParserRuleContext)groupCtx)), this.internalVisitExpression((ParseTree)groupCtx))).collect(Collectors.toList())).orElse(Collections.emptyList());
        UnresolvedExpression span = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::bySpanClause).map(this::internalVisitExpression).orElse(null);
        Aggregation aggregation = new Aggregation((List<UnresolvedExpression>)((Object)aggListBuilder.build()), Collections.emptyList(), groupList, span, ArgumentFactory.getArgumentList(ctx));
        return aggregation;
    }

    @Override
    public UnresolvedPlan visitEventstatsCommand(OpenSearchPPLParser.EventstatsCommandContext ctx) {
        ImmutableList.Builder windownFunctionListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.EventstatsAggTermContext aggCtx : ctx.eventstatsAggTerm()) {
            UnresolvedExpression windowFunction = this.internalVisitExpression(aggCtx.windowFunction());
            if (windowFunction instanceof WindowFunction) {
                ((WindowFunction)windowFunction).setPartitionByList(this.getPartitionExprList(ctx.statsByClause()));
            }
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier(aggCtx.alias.getText());
            Alias alias = new Alias(name, windowFunction);
            windownFunctionListBuilder.add(alias);
        }
        return new Window((List<UnresolvedExpression>)((Object)windownFunctionListBuilder.build()));
    }

    @Override
    public UnresolvedPlan visitDedupCommand(OpenSearchPPLParser.DedupCommandContext ctx) {
        return new Dedupe(ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()));
    }

    @Override
    public UnresolvedPlan visitHeadCommand(OpenSearchPPLParser.HeadCommandContext ctx) {
        Integer size = ctx.number != null ? Integer.parseInt(ctx.number.getText()) : 10;
        Integer from = ctx.from != null ? Integer.parseInt(ctx.from.getText()) : 0;
        return new Head(size, from);
    }

    @Override
    public UnresolvedPlan visitSortCommand(OpenSearchPPLParser.SortCommandContext ctx) {
        return new Sort(ctx.sortbyClause().sortField().stream().map(sort -> (Field)this.internalVisitExpression((ParseTree)sort)).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitEvalCommand(OpenSearchPPLParser.EvalCommandContext ctx) {
        return new Eval(ctx.evalClause().stream().map(ct -> (Let)this.internalVisitExpression((ParseTree)ct)).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> getGroupByList(OpenSearchPPLParser.ByClauseContext ctx) {
        return ctx.fieldList().fieldExpression().stream().map(this::internalVisitExpression).collect(Collectors.toList());
    }

    private List<Field> getFieldList(OpenSearchPPLParser.FieldListContext ctx) {
        return ctx.fieldExpression().stream().map(field -> (Field)this.internalVisitExpression((ParseTree)field)).collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitRareCommand(OpenSearchPPLParser.RareCommandContext ctx) {
        List<UnresolvedExpression> groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.RARE, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitTopCommand(OpenSearchPPLParser.TopCommandContext ctx) {
        List<UnresolvedExpression> groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.TOP, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitExpandCommand(OpenSearchPPLParser.ExpandCommandContext ctx) {
        Field fieldExpression = (Field)this.internalVisitExpression(ctx.fieldExpression());
        String alias = ctx.alias != null ? this.internalVisitExpression(ctx.alias).toString() : null;
        return new Expand(fieldExpression, alias);
    }

    @Override
    public UnresolvedPlan visitGrokCommand(OpenSearchPPLParser.GrokCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression(ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression(ctx.pattern);
        return new Parse(ParseMethod.GROK, sourceField, pattern, ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitParseCommand(OpenSearchPPLParser.ParseCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression(ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression(ctx.pattern);
        return new Parse(ParseMethod.REGEX, sourceField, pattern, ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitPatternsCommand(OpenSearchPPLParser.PatternsCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression(ctx.source_field);
        ImmutableMap.Builder<String, Literal> builder = ImmutableMap.builder();
        Literal newField = null;
        if (ctx.new_field != null) {
            newField = (Literal)this.internalVisitExpression(ctx.new_field);
            builder.put("new_field", newField);
        }
        ctx.patternsParameter().forEach(x -> {
            String argName = ((ParseTree)x.children.get(0)).toString();
            Literal value = (Literal)this.internalVisitExpression((ParseTree)x.children.get(2));
            builder.put(argName, value);
        });
        ImmutableMap<String, Literal> arguments2 = builder.build();
        String patternMethod = ctx.method != null ? StringUtils.unquoteIdentifier(ctx.method.getText()).toLowerCase(Locale.ROOT) : this.settings.getSettingValue(Settings.Key.PATTERN_METHOD).toString().toLowerCase(Locale.ROOT);
        String patternMode = ctx.pattern_mode != null ? StringUtils.unquoteIdentifier(ctx.pattern_mode.getText()).toLowerCase(Locale.ROOT) : this.settings.getSettingValue(Settings.Key.PATTERN_MODE).toString().toLowerCase(Locale.ROOT);
        Literal patternMaxSampleCount = ctx.max_sample_count != null ? (Literal)this.internalVisitExpression(ctx.max_sample_count) : AstDSL.intLiteral((Integer)this.settings.getSettingValue(Settings.Key.PATTERN_MAX_SAMPLE_COUNT));
        Literal patternBufferLimit = ctx.buffer_limit != null ? (Literal)this.internalVisitExpression(ctx.buffer_limit) : AstDSL.intLiteral((Integer)this.settings.getSettingValue(Settings.Key.PATTERN_BUFFER_LIMIT));
        List<UnresolvedExpression> partitionByList = this.getPartitionExprList(ctx.statsByClause());
        return new Patterns(sourceField, partitionByList, newField != null ? newField.getValue().toString() : "patterns_field", PatternMethod.valueOf(patternMethod.toUpperCase(Locale.ROOT)), PatternMode.valueOf(patternMode.toUpperCase(Locale.ROOT)), patternMaxSampleCount, patternBufferLimit, arguments2);
    }

    @Override
    public UnresolvedPlan visitLookupCommand(OpenSearchPPLParser.LookupCommandContext ctx) {
        Relation lookupRelation = new Relation(this.internalVisitExpression(ctx.tableSource()));
        Lookup.OutputStrategy strategy = ctx.APPEND() != null ? Lookup.OutputStrategy.APPEND : Lookup.OutputStrategy.REPLACE;
        java.util.Map<String, String> mappingAliasMap = this.buildFieldAliasMap(ctx.lookupMappingList().lookupPair());
        java.util.Map<String, String> outputAliasMap = ctx.outputCandidateList() == null ? Collections.emptyMap() : this.buildFieldAliasMap(ctx.outputCandidateList().lookupPair());
        return new Lookup(lookupRelation, mappingAliasMap, strategy, outputAliasMap);
    }

    private java.util.Map<String, String> buildFieldAliasMap(List<OpenSearchPPLParser.LookupPairContext> lookupPairContext) {
        return lookupPairContext.stream().collect(Collectors.toMap(pair -> pair.inputField.getText(), pair -> pair.AS() != null ? pair.outputField.getText() : pair.inputField.getText(), (x, y) -> y, LinkedHashMap::new));
    }

    @Override
    public UnresolvedPlan visitTableOrSubqueryClause(OpenSearchPPLParser.TableOrSubqueryClauseContext ctx) {
        if (ctx.subSearch() != null) {
            return ctx.alias != null ? new SubqueryAlias(this.internalVisitExpression(ctx.alias).toString(), this.visitSubSearch(ctx.subSearch())) : this.visitSubSearch(ctx.subSearch());
        }
        return this.visitTableSourceClause(ctx.tableSourceClause());
    }

    @Override
    public UnresolvedPlan visitTableSourceClause(OpenSearchPPLParser.TableSourceClauseContext ctx) {
        Relation relation = new Relation(ctx.tableSource().stream().map(this::internalVisitExpression).collect(Collectors.toList()));
        return ctx.alias != null ? new SubqueryAlias(this.internalVisitExpression(ctx.alias).toString(), relation) : relation;
    }

    @Override
    public UnresolvedPlan visitTableFunction(OpenSearchPPLParser.TableFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ctx.functionArgs().functionArg().forEach(arg -> {
            String argName = arg.ident() != null ? arg.ident().getText() : null;
            builder.add(new UnresolvedArgument(argName, this.internalVisitExpression(arg.functionArgExpression())));
        });
        return new TableFunction(this.internalVisitExpression(ctx.qualifiedName()), (List<UnresolvedExpression>)((Object)builder.build()));
    }

    private UnresolvedExpression internalVisitExpression(ParseTree tree) {
        return (UnresolvedExpression)this.expressionBuilder.visit(tree);
    }

    @Override
    protected UnresolvedPlan aggregateResult(UnresolvedPlan aggregate, UnresolvedPlan nextResult) {
        if (nextResult != this.defaultResult()) {
            return nextResult;
        }
        return aggregate;
    }

    @Override
    public UnresolvedPlan visitKmeansCommand(OpenSearchPPLParser.KmeansCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.kmeansParameter().forEach(x -> builder.put(((ParseTree)x.children.get(0)).toString(), (Literal)this.internalVisitExpression((ParseTree)x.children.get(2))));
        return new Kmeans(builder.build());
    }

    @Override
    public UnresolvedPlan visitAdCommand(OpenSearchPPLParser.AdCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.adParameter().forEach(x -> builder.put(((ParseTree)x.children.get(0)).toString(), (Literal)this.internalVisitExpression((ParseTree)x.children.get(2))));
        return new AD(builder.build());
    }

    @Override
    public UnresolvedPlan visitMlCommand(OpenSearchPPLParser.MlCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.mlArg().forEach(x -> builder.put(x.argName.getText(), (Literal)this.internalVisitExpression(x.argValue)));
        return new ML(builder.build());
    }

    @Override
    public UnresolvedPlan visitFillNullWith(OpenSearchPPLParser.FillNullWithContext ctx) {
        if (ctx.IN() != null) {
            return FillNull.ofSameValue(this.internalVisitExpression(ctx.replacement), ctx.fieldList().fieldExpression().stream().map(f -> (Field)this.internalVisitExpression((ParseTree)f)).toList());
        }
        return FillNull.ofSameValue(this.internalVisitExpression(ctx.replacement), List.of());
    }

    @Override
    public UnresolvedPlan visitFillNullUsing(OpenSearchPPLParser.FillNullUsingContext ctx) {
        ImmutableList.Builder replacementsBuilder = ImmutableList.builder();
        for (int i = 0; i < ctx.replacementPair().size(); ++i) {
            replacementsBuilder.add(Pair.of((Field)this.internalVisitExpression(ctx.replacementPair(i).fieldExpression()), this.internalVisitExpression(ctx.replacementPair((int)i).replacement)));
        }
        return FillNull.ofVariousValue((List<Pair<Field, UnresolvedExpression>>)((Object)replacementsBuilder.build()));
    }

    @Override
    public UnresolvedPlan visitFlattenCommand(OpenSearchPPLParser.FlattenCommandContext ctx) {
        Field field = (Field)this.internalVisitExpression(ctx.fieldExpression());
        List<String> aliases = ctx.aliases == null ? null : this.getAliasList((OpenSearchPPLParser.IdentsAsQualifiedNameSeqContext)ctx.aliases);
        return new Flatten(field, aliases);
    }

    private List<String> getAliasList(OpenSearchPPLParser.IdentsAsQualifiedNameSeqContext ctx) {
        return ctx.qualifiedName().stream().map(this::internalVisitExpression).map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitTrendlineCommand(OpenSearchPPLParser.TrendlineCommandContext ctx) {
        List<Trendline.TrendlineComputation> trendlineComputations = ctx.trendlineClause().stream().map(this.expressionBuilder::visit).map(Trendline.TrendlineComputation.class::cast).collect(Collectors.toList());
        return Optional.ofNullable(ctx.sortField()).map(this::internalVisitExpression).map(Field.class::cast).map(sort -> new Trendline(Optional.of(sort), trendlineComputations)).orElse(new Trendline(Optional.empty(), trendlineComputations));
    }

    @Override
    public UnresolvedPlan visitAppendcolCommand(OpenSearchPPLParser.AppendcolCommandContext ctx) {
        boolean override;
        Optional<UnresolvedPlan> subsearch = ctx.commands().stream().map(this::visit).reduce((r, e) -> e.attach((UnresolvedPlan)r));
        boolean bl = override = ctx.override != null && Boolean.parseBoolean(ctx.override.getText());
        if (subsearch.isEmpty()) {
            throw new SemanticCheckException("subsearch should not be empty");
        }
        return new AppendCol(override, subsearch.get());
    }

    private String getTextInQuery(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return this.query.substring(start.getStartIndex(), stop.getStopIndex() + 1);
    }

    private UnresolvedPlan projectExceptMeta(UnresolvedPlan plan) {
        if (plan instanceof Project && !((Project)plan).isExcluded()) {
            return plan;
        }
        if (plan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)plan;
            return new SubqueryAlias(subqueryAlias.getAlias(), new Project(ImmutableList.of(AllFieldsExcludeMeta.of())).attach(subqueryAlias.getChild().getFirst()));
        }
        return new Project(ImmutableList.of(AllFieldsExcludeMeta.of())).attach(plan);
    }

    private List<UnresolvedExpression> getPartitionExprList(OpenSearchPPLParser.StatsByClauseContext ctx) {
        ImmutableList.Builder partExprListBuilder = new ImmutableList.Builder();
        Optional.ofNullable(ctx).map(OpenSearchPPLParser.StatsByClauseContext::bySpanClause).map(this::internalVisitExpression).ifPresent(partExprListBuilder::add);
        Optional.ofNullable(ctx).map(OpenSearchPPLParser.StatsByClauseContext::fieldList).map(expr -> expr.fieldExpression().stream().map(groupCtx -> new Alias(StringUtils.unquoteIdentifier(this.getTextInQuery((ParserRuleContext)groupCtx)), this.internalVisitExpression((ParseTree)groupCtx))).collect(Collectors.toList())).ifPresent(partExprListBuilder::addAll);
        return partExprListBuilder.build();
    }
}

