/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.api.INumberAnalyzed;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.utils.Log;

public class NumberAnalyzed
implements INumberAnalyzed {
    private static final int SLIDING_WINDOW = 1024;
    private long nb;
    private long sum;
    private long min;
    private long max;
    private long sumOfSquare;
    private long sliddingSum;
    private final String name;
    private final Lock saveLock = new ReentrantLock();

    public NumberAnalyzed(String name) {
        this.name = name;
    }

    public synchronized void reset() {
        this.nb = 0L;
        this.sum = 0L;
        this.min = 0L;
        this.max = 0L;
        this.sumOfSquare = 0L;
        this.sliddingSum = 0L;
    }

    public NumberAnalyzed() {
        this("");
    }

    public final void save(Preferences prefs) {
        if (this.name.length() == 0) {
            throw new UnsupportedOperationException();
        }
        if (this.saveLock.tryLock()) {
            try {
                prefs.put(this.name + ".saved", this.getSavedString());
            }
            finally {
                this.saveLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSavedString() {
        long sliddingSum1;
        long sumOfSquare1;
        long max1;
        long min1;
        long sum1;
        long nb1;
        NumberAnalyzed numberAnalyzed = this;
        synchronized (numberAnalyzed) {
            nb1 = this.nb;
            sum1 = this.sum;
            min1 = this.min;
            max1 = this.max;
            sumOfSquare1 = this.sumOfSquare;
            sliddingSum1 = this.sliddingSum;
        }
        String supp1 = this.getSavedSupplementatyData();
        return this.longToString(nb1) + ";" + this.longToString(sum1) + ";" + this.longToString(min1) + ";" + this.longToString(max1) + ";" + this.longToString(sumOfSquare1) + ";" + this.longToString(sliddingSum1) + ";" + supp1 + ";";
    }

    protected String getSavedSupplementatyData() {
        return "";
    }

    protected final String longToString(long val) {
        return Long.toString(val, 36);
    }

    public static NumberAnalyzed load(String name, Preferences prefs) {
        String value = prefs.get(name + ".saved", "");
        if (value.length() == 0) {
            Log.info("Cannot load " + name);
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(value, ";");
            return new NumberAnalyzed(name, Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36));
        }
        catch (Exception e) {
            Logme.error(e);
            Log.info("Error reading " + value);
            return null;
        }
    }

    public synchronized String toString() {
        return "sum=" + this.sum + " nb=" + this.nb + " min=" + this.min + " max=" + this.max + " mean=" + this.getMean();
    }

    protected NumberAnalyzed(String name, long nb, long sum, long min2, long max, long sumOfSquare, long sliddingSum) {
        this(name);
        this.nb = nb;
        this.sum = sum;
        this.min = min2;
        this.max = max;
        this.sumOfSquare = sumOfSquare;
        this.sliddingSum = sliddingSum;
    }

    public synchronized INumberAnalyzed getCopyImmutable() {
        NumberAnalyzed copy = new NumberAnalyzed(this.name, this.nb, this.sum, this.min, this.max, this.sumOfSquare, this.sliddingSum);
        return copy;
    }

    public synchronized void addValue(long v) {
        ++this.nb;
        if (this.nb == 1L) {
            this.min = v;
            this.max = v;
        } else if (v > this.max) {
            this.max = v;
        } else if (v < this.min) {
            this.min = v;
        }
        this.sum += v;
        this.sumOfSquare += v * v;
        this.sliddingSum = this.sliddingSum * 1023L / 1024L + v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NumberAnalyzed other) {
        long sliddingSum1;
        long sumOfSquare1;
        long max1;
        long min1;
        long sum1;
        long nb1;
        NumberAnalyzed numberAnalyzed = other;
        synchronized (numberAnalyzed) {
            nb1 = other.nb;
            sum1 = other.sum;
            min1 = other.min;
            max1 = other.max;
            sumOfSquare1 = other.sumOfSquare;
            sliddingSum1 = other.sliddingSum;
        }
        numberAnalyzed = this;
        synchronized (numberAnalyzed) {
            this.sum += sum1;
            this.nb += nb1;
            this.min = Math.min(this.min, min1);
            this.max = Math.max(this.max, max1);
            this.sumOfSquare += sumOfSquare1;
            this.sliddingSum += sliddingSum1;
        }
    }

    @Override
    public final synchronized long getNb() {
        return this.nb;
    }

    @Override
    public final synchronized long getSum() {
        return this.sum;
    }

    @Override
    public final synchronized long getMin() {
        return this.min;
    }

    @Override
    public final synchronized long getMax() {
        return this.max;
    }

    @Override
    public final synchronized long getMean() {
        if (this.nb == 0L) {
            return 0L;
        }
        return this.sum / this.nb;
    }

    @Override
    public final synchronized long getSliddingMean() {
        if (this.nb == 0L) {
            return 0L;
        }
        if (this.nb < 1024L) {
            return this.sum / this.nb;
        }
        return this.sliddingSum / this.nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getStandardDeviation() {
        long nb1;
        long sumOfSquare1;
        long sum1;
        NumberAnalyzed numberAnalyzed = this;
        synchronized (numberAnalyzed) {
            sum1 = this.sum;
            sumOfSquare1 = this.sumOfSquare;
            nb1 = this.nb;
        }
        if (nb1 == 0L) {
            return 0L;
        }
        long mean = sum1 / nb1;
        return Math.round(Math.sqrt(sumOfSquare1 / nb1 - mean * mean));
    }

    public final String getName() {
        return this.name;
    }
}

