/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.comp;

import java.util.Locale;

public enum ComparatorOrder {
    ASCENDING,
    DESCENDING;


    public static ComparatorOrder fromString(String order) {
        switch (order.toLowerCase(Locale.ROOT)) {
            case "asc": {
                return ASCENDING;
            }
            case "desc": {
                return DESCENDING;
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown order '%s'", order));
    }

    public String toString() {
        switch (this) {
            case DESCENDING: {
                return "desc";
            }
        }
        return "asc";
    }
}

