/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.library.metrics.MetricsComponent;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class MetricsComponentDependencyGraph<T> {
    private final SetMultimap<MetricsComponent<T>, MetricsComponent<T>> outgoingComponentDependencies;
    private final SetMultimap<MetricsComponent<T>, MetricsComponent<T>> incomingComponentDependencies;

    private MetricsComponentDependencyGraph(Iterable<MetricsComponent<T>> components, Function<T, Collection<T>> getDependencies) {
        ImmutableSetMultimap<MetricsComponent<T>, MetricsComponent<T>> componentDependencies = this.createComponentDependencies(components, getDependencies);
        this.outgoingComponentDependencies = componentDependencies;
        this.incomingComponentDependencies = componentDependencies.inverse();
    }

    private ImmutableSetMultimap<MetricsComponent<T>, MetricsComponent<T>> createComponentDependencies(Iterable<MetricsComponent<T>> components, Function<T, Collection<T>> getDependencies) {
        Map<T, MetricsComponent<T>> componentsByElements = this.indexComponentByElement(components);
        ImmutableSetMultimap.Builder componentDependencies = ImmutableSetMultimap.builder();
        for (MetricsComponent<T> component : components) {
            componentDependencies.putAll((Object)component, this.createDependenciesOf(component, componentsByElements, getDependencies));
        }
        return componentDependencies.build();
    }

    private Map<T, MetricsComponent<T>> indexComponentByElement(Iterable<MetricsComponent<T>> components) {
        HashMap<T, MetricsComponent<T>> componentsByElements = new HashMap<T, MetricsComponent<T>>();
        for (MetricsComponent<T> component : components) {
            for (T element : component.getElements()) {
                componentsByElements.put(element, component);
            }
        }
        return componentsByElements;
    }

    private ImmutableSet<MetricsComponent<T>> createDependenciesOf(MetricsComponent<T> component, Map<T, MetricsComponent<T>> componentsByElements, Function<T, Collection<T>> getDependencies) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (T element : component.getElements()) {
            for (T dependency : getDependencies.apply(element)) {
                MetricsComponent<T> target = componentsByElements.get(dependency);
                if (target == null || target.equals(component)) continue;
                builder.add(target);
            }
        }
        return builder.build();
    }

    Set<MetricsComponent<T>> getDirectDependenciesFrom(MetricsComponent<T> origin) {
        return this.outgoingComponentDependencies.get((Object)origin);
    }

    Set<MetricsComponent<T>> getDirectDependenciesTo(MetricsComponent<T> target) {
        return this.incomingComponentDependencies.get((Object)target);
    }

    Set<MetricsComponent<T>> getTransitiveDependenciesOf(MetricsComponent<T> origin) {
        ImmutableSet.Builder<MetricsComponent<T>> transitiveDependencies = ImmutableSet.builder();
        HashSet<MetricsComponent<T>> analyzedComponents = new HashSet<MetricsComponent<T>>();
        this.addTransitiveDependenciesFrom(origin, transitiveDependencies, analyzedComponents);
        return transitiveDependencies.build();
    }

    private void addTransitiveDependenciesFrom(MetricsComponent<T> component, ImmutableSet.Builder<MetricsComponent<T>> transitiveDependencies, Set<MetricsComponent<T>> analyzedComponents) {
        analyzedComponents.add(component);
        HashSet<MetricsComponent<T>> dependencyTargetsToRecurse = new HashSet<MetricsComponent<T>>();
        for (MetricsComponent<Object> dependency : this.getDirectDependenciesFrom(component)) {
            transitiveDependencies.add((Object)dependency);
            dependencyTargetsToRecurse.add(dependency);
        }
        for (MetricsComponent<Object> dependency : dependencyTargetsToRecurse) {
            if (analyzedComponents.contains(dependency)) continue;
            this.addTransitiveDependenciesFrom(dependency, transitiveDependencies, analyzedComponents);
        }
    }

    static <T> MetricsComponentDependencyGraph<T> of(Iterable<MetricsComponent<T>> components, Function<T, Collection<T>> getDependencies) {
        return new MetricsComponentDependencyGraph<T>(components, getDependencies);
    }
}

