/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.DelegatingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExcludeFactory
extends DelegatingExcludeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExcludeFactory.class);
    private final Subject subject = LoggingExcludeFactory.computeWhatToLog();

    LoggingExcludeFactory(ExcludeFactory delegate) {
        super(delegate);
    }

    private static Subject computeWhatToLog() {
        String subjectString = System.getProperty("org.gradle.internal.dm.trace.excludes", Subject.all.toString());
        return Subject.valueOf(subjectString.toLowerCase());
    }

    public static ExcludeFactory maybeLog(ExcludeFactory factory) {
        if (LOGGER.isDebugEnabled()) {
            return new LoggingExcludeFactory(factory);
        }
        return factory;
    }

    @Override
    public ExcludeSpec anyOf(ExcludeSpec one, ExcludeSpec two) {
        return this.log("anyOf", (Factory<ExcludeSpec>)((Factory)() -> super.anyOf(one, two)), one, two);
    }

    @Override
    public ExcludeSpec allOf(ExcludeSpec one, ExcludeSpec two) {
        return this.log("allOf", (Factory<ExcludeSpec>)((Factory)() -> super.allOf(one, two)), one, two);
    }

    @Override
    public ExcludeSpec anyOf(Set<ExcludeSpec> specs) {
        return this.log("anyOf", (Factory<ExcludeSpec>)((Factory)() -> super.anyOf(specs)), specs);
    }

    @Override
    public ExcludeSpec allOf(Set<ExcludeSpec> specs) {
        return this.log("allOf", (Factory<ExcludeSpec>)((Factory)() -> super.allOf(specs)), specs);
    }

    private ExcludeSpec log(String operationName, Factory<ExcludeSpec> factory, Object ... operands) {
        ExcludeSpec spec;
        try {
            spec = (ExcludeSpec)factory.create();
        }
        catch (StackOverflowError e) {
            if (this.subject.isTraceStackOverflows()) {
                StringWriter sw = new StringWriter();
                sw.append("{\"stackoverflow\": [");
                PrintWriter printWriter = new PrintWriter(sw);
                StackTraceElement[] stackTrace = e.getStackTrace();
                printWriter.print(Arrays.stream(stackTrace).limit(100L).map(d -> "\"" + d.toString() + "\"").collect(Collectors.joining(", ")));
                sw.append("]}");
                LOGGER.debug("{\"operation\": { \"name\": \"{}\", \"operands\": {}, \"result\": {} } }", new Object[]{operationName, LoggingExcludeFactory.toList(operands), sw.toString()});
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        if (this.subject.isTraceOperations()) {
            LOGGER.debug("{\"operation\": { \"name\": \"{}\", \"operands\": {}, \"result\": {} } }", new Object[]{operationName, LoggingExcludeFactory.toList(operands), spec});
        }
        return spec;
    }

    private static Collection<?> toList(Object[] operands) {
        return LoggingExcludeFactory.singleCollection(operands) ? (Collection)operands[0] : Arrays.asList(operands);
    }

    private static boolean singleCollection(Object[] operands) {
        return operands.length == 1 && operands[0] instanceof Collection;
    }

    private static enum Subject {
        all(true, true),
        stackoverflow(false, true),
        operations(true, false);

        private final boolean traceOperations;
        private final boolean traceStackOverflows;

        private Subject(boolean traceOperations, boolean traceStackOverflows) {
            this.traceOperations = traceOperations;
            this.traceStackOverflows = traceStackOverflows;
        }

        public boolean isTraceOperations() {
            return this.traceOperations;
        }

        public boolean isTraceStackOverflows() {
            return this.traceStackOverflows;
        }
    }
}

