/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.scopes.GlobalScopedCache;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.RemappingScriptSource;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class FileCacheBackedScriptClassCompiler
implements ScriptClassCompiler,
Closeable {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final GlobalScopedCache cacheRepository;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final CachedClasspathTransformer classpathTransformer;

    public FileCacheBackedScriptClassCompiler(GlobalScopedCache cacheRepository, ScriptCompilationHandler scriptCompilationHandler, ProgressLoggerFactory progressLoggerFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, CachedClasspathTransformer classpathTransformer) {
        this.cacheRepository = cacheRepository;
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.progressLoggerFactory = progressLoggerFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.classpathTransformer = classpathTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Script, M> CompiledScript<T, M> compile(ScriptSource source, ClassLoaderScope targetScope, CompileOperation<M> operation, Class<T> scriptBaseClass, Action<? super ClassNode> verifier) {
        assert (source.getResource().isContentCached());
        if (source.getResource().getHasEmptyContent()) {
            return this.emptyCompiledScript(operation);
        }
        ClassLoader classLoader = targetScope.getExportClassLoader();
        HashCode sourceHashCode = source.getResource().getContentHash();
        String dslId = operation.getId();
        HashCode classLoaderHash = this.classLoaderHierarchyHasher.getClassLoaderHash(classLoader);
        if (classLoaderHash == null) {
            throw new IllegalArgumentException("Unknown classloader: " + classLoader);
        }
        RemappingScriptSource remapped = new RemappingScriptSource(source);
        PrimitiveHasher hasher = Hashing.newPrimitiveHasher();
        hasher.putString((CharSequence)dslId);
        hasher.putHash(sourceHashCode);
        hasher.putHash(classLoaderHash);
        String key = hasher.hash().toCompactString();
        try (PersistentCache cache = this.cacheRepository.cache("scripts/" + key).withDisplayName(dslId + " generic class cache for " + source.getDisplayName()).withInitializer((Action)new ProgressReportingInitializer(this.progressLoggerFactory, new CompileToCrossBuildCacheAction(remapped, classLoader, operation, verifier, scriptBaseClass), "Compiling " + source.getShortDisplayName())).open();){
            File genericClassesDir = this.classesDir(cache, operation);
            File metadataDir = this.metadataDir(cache);
            ClassPath remappedClasses = this.remapClasses(genericClassesDir, remapped);
            CompiledScript<T, M> compiledScript = this.scriptCompilationHandler.loadFromDir(source, sourceHashCode, targetScope, remappedClasses, metadataDir, operation, scriptBaseClass);
            return compiledScript;
        }
    }

    private <T extends Script, M> CompiledScript<T, M> emptyCompiledScript(CompileOperation<M> operation) {
        return new EmptyCompiledScript(operation);
    }

    private ClassPath remapClasses(File genericClassesDir, RemappingScriptSource source) {
        final ScriptSource origin = source.getSource();
        final String className = origin.getClassName();
        return this.classpathTransformer.transform(DefaultClassPath.of((File[])new File[]{genericClassesDir}), CachedClasspathTransformer.StandardTransform.BuildLogic, new CachedClasspathTransformer.Transform(){

            @Override
            public void applyConfigurationTo(Hasher hasher) {
                hasher.putString((CharSequence)FileCacheBackedScriptClassCompiler.class.getSimpleName());
                hasher.putInt(1);
                hasher.putString((CharSequence)className);
            }

            @Override
            public Pair<RelativePath, ClassVisitor> apply(ClasspathEntryVisitor.Entry entry, ClassVisitor visitor) throws IOException {
                String renamed = entry.getPath().getLastName();
                if (renamed.startsWith("_BuildScript_")) {
                    renamed = className + renamed.substring("_BuildScript_".length());
                }
                byte[] content = entry.getContent();
                ClassReader cr = new ClassReader(content);
                String originalClassName = cr.getClassName();
                String contentHash = Hashing.hashBytes((byte[])content).toString();
                BuildScriptRemapper remapper = new BuildScriptRemapper(visitor, origin, originalClassName, contentHash);
                return Pair.of((Object)entry.getPath().getParent().append(true, new String[]{renamed}), (Object)((Object)remapper));
            }
        });
    }

    @Override
    public void close() {
    }

    private File classesDir(PersistentCache cache, CompileOperation<?> operation) {
        return new File(cache.getBaseDir(), operation.getId());
    }

    private File metadataDir(PersistentCache cache) {
        return new File(cache.getBaseDir(), "metadata");
    }

    private static class BuildScriptRemapper
    extends ClassVisitor
    implements Opcodes {
        private static final String SCRIPT_ORIGIN = "org/gradle/internal/scripts/ScriptOrigin";
        private final ScriptSource scriptSource;
        private final String originalClassName;
        private final String contentHash;

        public BuildScriptRemapper(ClassVisitor cv, ScriptSource source, String originalClassName, String contentHash) {
            super(589824, cv);
            this.scriptSource = source;
            this.originalClassName = originalClassName;
            this.contentHash = contentHash;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String owner = this.remap(name);
            boolean shouldAddScriptOrigin = BuildScriptRemapper.shouldAddScriptOrigin(access);
            this.cv.visit(version, access, owner, this.remap(signature), this.remap(superName), this.remapAndAddInterfaces(interfaces, shouldAddScriptOrigin));
            if (shouldAddScriptOrigin) {
                BuildScriptRemapper.addOriginalClassName(this.cv, owner, this.originalClassName);
                BuildScriptRemapper.addContentHash(this.cv, owner, this.contentHash);
            }
        }

        private static boolean shouldAddScriptOrigin(int access) {
            return (access & 0x200) == 0 && (access & 0x2000) == 0;
        }

        private static void addOriginalClassName(ClassVisitor cv, String owner, String originalClassName) {
            cv.visitField(4122, "__originalClassName", Type.getDescriptor(String.class), "", (Object)originalClassName);
            MethodVisitor mv = cv.visitMethod(1, "getOriginalClassName", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, owner, "__originalClassName", Type.getDescriptor(String.class));
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        private static void addContentHash(ClassVisitor cv, String owner, String contentHash) {
            cv.visitField(4122, "__signature", Type.getDescriptor(String.class), "", (Object)contentHash);
            MethodVisitor mv = cv.visitMethod(1, "getContentHash", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, owner, "__signature", Type.getDescriptor(String.class));
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        public void visitSource(String source, String debug) {
            this.cv.visitSource(this.scriptSource.getFileName(), debug);
        }

        private String[] remapAndAddInterfaces(String[] interfaces, boolean shouldAddScriptOrigin) {
            if (!shouldAddScriptOrigin) {
                return this.remap(interfaces);
            }
            if (interfaces == null) {
                return new String[]{SCRIPT_ORIGIN};
            }
            String[] remapped = new String[interfaces.length + 1];
            for (int i = 0; i < interfaces.length; ++i) {
                remapped[i] = this.remap(interfaces[i]);
            }
            remapped[remapped.length - 1] = SCRIPT_ORIGIN;
            return remapped;
        }

        private String[] remap(String[] names) {
            if (names == null) {
                return null;
            }
            String[] remapped = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                remapped[i] = this.remap(names[i]);
            }
            return remapped;
        }

        private String remap(String name) {
            if (name == null) {
                return null;
            }
            if ("@@sourceuri@@".equals(name)) {
                URI uri = this.scriptSource.getResource().getLocation().getURI();
                return uri == null ? null : uri.toString();
            }
            if ("@@sourcedesc@@".equals(name)) {
                return this.scriptSource.getDisplayName();
            }
            return name.replace("_BuildScript_", this.scriptSource.getClassName());
        }

        private Object remap(Object o) {
            if (o instanceof Type) {
                return Type.getType((String)this.remap(((Type)o).getDescriptor()));
            }
            if (o instanceof String) {
                return this.remap((String)o);
            }
            return o;
        }

        private Object[] remap(int count, Object[] original) {
            if (count == 0) {
                return EMPTY_OBJECT_ARRAY;
            }
            Object[] remapped = new Object[count];
            for (int idx = 0; idx < count; ++idx) {
                remapped[idx] = this.remap(original[idx]);
            }
            return remapped;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, this.remap(desc), this.remap(signature), this.remap(exceptions));
            if (mv != null && (access & 0x400) == 0) {
                mv = new MethodRenamer(mv);
            }
            return mv;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return super.visitField(access, name, this.remap(desc), this.remap(signature), this.remap(value));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(this.remap(name), this.remap(outerName), this.remap(innerName), access);
        }

        public void visitOuterClass(String owner, String name, String desc) {
            super.visitOuterClass(this.remap(owner), this.remap(name), this.remap(desc));
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return super.visitAnnotation(this.remap(desc), visible);
        }

        class MethodRenamer
        extends MethodVisitor {
            public MethodRenamer(MethodVisitor mv) {
                super(589824, mv);
            }

            public void visitTypeInsn(int i, String name) {
                this.mv.visitTypeInsn(i, BuildScriptRemapper.this.remap(name));
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                this.mv.visitFieldInsn(opcode, BuildScriptRemapper.this.remap(owner), name, BuildScriptRemapper.this.remap(desc));
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
                this.mv.visitMethodInsn(opcode, BuildScriptRemapper.this.remap(owner), name, BuildScriptRemapper.this.remap(desc), intf);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                this.mv.visitInvokeDynamicInsn(BuildScriptRemapper.this.remap(name), BuildScriptRemapper.this.remap(descriptor), bootstrapMethodHandle, bootstrapMethodArguments);
            }

            public void visitLdcInsn(Object cst) {
                super.visitLdcInsn(BuildScriptRemapper.this.remap(cst));
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name, BuildScriptRemapper.this.remap(desc), BuildScriptRemapper.this.remap(signature), start, end, index);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return super.visitAnnotation(BuildScriptRemapper.this.remap(desc), visible);
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                super.visitFrame(type, nLocal, BuildScriptRemapper.this.remap(nLocal, local), nStack, BuildScriptRemapper.this.remap(nStack, stack));
            }
        }
    }

    private static class EmptyCompiledScript<T extends Script, M>
    implements CompiledScript<T, M> {
        private final M data;

        public EmptyCompiledScript(CompileOperation<M> operation) {
            this.data = operation.getExtractedData();
        }

        @Override
        public boolean getRunDoesSomething() {
            return false;
        }

        @Override
        public boolean getHasMethods() {
            return false;
        }

        @Override
        public void onReuse() {
        }

        @Override
        public Class<? extends T> loadClass() {
            throw new UnsupportedOperationException("Cannot load a script that does nothing.");
        }

        @Override
        public M getData() {
            return this.data;
        }
    }

    static class ProgressReportingInitializer
    implements Action<PersistentCache> {
        private final ProgressLoggerFactory progressLoggerFactory;
        private final Action<? super PersistentCache> delegate;
        private final String shortDescription;

        public ProgressReportingInitializer(ProgressLoggerFactory progressLoggerFactory, Action<PersistentCache> delegate, String shortDescription) {
            this.progressLoggerFactory = progressLoggerFactory;
            this.delegate = delegate;
            this.shortDescription = shortDescription;
        }

        public void execute(PersistentCache cache) {
            ProgressLogger op = this.progressLoggerFactory.newOperation(FileCacheBackedScriptClassCompiler.class).start(this.shortDescription, this.shortDescription);
            try {
                this.delegate.execute((Object)cache);
            }
            finally {
                op.completed();
            }
        }
    }

    private class CompileToCrossBuildCacheAction
    implements Action<PersistentCache> {
        private final Action<? super ClassNode> verifier;
        private final Class<? extends Script> scriptBaseClass;
        private final ClassLoader classLoader;
        private final CompileOperation<?> operation;
        private final ScriptSource source;

        public <T extends Script> CompileToCrossBuildCacheAction(ScriptSource source, ClassLoader classLoader, CompileOperation<?> operation, Action<? super ClassNode> verifier, Class<T> scriptBaseClass) {
            this.source = source;
            this.classLoader = classLoader;
            this.operation = operation;
            this.verifier = verifier;
            this.scriptBaseClass = scriptBaseClass;
        }

        public void execute(PersistentCache cache) {
            File classesDir = FileCacheBackedScriptClassCompiler.this.classesDir(cache, this.operation);
            File metadataDir = FileCacheBackedScriptClassCompiler.this.metadataDir(cache);
            FileCacheBackedScriptClassCompiler.this.scriptCompilationHandler.compileToDir(this.source, this.classLoader, classesDir, metadataDir, this.operation, this.scriptBaseClass, this.verifier);
        }
    }
}

