/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.Cache;
import io.micronaut.cache.DelegatingAsyncBlockingCache;
import io.micronaut.cache.DelegatingAsyncCache;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface SyncCache<C>
extends Cache<C> {
    @NonNull
    public <T> Optional<T> get(@NonNull Object var1, @NonNull Argument<T> var2);

    public <T> T get(@NonNull Object var1, @NonNull Argument<T> var2, @NonNull Supplier<T> var3);

    @NonNull
    public <T> Optional<T> putIfAbsent(@NonNull Object var1, @NonNull T var2);

    @NonNull
    default public <T> T putIfAbsent(@NonNull Object key, @NonNull Supplier<T> value) {
        T val = value.get();
        return this.putIfAbsent(key, val).orElse(val);
    }

    public void put(@NonNull Object var1, @NonNull Object var2);

    public void invalidate(@NonNull Object var1);

    public void invalidateAll();

    default public <T> T get(@NonNull Object key, @NonNull Class<T> requiredType, @NonNull Supplier<T> supplier) {
        return this.get(key, Argument.of(requiredType), supplier);
    }

    @NonNull
    default public <T> Optional<T> get(@NonNull Object key, @NonNull Class<T> requiredType) {
        return this.get(key, Argument.of(requiredType));
    }

    @Nullable
    default public ExecutorService getExecutorService() {
        return null;
    }

    @NonNull
    default public AsyncCache<C> async() {
        ExecutorService executorService = this.getExecutorService();
        if (executorService == null) {
            return new DelegatingAsyncBlockingCache(this);
        }
        return new DelegatingAsyncCache(this, executorService);
    }
}

