/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.tx.annotation;

import io.micronaut.core.util.ArrayUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

public class BindableRuleBasedTransactionAttribute
extends DefaultTransactionAttribute {
    private final Set<Class<? extends Throwable>> noRollbackFor = new HashSet<Class<? extends Throwable>>();
    private Set<Class<? extends Throwable>> rollbackFor = null;

    public final void setNoRollbackFor(Class<? extends Throwable> ... exceptions) {
        if (ArrayUtils.isNotEmpty((Object[])exceptions)) {
            this.noRollbackFor.addAll(Arrays.asList(exceptions));
        }
    }

    public final void setRollbackFor(Class<? extends Throwable> ... exceptions) {
        if (ArrayUtils.isNotEmpty((Object[])exceptions)) {
            if (this.rollbackFor == null) {
                this.rollbackFor = new HashSet<Class<? extends Throwable>>();
            }
            this.rollbackFor.addAll(Arrays.asList(exceptions));
        }
    }

    public final Set<Class<? extends Throwable>> getNoRollbackFor() {
        return Collections.unmodifiableSet(this.noRollbackFor);
    }

    public final Set<Class<? extends Throwable>> getRollbackFor() {
        if (this.rollbackFor != null) {
            return Collections.unmodifiableSet(this.rollbackFor);
        }
        return Collections.emptySet();
    }

    public final boolean rollbackOn(Throwable ex) {
        if (ex == null) {
            return false;
        }
        for (Class<? extends Throwable> aClass : this.noRollbackFor) {
            if (!aClass.isInstance(ex)) continue;
            return false;
        }
        if (this.rollbackFor != null) {
            for (Class<? extends Throwable> aClass : this.rollbackFor) {
                if (!aClass.isInstance(ex)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

