/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;

final class AixPollPort
extends Port {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int SIZEOF_POLLFD;
    private static final int OFFSETOF_EVENTS;
    private static final int OFFSETOF_REVENTS;
    private static final int OFFSETOF_FD;
    private static final int PS_ADD = 0;
    private static final int PS_MOD = 1;
    private static final int PS_DELETE = 2;
    private static final int MAX_POLL_EVENTS = 512;
    private final int pollset;
    private boolean closed;
    private final int[] sp;
    private final int[] ctlSp;
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private final long address;
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);
    private final HashSet<ControlEvent> controlQueue = new HashSet();
    private final ReentrantLock controlLock = new ReentrantLock();

    AixPollPort(AsynchronousChannelProvider provider, ThreadPool pool) throws IOException {
        super(provider, pool);
        this.pollset = AixPollPort.pollsetCreate();
        int[] sv = new int[2];
        try {
            AixPollPort.socketpair(sv);
            AixPollPort.pollsetCtl(this.pollset, 0, sv[0], Net.POLLIN);
        }
        catch (IOException x) {
            AixPollPort.pollsetDestroy(this.pollset);
            throw x;
        }
        this.sp = sv;
        sv = new int[2];
        try {
            AixPollPort.socketpair(sv);
            AixPollPort.pollsetCtl(this.pollset, 0, sv[0], Net.POLLIN);
        }
        catch (IOException x) {
            AixPollPort.pollsetDestroy(this.pollset);
            throw x;
        }
        this.ctlSp = sv;
        this.address = AixPollPort.allocatePollArray(512);
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    AixPollPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        AixPollPort aixPollPort = this;
        synchronized (aixPollPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        AixPollPort.freePollArray(this.address);
        AixPollPort.close0(this.sp[0]);
        AixPollPort.close0(this.sp[1]);
        AixPollPort.close0(this.ctlSp[0]);
        AixPollPort.close0(this.ctlSp[1]);
        AixPollPort.pollsetDestroy(this.pollset);
    }

    private void wakeup() {
        if (this.wakeupCount.incrementAndGet() == 1) {
            try {
                AixPollPort.interrupt(this.sp[1]);
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable task) {
        AixPollPort aixPollPort = this;
        synchronized (aixPollPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(task);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int nThreads = this.threadCount();
        if (nThreads == 0) {
            this.implClose();
        } else {
            while (nThreads-- > 0) {
                this.wakeup();
            }
        }
    }

    @Override
    void startPoll(int fd, int events) {
        this.queueControlEvent(new ControlEvent(fd, events, false));
    }

    @Override
    void unregisterImpl(int fd) {
        this.queueControlEvent(new ControlEvent(fd, 0, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueControlEvent(ControlEvent ev) {
        HashSet<ControlEvent> hashSet = this.controlQueue;
        synchronized (hashSet) {
            this.controlQueue.add(ev);
            try {
                AixPollPort.interrupt(this.ctlSp[1]);
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
            do {
                if (this.controlLock.tryLock()) {
                    try {
                        this.processControlQueue();
                    }
                    finally {
                        this.controlLock.unlock();
                    }
                } else {
                    try {
                        this.controlQueue.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (this.controlQueue.contains(ev));
        }
        if (ev.error() != 0) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processControlQueue() {
        HashSet<ControlEvent> hashSet = this.controlQueue;
        synchronized (hashSet) {
            Iterator<ControlEvent> iter = this.controlQueue.iterator();
            while (iter.hasNext()) {
                ControlEvent ev = iter.next();
                AixPollPort.pollsetCtl(this.pollset, 2, ev.fd(), 0);
                if (!ev.removeOnly()) {
                    ev.setError(AixPollPort.pollsetCtl(this.pollset, 1, ev.fd(), ev.events()));
                }
                iter.remove();
            }
            this.controlQueue.notifyAll();
        }
    }

    private static long allocatePollArray(int count) {
        return unsafe.allocateMemory(count * SIZEOF_POLLFD);
    }

    private static void freePollArray(long address) {
        unsafe.freeMemory(address);
    }

    private static long getEvent(long address, int i) {
        return address + (long)(SIZEOF_POLLFD * i);
    }

    private static int getDescriptor(long eventAddress) {
        return unsafe.getInt(eventAddress + (long)OFFSETOF_FD);
    }

    private static int getEvents(long eventAddress) {
        return unsafe.getChar(eventAddress + (long)OFFSETOF_EVENTS);
    }

    private static int getRevents(long eventAddress) {
        return unsafe.getChar(eventAddress + (long)OFFSETOF_REVENTS);
    }

    private static native void init();

    private static native int eventSize();

    private static native int eventsOffset();

    private static native int reventsOffset();

    private static native int fdOffset();

    private static native int pollsetCreate() throws IOException;

    private static native int pollsetCtl(int var0, int var1, int var2, int var3);

    private static native int pollsetPoll(int var0, long var1, int var3) throws IOException;

    private static native void pollsetDestroy(int var0);

    private static native void socketpair(int[] var0) throws IOException;

    private static native void interrupt(int var0) throws IOException;

    private static native void drain1(int var0) throws IOException;

    private static native void close0(int var0);

    static /* synthetic */ void access$1800(AixPollPort x0) {
        x0.implClose();
    }

    static {
        IOUtil.load();
        AixPollPort.init();
        SIZEOF_POLLFD = AixPollPort.eventSize();
        OFFSETOF_EVENTS = AixPollPort.eventsOffset();
        OFFSETOF_REVENTS = AixPollPort.reventsOffset();
        OFFSETOF_FD = AixPollPort.fdOffset();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block15: while (true) {
                    int n;
                    AixPollPort.this.controlLock.lock();
                    try {
                        n = AixPollPort.pollsetPoll(AixPollPort.this.pollset, AixPollPort.this.address, 512);
                    }
                    finally {
                        AixPollPort.this.controlLock.unlock();
                    }
                    AixPollPort.this.fdToChannelLock.readLock().lock();
                    try {
                        while (true) {
                            Object object;
                            if (n-- <= 0) continue block15;
                            long eventAddress = AixPollPort.getEvent(AixPollPort.this.address, n);
                            int fd = AixPollPort.getDescriptor(eventAddress);
                            AixPollPort.pollsetCtl(AixPollPort.this.pollset, 2, fd, 0);
                            if (fd == AixPollPort.this.sp[0]) {
                                if (AixPollPort.this.wakeupCount.decrementAndGet() == 0) {
                                    AixPollPort.drain1(AixPollPort.this.sp[0]);
                                }
                                AixPollPort.pollsetCtl(AixPollPort.this.pollset, 0, AixPollPort.this.sp[0], Net.POLLIN);
                                if (n <= 0) {
                                    object = AixPollPort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                    return object;
                                }
                                AixPollPort.this.queue.offer(AixPollPort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                continue;
                            }
                            if (fd == AixPollPort.this.ctlSp[0]) {
                                object = AixPollPort.this.controlQueue;
                                synchronized (object) {
                                    AixPollPort.drain1(AixPollPort.this.ctlSp[0]);
                                    AixPollPort.pollsetCtl(AixPollPort.this.pollset, 0, AixPollPort.this.ctlSp[0], Net.POLLIN);
                                    AixPollPort.this.processControlQueue();
                                    continue;
                                }
                            }
                            Port.PollableChannel channel = (Port.PollableChannel)AixPollPort.this.fdToChannel.get(fd);
                            if (channel == null) continue;
                            int events = AixPollPort.getRevents(eventAddress);
                            Event ev = new Event(channel, events);
                            if (n <= 0) {
                                Event event = ev;
                                return event;
                            }
                            AixPollPort.this.queue.offer(ev);
                        }
                    }
                    finally {
                        AixPollPort.this.fdToChannelLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                AixPollPort.this.queue.offer(AixPollPort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class ControlEvent {
        final int fd;
        final int events;
        final boolean removeOnly;
        int error = 0;

        ControlEvent(int fd, int events, boolean removeOnly) {
            this.fd = fd;
            this.events = events;
            this.removeOnly = removeOnly;
        }

        int fd() {
            return this.fd;
        }

        int events() {
            return this.events;
        }

        boolean removeOnly() {
            return this.removeOnly;
        }

        int error() {
            return this.error;
        }

        void setError(int error) {
            this.error = error;
        }
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;

        Event(Port.PollableChannel channel, int events) {
            this.channel = channel;
            this.events = events;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }
    }
}

