/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.SyntheticLocalType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\"J\u001e\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u001aJ\u0016\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001aJ\u000e\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u001aJ\u000e\u00103\u001a\u00020#2\u0006\u00105\u001a\u00020%J\u000e\u00103\u001a\u00020#2\u0006\u0010,\u001a\u00020\"J\u0016\u00106\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0019J\u000e\u00107\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014RB\u0010\u0015\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u0012\u0004\u0012\u00020\u001a0\u0016j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a0\u0016j\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u0016j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010$\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#0\u0016j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\u00020'*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "bodyGen", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBodyGen", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "loopLevels", "Ljava/util/LinkedHashMap;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LoopLabelType;", "", "Lkotlin/collections/LinkedHashMap;", "nonLocalReturnLevels", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnableBlockSymbol;", "tagIdx", "getTagIdx", "()I", "wasmLocals", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "wasmSyntheticLocals", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/SyntheticLocalType;", "wasmType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "getWasmType", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/SyntheticLocalType;)Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "defineLocal", "", "irValueDeclaration", "defineLoopLevel", "irLoop", "labelType", "level", "defineNonLocalReturnLevel", "block", "referenceLocal", "index", "type", "referenceLoopLevel", "referenceNonLocalReturnLevel", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmFunctionCodegenContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmFunctionCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,97:1\n1#2:98\n372#3,7:99\n*S KotlinDebug\n*F\n+ 1 WasmFunctionCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext\n*L\n69#1:99,7\n*E\n"})
public final class WasmFunctionCodegenContext {
    @NotNull
    private final IrFunction irFunction;
    @NotNull
    private final WasmFunction.Defined wasmFunction;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmModuleCodegenContext context;
    @NotNull
    private final WasmExpressionBuilder bodyGen;
    @NotNull
    private final LinkedHashMap<IrValueSymbol, WasmLocal> wasmLocals;
    @NotNull
    private final LinkedHashMap<SyntheticLocalType, WasmLocal> wasmSyntheticLocals;
    @NotNull
    private final LinkedHashMap<Pair<IrLoop, LoopLabelType>, Integer> loopLevels;
    @NotNull
    private final LinkedHashMap<IrReturnableBlockSymbol, Integer> nonLocalReturnLevels;

    public WasmFunctionCodegenContext(@NotNull IrFunction irFunction2, @NotNull WasmFunction.Defined wasmFunction, @NotNull WasmBackendContext backendContext, @NotNull WasmModuleCodegenContext context2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(wasmFunction, "wasmFunction");
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.irFunction = irFunction2;
        this.wasmFunction = wasmFunction;
        this.backendContext = backendContext;
        this.context = context2;
        this.bodyGen = new WasmIrExpressionBuilder(this.wasmFunction.getInstructions());
        this.wasmLocals = new LinkedHashMap();
        this.wasmSyntheticLocals = new LinkedHashMap();
        this.loopLevels = new LinkedHashMap();
        this.nonLocalReturnLevels = new LinkedHashMap();
    }

    @NotNull
    public final IrFunction getIrFunction() {
        return this.irFunction;
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmExpressionBuilder getBodyGen() {
        return this.bodyGen;
    }

    public final int getTagIdx() {
        return 0;
    }

    public final void defineLocal(@NotNull IrValueSymbol irValueDeclaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter(irValueDeclaration, "irValueDeclaration");
        boolean bl2 = bl = !((Map)this.wasmLocals).containsKey(irValueDeclaration);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WasmFunctionCodegenContext$defineLocal$22 = false;
            String $i$a$-assert-WasmFunctionCodegenContext$defineLocal$22 = "Redefinition of local";
            throw new AssertionError((Object)$i$a$-assert-WasmFunctionCodegenContext$defineLocal$22);
        }
        IrValueDeclaration owner = irValueDeclaration.getOwner();
        int n = this.wasmFunction.getLocals().size();
        String string2 = owner.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        WasmLocal wasmLocal = new WasmLocal(n, string2, owner instanceof IrValueParameter ? this.context.transformValueParameterType((IrValueParameter)owner) : this.context.transformType(owner.getType()), irValueDeclaration instanceof IrValueParameterSymbol);
        ((Map)this.wasmLocals).put(irValueDeclaration, wasmLocal);
        ((Collection)this.wasmFunction.getLocals()).add(wasmLocal);
    }

    @NotNull
    public final WasmLocal referenceLocal(@NotNull IrValueSymbol irValueDeclaration) {
        Intrinsics.checkNotNullParameter(irValueDeclaration, "irValueDeclaration");
        return (WasmLocal)MapsKt.getValue((Map)this.wasmLocals, irValueDeclaration);
    }

    @NotNull
    public final WasmLocal referenceLocal(int index2) {
        return this.wasmFunction.getLocals().get(index2);
    }

    private final WasmType getWasmType(SyntheticLocalType $this$wasmType) {
        WasmType wasmType;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$wasmType.ordinal()]) {
            case 1: {
                wasmType = new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceGcType(this.backendContext.getIrBuiltIns().getAnyClass())));
                break;
            }
            case 2: {
                wasmType = new WasmRefNullType(WasmHeapType.Simple.Any.INSTANCE);
                break;
            }
            case 3: {
                wasmType = WasmI32.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return wasmType;
    }

    @NotNull
    public final WasmLocal referenceLocal(@NotNull SyntheticLocalType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Map $this$getOrPut$iv = this.wasmSyntheticLocals;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get((Object)type2);
        if (value$iv == null) {
            WasmLocal wasmLocal;
            boolean bl = false;
            WasmLocal it = wasmLocal = new WasmLocal(this.wasmFunction.getLocals().size(), type2.name(), this.getWasmType(type2), false);
            boolean bl2 = false;
            ((Collection)this.wasmFunction.getLocals()).add(it);
            WasmLocal answer$iv = wasmLocal;
            $this$getOrPut$iv.put(type2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (WasmLocal)object;
    }

    public final void defineNonLocalReturnLevel(@NotNull IrReturnableBlockSymbol block, int level) {
        Intrinsics.checkNotNullParameter(block, "block");
        Integer n = level;
        ((Map)this.nonLocalReturnLevels).put(block, n);
    }

    public final int referenceNonLocalReturnLevel(@NotNull IrReturnableBlockSymbol block) {
        Intrinsics.checkNotNullParameter(block, "block");
        return ((Number)MapsKt.getValue((Map)this.nonLocalReturnLevels, block)).intValue();
    }

    public final void defineLoopLevel(@NotNull IrLoop irLoop, @NotNull LoopLabelType labelType, int level) {
        boolean bl;
        Intrinsics.checkNotNullParameter(irLoop, "irLoop");
        Intrinsics.checkNotNullParameter((Object)labelType, "labelType");
        Pair<IrLoop, LoopLabelType> loopKey = new Pair<IrLoop, LoopLabelType>(irLoop, labelType);
        boolean bl2 = bl = !((Map)this.loopLevels).containsKey(loopKey);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Redefinition of loop";
            throw new AssertionError((Object)string2);
        }
        Integer n = level;
        ((Map)this.loopLevels).put(loopKey, n);
    }

    public final int referenceLoopLevel(@NotNull IrLoop irLoop, @NotNull LoopLabelType labelType) {
        Intrinsics.checkNotNullParameter(irLoop, "irLoop");
        Intrinsics.checkNotNullParameter((Object)labelType, "labelType");
        return ((Number)MapsKt.getValue((Map)this.loopLevels, new Pair<IrLoop, LoopLabelType>(irLoop, labelType))).intValue();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyntheticLocalType.values().length];
            try {
                nArray[SyntheticLocalType.IS_INTERFACE_PARAMETER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntheticLocalType.TMP_FOR_BR_ON_CAST_EMULATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntheticLocalType.TABLE_SWITCH_SELECTOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

