/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.ConstValueProviderImpl;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmElementAwareStringTable;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmSignatureSerializer;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirAdditionalMetadataAnnotationsProvider;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmFlags;
import org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 x2\u00020\u0001:\u0001xBO\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B\u0099\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u0018\u0012\u0006\u0010\u001e\u001a\u00020\u0018\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010#\u001a\u00020$\u0012\b\u0010%\u001a\u0004\u0018\u00010&\u0012\b\u0010'\u001a\u0004\u0018\u00010(\u00a2\u0006\u0002\u0010)J?\u00106\u001a\u0004\u0018\u0001H7\"\b\b\u0000\u00108*\u000209\"\b\b\u0001\u00107*\u0002092\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u0002H70;2\u0006\u0010<\u001a\u0002H8H\u0002\u00a2\u0006\u0002\u0010=J(\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0016J \u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020J2\u0006\u0010B\u001a\u00020K2\u0006\u0010F\u001a\u00020GH\u0016J\u0018\u0010L\u001a\u00020?2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PH\u0016J \u0010Q\u001a\u00020?2\u0006\u0010M\u001a\u00020R2\u0006\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020PH\u0016J*\u0010U\u001a\u00020?2\u0006\u0010V\u001a\u00020W2\u0006\u0010B\u001a\u00020X2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020GH\u0016J\u0018\u0010Y\u001a\u00020?2\u0006\u0010Z\u001a\u00020[2\u0006\u0010B\u001a\u00020\\H\u0016J*\u0010]\u001a\u00020?2\u0006\u0010^\u001a\u00020\f2\u0006\u0010B\u001a\u00020_2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020GH\u0016J\u001e\u0010`\u001a\u00020?2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020b0\u000b2\u0006\u0010B\u001a\u00020PH\u0016J\u0018\u0010c\u001a\u00020?2\u0006\u0010d\u001a\u00020e2\u0006\u0010B\u001a\u00020fH\u0016J\b\u0010g\u001a\u00020\u0018H\u0016JU\u0010h\u001a\u00020?\"\u000e\b\u0000\u0010i*\b\u0012\u0004\u0012\u0002Hi0j\"\u0014\b\u0001\u0010k*\u000e\u0012\u0004\u0012\u0002Hi\u0012\u0004\u0012\u0002Hk0l2\u0006\u0010B\u001a\u0002Hk2\u0018\u0010m\u001a\u0014\u0012\u0004\u0012\u0002Hi\u0012\n\u0012\b\u0012\u0004\u0012\u00020o0\u000b0nH\u0002\u00a2\u0006\u0002\u0010pJ \u0010q\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010O\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\f\u0010r\u001a\u00020\u0018*\u00020\fH\u0002J\f\u0010s\u001a\u00020\u0018*\u00020WH\u0002J \u0010t\u001a\u00020?*\u00020E2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020w\u0012\u0004\u0012\u00020?0vH\u0002R\u0016\u0010'\u001a\u0004\u0018\u00010(X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u0004\u0018\u00010&X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension;", "Lorg/jetbrains/kotlin/fir/serialization/FirSerializerExtension;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "bindings", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "metadata", "Lorg/jetbrains/kotlin/ir/declarations/MetadataSource;", "localDelegatedProperties", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "approximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;Lorg/jetbrains/kotlin/codegen/state/GenerationState;Lorg/jetbrains/kotlin/ir/declarations/MetadataSource;Ljava/util/List;Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "globalBindings", "useTypeTable", "", "moduleName", "", "classBuilderMode", "Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;", "isParamAssertionsDisabled", "unifiedNullChecks", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "additionalAnnotationsProvider", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataAnnotationsProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;Lorg/jetbrains/kotlin/ir/declarations/MetadataSource;Ljava/util/List;Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;ZLjava/lang/String;Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;ZZLorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/config/JvmDefaultMode;Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataAnnotationsProvider;)V", "getAdditionalAnnotationsProvider", "()Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataAnnotationsProvider;", "getConstValueProvider", "()Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureSerializer", "Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer;", "getStringTable", "()Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "getBinding", "V", "K", "", "slice", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "key", "(Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;Ljava/lang/Object;)Ljava/lang/Object;", "serializeClass", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "versionRequirementTable", "Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "childSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "serializeConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;", "serializeErrorType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeErrorType;", "builder", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "serializeFlexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "lowerProto", "upperProto", "serializeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializePackage", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package$Builder;", "serializeProperty", "property", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "serializeTypeAnnotations", "annotations", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "serializeTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Builder;", "shouldUseTypeTable", "writeLocalProperties", "MessageType", "Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$ExtendableMessage;", "BuilderType", "Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$ExtendableBuilder;", "extension", "Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$GeneratedExtension;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "(Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$ExtendableBuilder;Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$GeneratedExtension;)V", "writeVersionRequirementForJvmDefaultIfNeeded", "isJvmFieldPropertyInInterfaceCompanion", "needsInlineParameterNullCheckRequirement", "writeInlineParameterNullCheckRequirement", "add", "Lkotlin/Function1;", "", "Companion", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmSerializerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirAnnotationUtils.kt\norg/jetbrains/kotlin/fir/declarations/FirAnnotationUtilsKt\n+ 6 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,348:1\n43#2,4:349\n21#2:353\n1747#3,3:354\n1747#3,3:359\n1#4:357\n75#5:358\n67#6,7:362\n*S KotlinDebug\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension\n*L\n227#1:349,4\n228#1:353\n229#1:354,3\n273#1:359,3\n273#1:358\n277#1:362,7\n*E\n"})
public final class FirJvmSerializerExtension
extends FirSerializerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final JvmSerializationBindings bindings;
    @Nullable
    private final MetadataSource metadata;
    @NotNull
    private final List<FirProperty> localDelegatedProperties;
    @NotNull
    private final AbstractTypeApproximator approximator;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final JvmSerializationBindings globalBindings;
    private final boolean useTypeTable;
    @NotNull
    private final String moduleName;
    @NotNull
    private final ClassBuilderMode classBuilderMode;
    private final boolean isParamAssertionsDisabled;
    private final boolean unifiedNullChecks;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final JvmDefaultMode jvmDefaultMode;
    @NotNull
    private final FirElementAwareStringTable stringTable;
    @Nullable
    private final ConstValueProvider constValueProvider;
    @Nullable
    private final FirAdditionalMetadataAnnotationsProvider additionalAnnotationsProvider;
    @NotNull
    private final FirJvmSignatureSerializer signatureSerializer;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirFunction, Method> METHOD_FOR_FIR_FUNCTION;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirProperty, Pair<Type, String>> FIELD_FOR_PROPERTY;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> SYNTHETIC_METHOD_FOR_FIR_VARIABLE;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> DELEGATE_METHOD_FOR_FIR_VARIABLE;
    @NotNull
    private static final FqName JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME;
    @NotNull
    private static final FqName JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME;
    @NotNull
    private static final ClassId JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID;
    @NotNull
    private static final ClassId JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID;

    public FirJvmSerializerExtension(@NotNull FirSession session2, @NotNull JvmSerializationBindings bindings, @Nullable MetadataSource metadata, @NotNull List<? extends FirProperty> localDelegatedProperties, @NotNull AbstractTypeApproximator approximator, @NotNull ScopeSession scopeSession, @NotNull JvmSerializationBindings globalBindings, boolean useTypeTable, @NotNull String moduleName, @NotNull ClassBuilderMode classBuilderMode, boolean isParamAssertionsDisabled, boolean unifiedNullChecks, @NotNull BinaryVersion metadataVersion, @NotNull JvmDefaultMode jvmDefaultMode2, @NotNull FirElementAwareStringTable stringTable2, @Nullable ConstValueProvider constValueProvider, @Nullable FirAdditionalMetadataAnnotationsProvider additionalAnnotationsProvider) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(bindings, "bindings");
        Intrinsics.checkNotNullParameter(localDelegatedProperties, "localDelegatedProperties");
        Intrinsics.checkNotNullParameter(approximator, "approximator");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(globalBindings, "globalBindings");
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(classBuilderMode, "classBuilderMode");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode2, "jvmDefaultMode");
        Intrinsics.checkNotNullParameter(stringTable2, "stringTable");
        this.session = session2;
        this.bindings = bindings;
        this.metadata = metadata;
        this.localDelegatedProperties = localDelegatedProperties;
        this.approximator = approximator;
        this.scopeSession = scopeSession;
        this.globalBindings = globalBindings;
        this.useTypeTable = useTypeTable;
        this.moduleName = moduleName;
        this.classBuilderMode = classBuilderMode;
        this.isParamAssertionsDisabled = isParamAssertionsDisabled;
        this.unifiedNullChecks = unifiedNullChecks;
        this.metadataVersion = metadataVersion;
        this.jvmDefaultMode = jvmDefaultMode2;
        this.stringTable = stringTable2;
        this.constValueProvider = constValueProvider;
        this.additionalAnnotationsProvider = additionalAnnotationsProvider;
        this.signatureSerializer = new FirJvmSignatureSerializer(this.getStringTable());
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    @NotNull
    public FirElementAwareStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    @Nullable
    protected ConstValueProvider getConstValueProvider() {
        return this.constValueProvider;
    }

    @Override
    @Nullable
    protected FirAdditionalMetadataAnnotationsProvider getAdditionalAnnotationsProvider() {
        return this.additionalAnnotationsProvider;
    }

    public FirJvmSerializerExtension(@NotNull FirSession session2, @NotNull JvmSerializationBindings bindings, @NotNull GenerationState state, @Nullable MetadataSource metadata, @NotNull List<? extends FirProperty> localDelegatedProperties, @NotNull AbstractTypeApproximator approximator, @NotNull IrTypeMapper typeMapper2, @NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(bindings, "bindings");
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(localDelegatedProperties, "localDelegatedProperties");
        Intrinsics.checkNotNullParameter(approximator, "approximator");
        Intrinsics.checkNotNullParameter(typeMapper2, "typeMapper");
        Intrinsics.checkNotNullParameter(components2, "components");
        this(session2, bindings, metadata, localDelegatedProperties, approximator, components2.getScopeSession(), state.getGlobalSerializationBindings(), state.getConfig().getUseTypeTableInSerializer(), state.getModuleName(), state.getClassBuilderMode(), state.getConfig().isParamAssertionsDisabled(), state.getConfig().getUnifiedNullChecks(), state.getConfig().getMetadataVersion(), state.getJvmDefaultMode(), new FirJvmElementAwareStringTable(typeMapper2, components2, null, 4, null), new ConstValueProviderImpl(components2), components2.getAnnotationsFromPluginRegistrar().createMetadataAnnotationsProvider());
    }

    @Override
    public boolean shouldUseTypeTable() {
        return this.useTypeTable;
    }

    @Override
    public void serializeClass(@NotNull FirClass klass, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        MetadataSource metadataSource = this.metadata;
        Intrinsics.checkNotNull(metadataSource, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.backend.FirMetadataSource.Class");
        boolean bl = Intrinsics.areEqual(((FirMetadataSource.Class)metadataSource).getFir(), klass);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.getStringTable().getStringIndex(this.moduleName));
        }
        GeneratedMessageLite.ExtendableBuilder extendableBuilder = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Class, List<ProtoBuf.Property>> generatedExtension = JvmProtoBuf.classLocalVariable;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, "classLocalVariable");
        this.writeLocalProperties(extendableBuilder, generatedExtension);
        this.writeVersionRequirementForJvmDefaultIfNeeded(klass, proto, versionRequirementTable);
        if (this.jvmDefaultMode.getForAllMethodsWithBody() && klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE) {
            proto.setExtension(JvmProtoBuf.jvmClassFlags, JvmFlags.INSTANCE.getClassFlags(this.jvmDefaultMode.getForAllMethodsWithBody(), JvmDefaultMode.ALL_COMPATIBILITY == this.jvmDefaultMode && !FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)klass, JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID, this.getSession()) || JvmDefaultMode.ALL_INCOMPATIBLE == this.jvmDefaultMode && FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)klass, JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID, this.getSession())));
        }
    }

    private final void writeVersionRequirementForJvmDefaultIfNeeded(FirClass klass, ProtoBuf.Class.Builder builder2, MutableVersionRequirementTable versionRequirementTable) {
        if (klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE && this.jvmDefaultMode == JvmDefaultMode.ALL_INCOMPATIBLE) {
            builder2.addVersionRequirement(DescriptorSerializer.Companion.writeVersionRequirement(1, 4, 0, ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION, versionRequirementTable));
        }
    }

    @Override
    public void serializePackage(@NotNull FqName packageFqName, @NotNull ProtoBuf.Package.Builder proto) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(proto, "proto");
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.packageModuleName, this.getStringTable().getStringIndex(this.moduleName));
        }
        GeneratedMessageLite.ExtendableBuilder extendableBuilder = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Package, List<ProtoBuf.Property>> generatedExtension = JvmProtoBuf.packageLocalVariable;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, "packageLocalVariable");
        this.writeLocalProperties(extendableBuilder, generatedExtension);
    }

    private final <MessageType extends GeneratedMessageLite.ExtendableMessage<MessageType>, BuilderType extends GeneratedMessageLite.ExtendableBuilder<MessageType, BuilderType>> void writeLocalProperties(BuilderType proto, GeneratedMessageLite.GeneratedExtension<MessageType, List<ProtoBuf.Property>> extension) {
        LanguageVersionSettings languageVersionSettings2 = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession());
        for (FirProperty localVariable : this.localDelegatedProperties) {
            FirElementSerializer serializer2 = FirElementSerializer.Companion.createForLambda(this.getSession(), this.scopeSession, this, this.approximator, languageVersionSettings2);
            ProtoBuf.Property.Builder builder2 = serializer2.propertyProto(localVariable);
            ProtoBuf.Property property = builder2 != null ? builder2.build() : null;
            if (property == null) continue;
            proto.addExtension(extension, (ProtoBuf.Property)property);
        }
    }

    @Override
    public void serializeFlexibleType(@NotNull ConeFlexibleType type2, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(lowerProto, "lowerProto");
        Intrinsics.checkNotNullParameter(upperProto, "upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex("kotlin.jvm.PlatformType"));
        if (type2 instanceof ConeRawType) {
            lowerProto.setExtension(JvmProtoBuf.isRaw, true);
            upperProto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    public void serializeTypeAnnotations(@NotNull List<? extends FirAnnotation> annotations2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (FirAnnotation firAnnotation : annotations2) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.getAnnotationSerializer().serializeAnnotation(firAnnotation));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull FirTypeParameter typeParameter2, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        Intrinsics.checkNotNullParameter(typeParameter2, "typeParameter");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (FirAnnotation annotation2 : FirAnnotationUtilsKt.nonSourceAnnotations(typeParameter2, this.getSession())) {
            proto.addExtension(JvmProtoBuf.typeParameterAnnotation, this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull FirConstructor constructor2, @NotNull ProtoBuf.Constructor.Builder proto, @NotNull FirElementSerializer childSerializer) {
        JvmProtoBuf.JvmMethodSignature signature2;
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        Method method = this.getBinding(METHOD_FOR_FIR_FUNCTION, constructor2);
        if (method != null && (signature2 = this.signatureSerializer.methodSignature(constructor2, null, method)) != null) {
            proto.setExtension(JvmProtoBuf.constructorSignature, signature2);
        }
    }

    @Override
    public void serializeFunction(@NotNull FirFunction function2, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        block3: {
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
            Method method = this.getBinding(METHOD_FOR_FIR_FUNCTION, function2);
            if (method != null) {
                FirSimpleFunction firSimpleFunction = function2 instanceof FirSimpleFunction ? (FirSimpleFunction)function2 : null;
                JvmProtoBuf.JvmMethodSignature signature2 = this.signatureSerializer.methodSignature(function2, firSimpleFunction != null ? firSimpleFunction.getName() : null, method);
                if (signature2 != null) {
                    proto.setExtension(JvmProtoBuf.methodSignature, signature2);
                }
            }
            if (!this.needsInlineParameterNullCheckRequirement(function2)) break block3;
            MutableVersionRequirementTable mutableVersionRequirementTable = versionRequirementTable;
            if (mutableVersionRequirementTable != null) {
                this.writeInlineParameterNullCheckRequirement(mutableVersionRequirementTable, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>((Object)proto){

                    public final void invoke(int p0) {
                        ((ProtoBuf.Function.Builder)this.receiver).addVersionRequirement(p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "serializeFunction$addVersionRequirement(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;I)V";
                    }

                    @NotNull
                    public final String getName() {
                        return "addVersionRequirement";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
                    }
                });
            }
        }
    }

    private final void writeInlineParameterNullCheckRequirement(MutableVersionRequirementTable $this$writeInlineParameterNullCheckRequirement, Function1<? super Integer, Unit> add2) {
        if (this.unifiedNullChecks) {
            add2.invoke((Integer)DescriptorSerializer.Companion.writeVersionRequirement(1, 3, 50, ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION, $this$writeInlineParameterNullCheckRequirement));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needsInlineParameterNullCheckRequirement(FirFunction $this$needsInlineParameterNullCheckRequirement) {
        boolean bl;
        if (!($this$needsInlineParameterNullCheckRequirement instanceof FirSimpleFunction)) return false;
        FirMemberDeclaration $this$isInline$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) return false;
        FirMemberDeclaration $this$isSuspend$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getStatus().isSuspend()) return false;
        if (this.isParamAssertionsDisabled) return false;
        FirMemberDeclaration $this$visibility$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$getVisibility = false;
        if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) return false;
        Iterable $this$any$iv = $this$needsInlineParameterNullCheckRequirement.getValueParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FirValueParameter it = (FirValueParameter)element$iv;
                boolean bl2 = false;
                if (!FunctionalTypeUtilsKt.isSomeFunctionType(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), this.getSession())) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        FirReceiverParameter firReceiverParameter = $this$needsInlineParameterNullCheckRequirement.getReceiverParameter();
        Object object = firReceiverParameter;
        if (firReceiverParameter == null) return false;
        FirTypeRef firTypeRef = ((FirReceiverParameter)object).getTypeRef();
        object = firTypeRef;
        if (firTypeRef == null) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)object);
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!FunctionalTypeUtilsKt.isSomeFunctionType((ConeKotlinType)object, this.getSession())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serializeProperty(@NotNull FirProperty property, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        block7: {
            block6: {
                boolean bl;
                boolean bl2;
                Intrinsics.checkNotNullParameter(property, "property");
                Intrinsics.checkNotNullParameter(proto, "proto");
                Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
                FirPropertyAccessor getter2 = property.getGetter();
                FirPropertyAccessor setter2 = property.getSetter();
                Method getterMethod = getter2 == null ? null : this.getBinding(METHOD_FOR_FIR_FUNCTION, getter2);
                Method setterMethod = setter2 == null ? null : this.getBinding(METHOD_FOR_FIR_FUNCTION, setter2);
                Pair<Type, String> field2 = this.getBinding(FIELD_FOR_PROPERTY, property);
                Method syntheticMethod = this.getBinding(SYNTHETIC_METHOD_FOR_FIR_VARIABLE, property);
                Method delegateMethod = this.getBinding(DELEGATE_METHOD_FOR_FIR_VARIABLE, property);
                boolean bl3 = bl2 = property.getDelegate() != null || delegateMethod == null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string2 = "non-delegated property " + UtilsKt.render(property) + " has delegate method";
                    throw new AssertionError((Object)string2);
                }
                FirJvmSignatureSerializer firJvmSignatureSerializer = this.signatureSerializer;
                Name name2 = property.getName();
                Pair<Type, String> pair = field2;
                String string3 = pair != null ? pair.getSecond() : null;
                Pair<Type, String> pair2 = field2;
                String string4 = pair2 != null && (pair2 = pair2.getFirst()) != null ? ((Type)((Object)pair2)).getDescriptor() : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature = syntheticMethod != null ? this.signatureSerializer.methodSignature(null, null, syntheticMethod) : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature2 = delegateMethod != null ? this.signatureSerializer.methodSignature(null, null, delegateMethod) : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature3 = getterMethod != null ? this.signatureSerializer.methodSignature(null, null, getterMethod) : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature4 = setterMethod != null ? this.signatureSerializer.methodSignature(null, null, setterMethod) : null;
                Pair<Type, String> pair3 = field2;
                if (pair3 != null && (pair3 = pair3.getFirst()) != null && (pair3 = ((Type)((Object)pair3)).getDescriptor()) != null) {
                    void it;
                    Pair<Type, String> pair4 = pair3;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature5 = jvmMethodSignature4;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature6 = jvmMethodSignature3;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature7 = jvmMethodSignature2;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature8 = jvmMethodSignature;
                    String string5 = string4;
                    String string6 = string3;
                    Name name3 = name2;
                    FirJvmSignatureSerializer firJvmSignatureSerializer2 = firJvmSignatureSerializer;
                    boolean bl5 = false;
                    boolean bl6 = this.signatureSerializer.requiresPropertySignature(property, (String)it);
                    firJvmSignatureSerializer = firJvmSignatureSerializer2;
                    name2 = name3;
                    string3 = string6;
                    string4 = string5;
                    jvmMethodSignature = jvmMethodSignature8;
                    jvmMethodSignature2 = jvmMethodSignature7;
                    jvmMethodSignature3 = jvmMethodSignature6;
                    jvmMethodSignature4 = jvmMethodSignature5;
                    bl = bl6;
                } else {
                    bl = false;
                }
                JvmProtoBuf.JvmPropertySignature signature2 = firJvmSignatureSerializer.propertySignature(name2, string3, string4, jvmMethodSignature, jvmMethodSignature2, jvmMethodSignature3, jvmMethodSignature4, bl);
                if (signature2 != null) {
                    proto.setExtension(JvmProtoBuf.propertySignature, signature2);
                }
                if (this.isJvmFieldPropertyInInterfaceCompanion(property) && versionRequirementTable != null) {
                    proto.setExtension(JvmProtoBuf.flags, JvmFlags.INSTANCE.getPropertyFlags(true));
                }
                FirPropertyAccessor firPropertyAccessor = getter2;
                if (firPropertyAccessor != null ? this.needsInlineParameterNullCheckRequirement(firPropertyAccessor) : false) break block6;
                FirPropertyAccessor firPropertyAccessor2 = setter2;
                boolean bl7 = firPropertyAccessor2 != null ? this.needsInlineParameterNullCheckRequirement(firPropertyAccessor2) : false;
                if (!bl7) break block7;
            }
            MutableVersionRequirementTable mutableVersionRequirementTable = versionRequirementTable;
            if (mutableVersionRequirementTable != null) {
                this.writeInlineParameterNullCheckRequirement(mutableVersionRequirementTable, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>((Object)proto){

                    public final void invoke(int p0) {
                        ((ProtoBuf.Property.Builder)this.receiver).addVersionRequirement(p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "serializeProperty$addVersionRequirement$3(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;I)V";
                    }

                    @NotNull
                    public final String getName() {
                        return "addVersionRequirement";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isJvmFieldPropertyInInterfaceCompanion(FirProperty $this$isJvmFieldPropertyInInterfaceCompanion) {
        FirRegularClass firRegularClass;
        FirRegularClassSymbol containerSymbol;
        block14: {
            block13: {
                boolean bl;
                void $this$hasJvmFieldAnnotation$iv;
                FirProperty firProperty = $this$isJvmFieldPropertyInInterfaceCompanion;
                FirSession session$iv = this.getSession();
                boolean $i$f$hasJvmFieldAnnotation22 = false;
                Object object = $this$hasJvmFieldAnnotation$iv.getBackingField();
                if (object != null && (object = ((FirBackingField)object).getAnnotations()) != null) {
                    boolean bl2;
                    block12: {
                        Iterable $this$any$iv$iv = (Iterable)object;
                        boolean $i$f$any = false;
                        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv$iv : $this$any$iv$iv) {
                                FirAnnotation it$iv = (FirAnnotation)element$iv$iv;
                                boolean bl3 = false;
                                if (!FirAnnotationUtilsKt.isJvmFieldAnnotation(it$iv, session$iv)) continue;
                                bl2 = true;
                                break block12;
                            }
                            bl2 = false;
                        }
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                if (!bl) {
                    return false;
                }
                ConeSimpleKotlinType $i$f$hasJvmFieldAnnotation22 = $this$isJvmFieldPropertyInInterfaceCompanion.getDispatchReceiverType();
                Object object2 = $i$f$hasJvmFieldAnnotation22 instanceof ConeClassLikeType ? (ConeClassLikeType)$i$f$hasJvmFieldAnnotation22 : null;
                FirRegularClassSymbol firRegularClassSymbol = object2 != null && (object2 = ((ConeClassLikeType)object2).getLookupTag()) != null ? LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object2, this.getSession()) : (containerSymbol = null);
                if (containerSymbol == null) break block13;
                FirClassLikeSymbol $this$isCompanion$iv = containerSymbol;
                boolean $i$f$isCompanion = false;
                if (!$this$isCompanion$iv.getRawStatus().isCompanion()) break block13;
                FirClassLikeSymbol $this$isLocal$iv = containerSymbol;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getClassId().isLocal()) break block14;
            }
            return false;
        }
        ClassId classId = containerSymbol.getClassId().getOuterClassId();
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            FirClassLikeDeclaration firClassLikeDeclaration = FirProviderKt.getFirProvider(this.getSession()).getFirClassifierByFqName(it);
            firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        } else {
            firRegularClass = null;
        }
        FirRegularClass grandParent = firRegularClass;
        return grandParent != null && (grandParent.getClassKind() == ClassKind.INTERFACE || grandParent.getClassKind() == ClassKind.ANNOTATION_CLASS);
    }

    @Override
    public void serializeErrorType(@NotNull ConeErrorType type2, @NotNull ProtoBuf.Type.Builder builder2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        if (this.classBuilderMode == ClassBuilderMode.KAPT3) {
            builder2.setClassName(this.getStringTable().getStringIndex("error/NonExistentClass"));
            return;
        }
        super.serializeErrorType(type2, builder2);
    }

    private final <K, V> V getBinding(JvmSerializationBindings.SerializationMappingSlice<K, V> slice, K key) {
        V v = this.bindings.get(slice, key);
        if (v == null) {
            v = this.globalBindings.get(slice, key);
        }
        return v;
    }

    static {
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice, "create(...)");
        METHOD_FOR_FIR_FUNCTION = serializationMappingSlice;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice2 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice2, "create(...)");
        FIELD_FOR_PROPERTY = serializationMappingSlice2;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice3 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice3, "create(...)");
        SYNTHETIC_METHOD_FOR_FIR_VARIABLE = serializationMappingSlice3;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice4 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice4, "create(...)");
        DELEGATE_METHOD_FOR_FIR_VARIABLE = serializationMappingSlice4;
        JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithoutCompatibility");
        JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithCompatibility");
        ClassId classId = ClassId.topLevel(JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME);
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(...)");
        JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID = classId;
        ClassId classId2 = ClassId.topLevel(JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME);
        Intrinsics.checkNotNullExpressionValue(classId2, "topLevel(...)");
        JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID = classId2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R-\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRE\u0010\n\u001a6\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b\u0012$\u0012\"\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e \u0006*\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f0\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0016\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR-\u0010\u0019\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension$Companion;", "", "()V", "DELEGATE_METHOD_FOR_FIR_VARIABLE", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "getDELEGATE_METHOD_FOR_FIR_VARIABLE", "()Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "FIELD_FOR_PROPERTY", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lkotlin/Pair;", "Lorg/jetbrains/org/objectweb/asm/Type;", "", "getFIELD_FOR_PROPERTY", "JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID", "JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME", "METHOD_FOR_FIR_FUNCTION", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getMETHOD_FOR_FIR_FUNCTION", "SYNTHETIC_METHOD_FOR_FIR_VARIABLE", "getSYNTHETIC_METHOD_FOR_FIR_VARIABLE", "jvm-backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirFunction, Method> getMETHOD_FOR_FIR_FUNCTION() {
            return METHOD_FOR_FIR_FUNCTION;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirProperty, Pair<Type, String>> getFIELD_FOR_PROPERTY() {
            return FIELD_FOR_PROPERTY;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> getSYNTHETIC_METHOD_FOR_FIR_VARIABLE() {
            return SYNTHETIC_METHOD_FOR_FIR_VARIABLE;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> getDELEGATE_METHOD_FOR_FIR_VARIABLE() {
            return DELEGATE_METHOD_FOR_FIR_VARIABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

