/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.serialization.JvmSignatureSerializer;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ClassMapperLite;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\bH\u0014J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer;", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSignatureSerializer;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "(Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;)V", "mapTypeDefault", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "requiresFunctionSignature", "", "descriptor", "desc", "requiresPropertySignature", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmSerializerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,348:1\n25#2,4:349\n*S KotlinDebug\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer\n*L\n344#1:349,4\n*E\n"})
public final class FirJvmSignatureSerializer
extends JvmSignatureSerializer<FirFunction, FirProperty> {
    public FirJvmSignatureSerializer(@NotNull FirElementAwareStringTable stringTable2) {
        Intrinsics.checkNotNullParameter(stringTable2, "stringTable");
        super(stringTable2);
    }

    @Override
    protected boolean requiresFunctionSignature(@NotNull FirFunction descriptor2, @NotNull String desc) {
        FirTypeRef receiverTypeRef;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(desc, "desc");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        FirReceiverParameter firReceiverParameter = descriptor2.getReceiverParameter();
        FirTypeRef firTypeRef = receiverTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        if (receiverTypeRef != null) {
            String string2 = this.mapTypeDefault(receiverTypeRef);
            if (string2 == null) {
                return true;
            }
            String receiverDesc = string2;
            sb.append(receiverDesc);
        }
        for (FirValueParameter valueParameter2 : descriptor2.getValueParameters()) {
            String paramDesc;
            if (this.mapTypeDefault(valueParameter2.getReturnTypeRef()) == null) {
                return true;
            }
            sb.append(paramDesc);
        }
        sb.append(")");
        FirTypeRef returnTypeRef = descriptor2.getReturnTypeRef();
        String string3 = this.mapTypeDefault(returnTypeRef);
        if (string3 == null) {
            return true;
        }
        String returnTypeDesc = string3;
        sb.append(returnTypeDesc);
        return !Intrinsics.areEqual(sb.toString(), desc);
    }

    @Override
    public boolean requiresPropertySignature(@NotNull FirProperty descriptor2, @NotNull String desc) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(desc, "desc");
        return !Intrinsics.areEqual(desc, this.mapTypeDefault(descriptor2.getReturnTypeRef()));
    }

    private final String mapTypeDefault(FirTypeRef typeRef) {
        String string2;
        ClassId classId;
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        ClassId classId2 = classId = coneClassLikeType != null ? ConeTypeUtilsKt.getClassId(coneClassLikeType) : null;
        if (classId2 == null) {
            string2 = null;
        } else {
            String string3 = classId2.asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            string2 = ClassMapperLite.mapClass(string3);
        }
        return string2;
    }
}

