/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/ClassIdCalculator;", "", "()V", "calculateClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "psi"})
@SourceDebugExtension(value={"SMAP\nClassIdCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassIdCalculator.kt\norg/jetbrains/kotlin/psi/psiUtil/ClassIdCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1549#2:47\n1620#2,3:48\n*S KotlinDebug\n*F\n+ 1 ClassIdCalculator.kt\norg/jetbrains/kotlin/psi/psiUtil/ClassIdCalculator\n*L\n40#1:47\n40#1:48,3\n*E\n"})
public final class ClassIdCalculator {
    @NotNull
    public static final ClassIdCalculator INSTANCE = new ClassIdCalculator();

    private ClassIdCalculator() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassId calculateClassId(@NotNull KtClassLikeDeclaration declaration) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        KtFile ktFile = null;
        List containingClasses = new ArrayList();
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(declaration).iterator();
        while (iterator2.hasNext()) {
            PsiElement element = iterator2.next();
            PsiElement psiElement = element;
            if (psiElement instanceof KtEnumEntry) {
                return null;
            }
            if (psiElement instanceof KtClassLikeDeclaration) {
                ((Collection)containingClasses).add(element);
                continue;
            }
            if (psiElement instanceof KtFile) {
                ktFile = (KtFile)element;
                break;
            }
            if (psiElement instanceof KtScript || !(psiElement instanceof KtDeclaration ? true : psiElement instanceof KtObjectLiteralExpression)) continue;
            return null;
        }
        if (ktFile == null) {
            return null;
        }
        Iterable $this$map$iv = CollectionsKt.reversed(containingClasses);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void containingClass;
            KtClassLikeDeclaration ktClassLikeDeclaration = (KtClassLikeDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = containingClass.getName();
            if (string2 == null) {
                string2 = SpecialNames.NO_NAME_PROVIDED.asString();
            }
            collection.add(string2);
        }
        FqName fqName2 = FqName.fromSegments((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue(fqName2, "fromSegments(...)");
        FqName relativeClassName2 = fqName2;
        return new ClassId(ktFile.getPackageFqName(), relativeClassName2, false);
    }
}

