/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.io.stream;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public interface Writeable {
    public void writeTo(StreamOutput var1) throws IOException;

    @FunctionalInterface
    public static interface Reader<V> {
        public V read(StreamInput var1) throws IOException;
    }

    @FunctionalInterface
    public static interface Writer<V> {
        public void write(StreamOutput var1, V var2) throws IOException;
    }

    public static class WriteableRegistry {
        private static final Map<Class<?>, Writer<?>> WRITER_REGISTRY = new ConcurrentHashMap();
        private static final Map<Class<?>, Class<?>> WRITER_CUSTOM_CLASS_MAP = new ConcurrentHashMap();
        private static final Map<Byte, Reader<?>> READER_REGISTRY = new ConcurrentHashMap();

        public static <W extends Writer<?>> void registerWriter(Class<?> clazz, W writer) {
            if (WRITER_REGISTRY.putIfAbsent(clazz, writer) != null) {
                throw new IllegalArgumentException("Streamable writer already registered for type [" + clazz.getName() + "]");
            }
        }

        public static <R extends Reader<?>> void registerReader(byte ordinal, R reader) {
            if (READER_REGISTRY.putIfAbsent(ordinal, reader) != null) {
                throw new IllegalArgumentException("Streamable reader already registered for ordinal [" + ordinal + "]");
            }
        }

        public static void registerClassAlias(Class<?> classInstance, Class<?> classGeneric) {
            if (WRITER_CUSTOM_CLASS_MAP.putIfAbsent(classInstance, classGeneric) != null) {
                throw new IllegalArgumentException("Streamable custom class already registered [" + classInstance.getClass() + "]");
            }
        }

        public static <W extends Writer<?>> W getWriter(Class<?> clazz) {
            return (W)WRITER_REGISTRY.get(clazz);
        }

        public static <R extends Reader<?>> R getReader(byte b) {
            return (R)READER_REGISTRY.get(b);
        }

        public static Class<?> getCustomClassFromInstance(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Attempting to retrieve a class type from a null value");
            }
            for (Class<?> clazz : WRITER_CUSTOM_CLASS_MAP.values()) {
                if (!clazz.isInstance(value)) continue;
                return clazz;
            }
            return null;
        }
    }
}

