/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.search.MultiSearchAction;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.OpenSearchClient;

public class MultiSearchRequestBuilder
extends ActionRequestBuilder<MultiSearchRequest, MultiSearchResponse> {
    public MultiSearchRequestBuilder(OpenSearchClient client, MultiSearchAction action) {
        super(client, action, new MultiSearchRequest());
    }

    public MultiSearchRequestBuilder add(SearchRequest request) {
        if (request.indicesOptions() == IndicesOptions.strictExpandOpenAndForbidClosed() && ((MultiSearchRequest)this.request()).indicesOptions() != IndicesOptions.strictExpandOpenAndForbidClosed()) {
            request.indicesOptions(((MultiSearchRequest)this.request()).indicesOptions());
        }
        ((MultiSearchRequest)this.request).add(request);
        return this;
    }

    public MultiSearchRequestBuilder add(SearchRequestBuilder request) {
        if (((SearchRequest)request.request()).indicesOptions() == SearchRequest.DEFAULT_INDICES_OPTIONS && ((MultiSearchRequest)this.request()).indicesOptions() != SearchRequest.DEFAULT_INDICES_OPTIONS) {
            ((SearchRequest)request.request()).indicesOptions(((MultiSearchRequest)this.request()).indicesOptions());
        }
        ((MultiSearchRequest)this.request).add(request);
        return this;
    }

    public MultiSearchRequestBuilder setIndicesOptions(IndicesOptions indicesOptions) {
        ((MultiSearchRequest)this.request()).indicesOptions(indicesOptions);
        return this;
    }

    public MultiSearchRequestBuilder setMaxConcurrentSearchRequests(int maxConcurrentSearchRequests) {
        ((MultiSearchRequest)this.request()).maxConcurrentSearchRequests(maxConcurrentSearchRequests);
        return this;
    }
}

