/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor.transform;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.WeightedTransformer;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.Arrays;

public class DifferenceTransformer
extends WeightedTransformer {
    public DifferenceTransformer(double[] weights, Deviation[] deviation) {
        super(weights, deviation);
    }

    @Override
    public double[] invert(double[] values, double[] previousInput) {
        double[] output = super.invert(values, previousInput);
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            output[n] = output[n] + previousInput[i];
        }
        return output;
    }

    @Override
    public void invertForecastRange(RangeVector ranges, int baseDimension, double[] previousInput, double[] correction) {
        int inputLength = this.weights.length;
        int horizon = ranges.values.length / baseDimension;
        double[] last = Arrays.copyOf(previousInput, previousInput.length);
        CommonUtils.checkArgument((correction.length >= inputLength ? 1 : 0) != 0, (String)" incorrect length ");
        for (int i = 0; i < horizon; ++i) {
            for (int j = 0; j < inputLength; ++j) {
                float weight = this.weights[j] == 0.0 ? 0.0f : 1.0f / (float)this.weights[j];
                ranges.scale(i * baseDimension + j, weight);
                ranges.shift(i * baseDimension + j, (float)(this.getShift(j, this.deviations) + last[j]));
                last[j] = ranges.values[j];
            }
        }
    }

    @Override
    public double[] transformValues(int internalTimeStamp, double[] inputPoint, double[] previousInput, Deviation[] initials, double clipFactor) {
        double[] input = new double[inputPoint.length];
        for (int i = 0; i < input.length; ++i) {
            input[i] = internalTimeStamp == 0 ? 0.0 : inputPoint[i] - previousInput[i];
        }
        return super.transformValues(internalTimeStamp, input, null, initials, clipFactor);
    }

    @Override
    public double[] getShift(double[] previous) {
        double[] answer = new double[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            answer[i] = this.getShift(i, this.deviations) + previous[i];
        }
        return answer;
    }
}

