/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchTemplateErrorCode {
    LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST("launchTemplateIdDoesNotExist"),
    LAUNCH_TEMPLATE_ID_MALFORMED("launchTemplateIdMalformed"),
    LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST("launchTemplateNameDoesNotExist"),
    LAUNCH_TEMPLATE_NAME_MALFORMED("launchTemplateNameMalformed"),
    LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST("launchTemplateVersionDoesNotExist"),
    UNEXPECTED_ERROR("unexpectedError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchTemplateErrorCode> VALUE_MAP;
    private final String value;

    private LaunchTemplateErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchTemplateErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchTemplateErrorCode> knownValues() {
        EnumSet<LaunchTemplateErrorCode> knownValues = EnumSet.allOf(LaunchTemplateErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchTemplateErrorCode.class, LaunchTemplateErrorCode::toString);
    }
}

