/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery;

public class DescribeIpamResourceDiscoveriesPublisher
implements SdkPublisher<DescribeIpamResourceDiscoveriesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpamResourceDiscoveriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpamResourceDiscoveriesPublisher(Ec2AsyncClient client, DescribeIpamResourceDiscoveriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpamResourceDiscoveriesPublisher(Ec2AsyncClient client, DescribeIpamResourceDiscoveriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpamResourceDiscoveriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpamResourceDiscoveriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamResourceDiscovery> ipamResourceDiscoveries() {
        Function<DescribeIpamResourceDiscoveriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamResourceDiscoveries() != null) {
                return response.ipamResourceDiscoveries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeIpamResourceDiscoveriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeIpamResourceDiscoveriesResponseFetcher
    implements AsyncPageFetcher<DescribeIpamResourceDiscoveriesResponse> {
        private DescribeIpamResourceDiscoveriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamResourceDiscoveriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpamResourceDiscoveriesResponse> nextPage(DescribeIpamResourceDiscoveriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamResourceDiscoveriesPublisher.this.client.describeIpamResourceDiscoveries(DescribeIpamResourceDiscoveriesPublisher.this.firstRequest);
            }
            return DescribeIpamResourceDiscoveriesPublisher.this.client.describeIpamResourceDiscoveries((DescribeIpamResourceDiscoveriesRequest)((Object)DescribeIpamResourceDiscoveriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

