/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.crt.http.Http2ConnectionSetting;

public class Http2ConnectionSettingListBuilder {
    private List<Http2ConnectionSetting> settings = new ArrayList<Http2ConnectionSetting>();

    public Http2ConnectionSettingListBuilder addSetting(Http2ConnectionSetting setting) {
        this.settings.add(setting);
        return this;
    }

    public Http2ConnectionSettingListBuilder headerTableSize(long headerTableSize) {
        this.settings.add(new Http2ConnectionSetting(Http2ConnectionSetting.ID.HEADER_TABLE_SIZE, headerTableSize));
        return this;
    }

    public Http2ConnectionSettingListBuilder enablePush(boolean push) {
        this.settings.add(new Http2ConnectionSetting(Http2ConnectionSetting.ID.ENABLE_PUSH, push ? 1L : 0L));
        return this;
    }

    public Http2ConnectionSettingListBuilder maxConcurrentStreams(long maxConcurrentStreams) {
        this.settings.add(new Http2ConnectionSetting(Http2ConnectionSetting.ID.MAX_CONCURRENT_STREAMS, maxConcurrentStreams));
        return this;
    }

    public Http2ConnectionSettingListBuilder initialWindowSize(long initialWindowSize) {
        this.settings.add(new Http2ConnectionSetting(Http2ConnectionSetting.ID.INITIAL_WINDOW_SIZE, initialWindowSize));
        return this;
    }

    public Http2ConnectionSettingListBuilder maxFrameSize(long maxFrameSize) {
        this.settings.add(new Http2ConnectionSetting(Http2ConnectionSetting.ID.MAX_FRAME_SIZE, maxFrameSize));
        return this;
    }

    public Http2ConnectionSettingListBuilder maxHeaderListSize(long maxHeaderListSize) {
        this.settings.add(new Http2ConnectionSetting(Http2ConnectionSetting.ID.MAX_HEADER_LIST_SIZE, maxHeaderListSize));
        return this;
    }

    public List<Http2ConnectionSetting> build() {
        return this.settings;
    }
}

