/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceCapacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceCapacity> {
    private static final SdkField<Integer> AVAILABLE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableCapacity").getter(InstanceCapacity.getter(InstanceCapacity::availableCapacity)).setter(InstanceCapacity.setter(Builder::availableCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableCapacity").unmarshallLocationName("availableCapacity").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceCapacity.getter(InstanceCapacity::instanceType)).setter(InstanceCapacity.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Integer> TOTAL_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCapacity").getter(InstanceCapacity.getter(InstanceCapacity::totalCapacity)).setter(InstanceCapacity.setter(Builder::totalCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCapacity").unmarshallLocationName("totalCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_CAPACITY_FIELD, INSTANCE_TYPE_FIELD, TOTAL_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceCapacity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer availableCapacity;
    private final String instanceType;
    private final Integer totalCapacity;

    private InstanceCapacity(BuilderImpl builder) {
        this.availableCapacity = builder.availableCapacity;
        this.instanceType = builder.instanceType;
        this.totalCapacity = builder.totalCapacity;
    }

    public final Integer availableCapacity() {
        return this.availableCapacity;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer totalCapacity() {
        return this.totalCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCapacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCapacity)) {
            return false;
        }
        InstanceCapacity other = (InstanceCapacity)obj;
        return Objects.equals(this.availableCapacity(), other.availableCapacity()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.totalCapacity(), other.totalCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceCapacity").add("AvailableCapacity", (Object)this.availableCapacity()).add("InstanceType", (Object)this.instanceType()).add("TotalCapacity", (Object)this.totalCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailableCapacity": {
                return Optional.ofNullable(clazz.cast(this.availableCapacity()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "TotalCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailableCapacity", AVAILABLE_CAPACITY_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("TotalCapacity", TOTAL_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceCapacity, T> g) {
        return obj -> g.apply((InstanceCapacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer availableCapacity;
        private String instanceType;
        private Integer totalCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCapacity model) {
            this.availableCapacity(model.availableCapacity);
            this.instanceType(model.instanceType);
            this.totalCapacity(model.totalCapacity);
        }

        public final Integer getAvailableCapacity() {
            return this.availableCapacity;
        }

        public final void setAvailableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
        }

        @Override
        public final Builder availableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getTotalCapacity() {
            return this.totalCapacity;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public InstanceCapacity build() {
            return new InstanceCapacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceCapacity> {
        public Builder availableCapacity(Integer var1);

        public Builder instanceType(String var1);

        public Builder totalCapacity(Integer var1);
    }
}

