/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.net;

import io.grpc.stub.StreamObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.grpc.SubscribeResponse;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.net.NodeStateManager;
import org.opensearch.performanceanalyzer.rca.net.SubscriptionManager;

public class SubscribeResponseHandler
implements StreamObserver<SubscribeResponse> {
    private static final Logger LOG = LogManager.getLogger(SubscribeResponseHandler.class);
    private final SubscriptionManager subscriptionManager;
    private final NodeStateManager nodeStateManager;
    private final InstanceDetails.Id remoteHostId;
    private final String graphNode;

    public SubscribeResponseHandler(SubscriptionManager subscriptionManager, NodeStateManager nodeStateManager, InstanceDetails remoteHost, String graphNode) {
        this.subscriptionManager = subscriptionManager;
        this.nodeStateManager = nodeStateManager;
        this.graphNode = graphNode;
        this.remoteHostId = remoteHost.getInstanceId();
    }

    public void onNext(SubscribeResponse subscribeResponse) {
        if (subscribeResponse.getSubscriptionStatus() == SubscribeResponse.SubscriptionStatus.SUCCESS) {
            this.subscriptionManager.addPublisher(this.graphNode, this.remoteHostId);
            this.nodeStateManager.updateSubscriptionState(this.graphNode, this.remoteHostId, SubscribeResponse.SubscriptionStatus.SUCCESS);
        } else if (subscribeResponse.getSubscriptionStatus() == SubscribeResponse.SubscriptionStatus.TAG_MISMATCH) {
            this.nodeStateManager.updateSubscriptionState(this.graphNode, this.remoteHostId, SubscribeResponse.SubscriptionStatus.TAG_MISMATCH);
        }
    }

    public void onError(Throwable t) {
        LOG.error("Encountered an error while processing subscription stream", t);
    }

    public void onCompleted() {
        LOG.info("Finished subscription request for {}. Closing stream.", (Object)this.remoteHostId);
    }
}

