/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.util.Objects;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;

public class ExprMissingValue
extends AbstractExprValue {
    private static final ExprMissingValue instance = new ExprMissingValue();

    private ExprMissingValue() {
    }

    public static ExprMissingValue of() {
        return instance;
    }

    @Override
    public Object value() {
        return null;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.UNDEFINED;
    }

    @Override
    public boolean isMissing() {
        return true;
    }

    @Override
    public int compare(ExprValue other) {
        throw new IllegalStateException(String.format("[BUG] Unreachable, Comparing with MISSING is undefined", new Object[0]));
    }

    @Override
    public boolean equal(ExprValue other) {
        return other.isMissing();
    }

    public int hashCode() {
        return Objects.hashCode("MISSING");
    }

    public String toString() {
        return "MISSING";
    }
}

