/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.transport;

import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.sql.spark.asyncquery.AsyncQueryExecutorServiceImpl;
import org.opensearch.sql.spark.transport.model.CancelAsyncQueryActionRequest;
import org.opensearch.sql.spark.transport.model.CancelAsyncQueryActionResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportCancelAsyncQueryRequestAction
extends HandledTransportAction<CancelAsyncQueryActionRequest, CancelAsyncQueryActionResponse> {
    public static final String NAME = "cluster:admin/opensearch/ql/async_query/delete";
    private final AsyncQueryExecutorServiceImpl asyncQueryExecutorService;
    public static final ActionType<CancelAsyncQueryActionResponse> ACTION_TYPE = new ActionType("cluster:admin/opensearch/ql/async_query/delete", CancelAsyncQueryActionResponse::new);

    @Inject
    public TransportCancelAsyncQueryRequestAction(TransportService transportService, ActionFilters actionFilters, AsyncQueryExecutorServiceImpl asyncQueryExecutorService) {
        super(NAME, transportService, actionFilters, CancelAsyncQueryActionRequest::new);
        this.asyncQueryExecutorService = asyncQueryExecutorService;
    }

    protected void doExecute(Task task, CancelAsyncQueryActionRequest request, ActionListener<CancelAsyncQueryActionResponse> listener) {
        try {
            String jobId = this.asyncQueryExecutorService.cancelQuery(request.getQueryId());
            listener.onResponse((Object)new CancelAsyncQueryActionResponse(String.format("Deleted async query with id: %s", jobId)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

