/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.ComplementDate;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.project.lang.Words;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class SubjectProject
implements Subject<GanttDiagram> {
    public static final Subject<GanttDiagram> ME = new SubjectProject();

    private SubjectProject() {
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("SUBJECT", "project");
    }

    @Override
    public Failable<GanttDiagram> getMe(GanttDiagram project, RegexResult arg) {
        return Failable.ok(project);
    }

    @Override
    public Collection<? extends SentenceSimple<GanttDiagram>> getSentences() {
        return Arrays.asList(new Starts());
    }

    class Starts
    extends SentenceSimple<GanttDiagram> {
        public Starts() {
            super(SubjectProject.this, Verbs.starts, Words.zeroOrMore("on", "for", "the", "at"), ComplementDate.onlyAbsolute());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Day start = (Day)complement;
            assert (project == subject);
            project.setProjectStartingDate(start);
            return CommandExecutionResult.ok();
        }
    }
}

