/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.util;

import java.io.IOException;
import java.io.Writer;
import zext.plantuml.com.ctreber.acearth.util.Point3D;
import zext.plantuml.com.ctreber.acearth.util.Toolkit;

public class Coordinate {
    private static final double MEAN_OBLIQUITY = 0.4091155090166427;
    private double fLat;
    private double fLong;

    public Coordinate() {
    }

    public Coordinate(double pLat, double pLong) {
        this.fLat = pLat;
        this.fLong = pLong;
    }

    public void renderAsXML(Writer writer) throws IOException {
        writer.write("<Coordinate>\n");
        writer.write("  <latitude>" + this.fLat + "</latitude>\n");
        writer.write("  <longitude>" + this.fLong + "</longitude>\n");
        writer.write("</Coordinate>\n");
    }

    public Point3D getPoint3D() {
        double lLatRad = Toolkit.degsToRads(this.fLat);
        double lLongRad = Toolkit.degsToRads(this.fLong);
        double lX = Math.cos(lLatRad) * Math.sin(lLongRad);
        double lY = Math.sin(lLatRad);
        double lZ = Math.cos(lLatRad) * Math.cos(lLongRad);
        return new Point3D(lX, lY, lZ);
    }

    public Point3D getPoint3DRads() {
        double lX = Math.cos(this.fLat) * Math.sin(this.fLong);
        double lY = Math.sin(this.fLat);
        double lZ = Math.cos(this.fLat) * Math.cos(this.fLong);
        return new Point3D(lX, lY, lZ);
    }

    public Coordinate eclipticToEquatorial() {
        double sin_e = Math.sin(0.4091155090166427);
        double cos_e = Math.cos(0.4091155090166427);
        double lRA = Math.atan2(Math.sin(this.fLong) * cos_e - Math.tan(this.fLat) * sin_e, Math.cos(this.fLong));
        double lDE = Math.asin(Math.sin(this.fLat) * cos_e + Math.cos(this.fLat) * sin_e * Math.sin(this.fLong));
        return new Coordinate(lDE, lRA);
    }

    public void add(Coordinate lOther) {
        this.fLat += lOther.fLat;
        this.fLong += lOther.fLong;
        this.wrap();
    }

    public void wrap() {
        if (this.fLat > 90.0) {
            this.fLat = 180.0 - this.fLat;
            this.fLong += 180.0;
        } else if (this.fLat < -90.0) {
            this.fLat = -180.0 - this.fLat;
            this.fLong += 180.0;
        }
        if (this.fLong > 180.0) {
            do {
                this.fLong -= 360.0;
            } while (this.fLong > 180.0);
        } else if (this.fLong < -180.0) {
            do {
                this.fLong += 360.0;
            } while (this.fLong < -180.0);
        }
    }

    public double getLat() {
        return this.fLat;
    }

    public double getDE() {
        return this.fLat;
    }

    public double getLong() {
        return this.fLong;
    }

    public double getRA() {
        return this.fLong;
    }

    public boolean check() {
        return -90.0 <= this.fLat && this.fLat <= 90.0 && -180.0 <= this.fLong && this.fLong <= 180.0;
    }

    public String toString() {
        return "lat: " + this.fLat + ", long: " + this.fLong;
    }
}

