/*
 * This declarations of the PIC18F248 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:41 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F248_H__
#define __PIC18F248_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        RXF0SIDH Bits

extern __at(0x0F00) __sfr RXF0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF0SIDHbits_t;

extern __at(0x0F00) volatile __RXF0SIDHbits_t RXF0SIDHbits;

#define _RXF0SIDH_SID3          0x01
#define _RXF0SIDH_SID4          0x02
#define _RXF0SIDH_SID5          0x04
#define _RXF0SIDH_SID6          0x08
#define _RXF0SIDH_SID7          0x10
#define _RXF0SIDH_SID8          0x20
#define _RXF0SIDH_SID9          0x40
#define _RXF0SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF0SIDL Bits

extern __at(0x0F01) __sfr RXF0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF0SIDLbits_t;

extern __at(0x0F01) volatile __RXF0SIDLbits_t RXF0SIDLbits;

#define _RXF0SIDL_EID16         0x01
#define _RXF0SIDL_EID17         0x02
#define _RXF0SIDL_EXIDEN        0x08
#define _RXF0SIDL_SID0          0x20
#define _RXF0SIDL_SID1          0x40
#define _RXF0SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF0EIDH Bits

extern __at(0x0F02) __sfr RXF0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF0EIDHbits_t;

extern __at(0x0F02) volatile __RXF0EIDHbits_t RXF0EIDHbits;

#define _RXF0EIDH_EID8          0x01
#define _RXF0EIDH_EID9          0x02
#define _RXF0EIDH_EID10         0x04
#define _RXF0EIDH_EID11         0x08
#define _RXF0EIDH_EID12         0x10
#define _RXF0EIDH_EID13         0x20
#define _RXF0EIDH_EID14         0x40
#define _RXF0EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF0EIDL Bits

extern __at(0x0F03) __sfr RXF0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF0EIDLbits_t;

extern __at(0x0F03) volatile __RXF0EIDLbits_t RXF0EIDLbits;

#define _RXF0EIDL_EID0          0x01
#define _RXF0EIDL_EID1          0x02
#define _RXF0EIDL_EID2          0x04
#define _RXF0EIDL_EID3          0x08
#define _RXF0EIDL_EID4          0x10
#define _RXF0EIDL_EID5          0x20
#define _RXF0EIDL_EID6          0x40
#define _RXF0EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF1SIDH Bits

extern __at(0x0F04) __sfr RXF1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF1SIDHbits_t;

extern __at(0x0F04) volatile __RXF1SIDHbits_t RXF1SIDHbits;

#define _RXF1SIDH_SID3          0x01
#define _RXF1SIDH_SID4          0x02
#define _RXF1SIDH_SID5          0x04
#define _RXF1SIDH_SID6          0x08
#define _RXF1SIDH_SID7          0x10
#define _RXF1SIDH_SID8          0x20
#define _RXF1SIDH_SID9          0x40
#define _RXF1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF1SIDL Bits

extern __at(0x0F05) __sfr RXF1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF1SIDLbits_t;

extern __at(0x0F05) volatile __RXF1SIDLbits_t RXF1SIDLbits;

#define _RXF1SIDL_EID16         0x01
#define _RXF1SIDL_EID17         0x02
#define _RXF1SIDL_EXIDEN        0x08
#define _RXF1SIDL_SID0          0x20
#define _RXF1SIDL_SID1          0x40
#define _RXF1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF1EIDH Bits

extern __at(0x0F06) __sfr RXF1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF1EIDHbits_t;

extern __at(0x0F06) volatile __RXF1EIDHbits_t RXF1EIDHbits;

#define _RXF1EIDH_EID8          0x01
#define _RXF1EIDH_EID9          0x02
#define _RXF1EIDH_EID10         0x04
#define _RXF1EIDH_EID11         0x08
#define _RXF1EIDH_EID12         0x10
#define _RXF1EIDH_EID13         0x20
#define _RXF1EIDH_EID14         0x40
#define _RXF1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF1EIDL Bits

extern __at(0x0F07) __sfr RXF1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF1EIDLbits_t;

extern __at(0x0F07) volatile __RXF1EIDLbits_t RXF1EIDLbits;

#define _RXF1EIDL_EID0          0x01
#define _RXF1EIDL_EID1          0x02
#define _RXF1EIDL_EID2          0x04
#define _RXF1EIDL_EID3          0x08
#define _RXF1EIDL_EID4          0x10
#define _RXF1EIDL_EID5          0x20
#define _RXF1EIDL_EID6          0x40
#define _RXF1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF2SIDH Bits

extern __at(0x0F08) __sfr RXF2SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF2SIDHbits_t;

extern __at(0x0F08) volatile __RXF2SIDHbits_t RXF2SIDHbits;

#define _RXF2SIDH_SID3          0x01
#define _RXF2SIDH_SID4          0x02
#define _RXF2SIDH_SID5          0x04
#define _RXF2SIDH_SID6          0x08
#define _RXF2SIDH_SID7          0x10
#define _RXF2SIDH_SID8          0x20
#define _RXF2SIDH_SID9          0x40
#define _RXF2SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF2SIDL Bits

extern __at(0x0F09) __sfr RXF2SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF2SIDLbits_t;

extern __at(0x0F09) volatile __RXF2SIDLbits_t RXF2SIDLbits;

#define _RXF2SIDL_EID16         0x01
#define _RXF2SIDL_EID17         0x02
#define _RXF2SIDL_EXIDEN        0x08
#define _RXF2SIDL_SID0          0x20
#define _RXF2SIDL_SID1          0x40
#define _RXF2SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF2EIDH Bits

extern __at(0x0F0A) __sfr RXF2EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF2EIDHbits_t;

extern __at(0x0F0A) volatile __RXF2EIDHbits_t RXF2EIDHbits;

#define _RXF2EIDH_EID8          0x01
#define _RXF2EIDH_EID9          0x02
#define _RXF2EIDH_EID10         0x04
#define _RXF2EIDH_EID11         0x08
#define _RXF2EIDH_EID12         0x10
#define _RXF2EIDH_EID13         0x20
#define _RXF2EIDH_EID14         0x40
#define _RXF2EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF2EIDL Bits

extern __at(0x0F0B) __sfr RXF2EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF2EIDLbits_t;

extern __at(0x0F0B) volatile __RXF2EIDLbits_t RXF2EIDLbits;

#define _RXF2EIDL_EID0          0x01
#define _RXF2EIDL_EID1          0x02
#define _RXF2EIDL_EID2          0x04
#define _RXF2EIDL_EID3          0x08
#define _RXF2EIDL_EID4          0x10
#define _RXF2EIDL_EID5          0x20
#define _RXF2EIDL_EID6          0x40
#define _RXF2EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF3SIDH Bits

extern __at(0x0F0C) __sfr RXF3SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF3SIDHbits_t;

extern __at(0x0F0C) volatile __RXF3SIDHbits_t RXF3SIDHbits;

#define _RXF3SIDH_SID3          0x01
#define _RXF3SIDH_SID4          0x02
#define _RXF3SIDH_SID5          0x04
#define _RXF3SIDH_SID6          0x08
#define _RXF3SIDH_SID7          0x10
#define _RXF3SIDH_SID8          0x20
#define _RXF3SIDH_SID9          0x40
#define _RXF3SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF3SIDL Bits

extern __at(0x0F0D) __sfr RXF3SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF3SIDLbits_t;

extern __at(0x0F0D) volatile __RXF3SIDLbits_t RXF3SIDLbits;

#define _RXF3SIDL_EID16         0x01
#define _RXF3SIDL_EID17         0x02
#define _RXF3SIDL_EXIDEN        0x08
#define _RXF3SIDL_SID0          0x20
#define _RXF3SIDL_SID1          0x40
#define _RXF3SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF3EIDH Bits

extern __at(0x0F0E) __sfr RXF3EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF3EIDHbits_t;

extern __at(0x0F0E) volatile __RXF3EIDHbits_t RXF3EIDHbits;

#define _RXF3EIDH_EID8          0x01
#define _RXF3EIDH_EID9          0x02
#define _RXF3EIDH_EID10         0x04
#define _RXF3EIDH_EID11         0x08
#define _RXF3EIDH_EID12         0x10
#define _RXF3EIDH_EID13         0x20
#define _RXF3EIDH_EID14         0x40
#define _RXF3EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF3EIDL Bits

extern __at(0x0F0F) __sfr RXF3EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF3EIDLbits_t;

extern __at(0x0F0F) volatile __RXF3EIDLbits_t RXF3EIDLbits;

#define _RXF3EIDL_EID0          0x01
#define _RXF3EIDL_EID1          0x02
#define _RXF3EIDL_EID2          0x04
#define _RXF3EIDL_EID3          0x08
#define _RXF3EIDL_EID4          0x10
#define _RXF3EIDL_EID5          0x20
#define _RXF3EIDL_EID6          0x40
#define _RXF3EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF4SIDH Bits

extern __at(0x0F10) __sfr RXF4SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF4SIDHbits_t;

extern __at(0x0F10) volatile __RXF4SIDHbits_t RXF4SIDHbits;

#define _RXF4SIDH_SID3          0x01
#define _RXF4SIDH_SID4          0x02
#define _RXF4SIDH_SID5          0x04
#define _RXF4SIDH_SID6          0x08
#define _RXF4SIDH_SID7          0x10
#define _RXF4SIDH_SID8          0x20
#define _RXF4SIDH_SID9          0x40
#define _RXF4SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF4SIDL Bits

extern __at(0x0F11) __sfr RXF4SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF4SIDLbits_t;

extern __at(0x0F11) volatile __RXF4SIDLbits_t RXF4SIDLbits;

#define _RXF4SIDL_EID16         0x01
#define _RXF4SIDL_EID17         0x02
#define _RXF4SIDL_EXIDEN        0x08
#define _RXF4SIDL_SID0          0x20
#define _RXF4SIDL_SID1          0x40
#define _RXF4SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF4EIDH Bits

extern __at(0x0F12) __sfr RXF4EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF4EIDHbits_t;

extern __at(0x0F12) volatile __RXF4EIDHbits_t RXF4EIDHbits;

#define _RXF4EIDH_EID8          0x01
#define _RXF4EIDH_EID9          0x02
#define _RXF4EIDH_EID10         0x04
#define _RXF4EIDH_EID11         0x08
#define _RXF4EIDH_EID12         0x10
#define _RXF4EIDH_EID13         0x20
#define _RXF4EIDH_EID14         0x40
#define _RXF4EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF4EIDL Bits

extern __at(0x0F13) __sfr RXF4EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF4EIDLbits_t;

extern __at(0x0F13) volatile __RXF4EIDLbits_t RXF4EIDLbits;

#define _RXF4EIDL_EID0          0x01
#define _RXF4EIDL_EID1          0x02
#define _RXF4EIDL_EID2          0x04
#define _RXF4EIDL_EID3          0x08
#define _RXF4EIDL_EID4          0x10
#define _RXF4EIDL_EID5          0x20
#define _RXF4EIDL_EID6          0x40
#define _RXF4EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF5SIDH Bits

extern __at(0x0F14) __sfr RXF5SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF5SIDHbits_t;

extern __at(0x0F14) volatile __RXF5SIDHbits_t RXF5SIDHbits;

#define _RXF5SIDH_SID3          0x01
#define _RXF5SIDH_SID4          0x02
#define _RXF5SIDH_SID5          0x04
#define _RXF5SIDH_SID6          0x08
#define _RXF5SIDH_SID7          0x10
#define _RXF5SIDH_SID8          0x20
#define _RXF5SIDH_SID9          0x40
#define _RXF5SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF5SIDL Bits

extern __at(0x0F15) __sfr RXF5SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF5SIDLbits_t;

extern __at(0x0F15) volatile __RXF5SIDLbits_t RXF5SIDLbits;

#define _RXF5SIDL_EID16         0x01
#define _RXF5SIDL_EID17         0x02
#define _RXF5SIDL_EXIDEN        0x08
#define _RXF5SIDL_SID0          0x20
#define _RXF5SIDL_SID1          0x40
#define _RXF5SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF5EIDH Bits

extern __at(0x0F16) __sfr RXF5EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF5EIDHbits_t;

extern __at(0x0F16) volatile __RXF5EIDHbits_t RXF5EIDHbits;

#define _RXF5EIDH_EID8          0x01
#define _RXF5EIDH_EID9          0x02
#define _RXF5EIDH_EID10         0x04
#define _RXF5EIDH_EID11         0x08
#define _RXF5EIDH_EID12         0x10
#define _RXF5EIDH_EID13         0x20
#define _RXF5EIDH_EID14         0x40
#define _RXF5EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF5EIDL Bits

extern __at(0x0F17) __sfr RXF5EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF5EIDLbits_t;

extern __at(0x0F17) volatile __RXF5EIDLbits_t RXF5EIDLbits;

#define _RXF5EIDL_EID0          0x01
#define _RXF5EIDL_EID1          0x02
#define _RXF5EIDL_EID2          0x04
#define _RXF5EIDL_EID3          0x08
#define _RXF5EIDL_EID4          0x10
#define _RXF5EIDL_EID5          0x20
#define _RXF5EIDL_EID6          0x40
#define _RXF5EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXM0SIDH Bits

extern __at(0x0F18) __sfr RXM0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXM0SIDHbits_t;

extern __at(0x0F18) volatile __RXM0SIDHbits_t RXM0SIDHbits;

#define _RXM0SIDH_SID3          0x01
#define _RXM0SIDH_SID4          0x02
#define _RXM0SIDH_SID5          0x04
#define _RXM0SIDH_SID6          0x08
#define _RXM0SIDH_SID7          0x10
#define _RXM0SIDH_SID8          0x20
#define _RXM0SIDH_SID9          0x40
#define _RXM0SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXM0SIDL Bits

extern __at(0x0F19) __sfr RXM0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXM0SIDLbits_t;

extern __at(0x0F19) volatile __RXM0SIDLbits_t RXM0SIDLbits;

#define _RXM0SIDL_EID16         0x01
#define _RXM0SIDL_EID17         0x02
#define _RXM0SIDL_SID0          0x20
#define _RXM0SIDL_SID1          0x40
#define _RXM0SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXM0EIDH Bits

extern __at(0x0F1A) __sfr RXM0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXM0EIDHbits_t;

extern __at(0x0F1A) volatile __RXM0EIDHbits_t RXM0EIDHbits;

#define _RXM0EIDH_EID8          0x01
#define _RXM0EIDH_EID9          0x02
#define _RXM0EIDH_EID10         0x04
#define _RXM0EIDH_EID11         0x08
#define _RXM0EIDH_EID12         0x10
#define _RXM0EIDH_EID13         0x20
#define _RXM0EIDH_EID14         0x40
#define _RXM0EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXM0EIDL Bits

extern __at(0x0F1B) __sfr RXM0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXM0EIDLbits_t;

extern __at(0x0F1B) volatile __RXM0EIDLbits_t RXM0EIDLbits;

#define _RXM0EIDL_EID0          0x01
#define _RXM0EIDL_EID1          0x02
#define _RXM0EIDL_EID2          0x04
#define _RXM0EIDL_EID3          0x08
#define _RXM0EIDL_EID4          0x10
#define _RXM0EIDL_EID5          0x20
#define _RXM0EIDL_EID6          0x40
#define _RXM0EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXM1SIDH Bits

extern __at(0x0F1C) __sfr RXM1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXM1SIDHbits_t;

extern __at(0x0F1C) volatile __RXM1SIDHbits_t RXM1SIDHbits;

#define _RXM1SIDH_SID3          0x01
#define _RXM1SIDH_SID4          0x02
#define _RXM1SIDH_SID5          0x04
#define _RXM1SIDH_SID6          0x08
#define _RXM1SIDH_SID7          0x10
#define _RXM1SIDH_SID8          0x20
#define _RXM1SIDH_SID9          0x40
#define _RXM1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXM1SIDL Bits

extern __at(0x0F1D) __sfr RXM1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXM1SIDLbits_t;

extern __at(0x0F1D) volatile __RXM1SIDLbits_t RXM1SIDLbits;

#define _RXM1SIDL_EID16         0x01
#define _RXM1SIDL_EID17         0x02
#define _RXM1SIDL_SID0          0x20
#define _RXM1SIDL_SID1          0x40
#define _RXM1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXM1EIDH Bits

extern __at(0x0F1E) __sfr RXM1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXM1EIDHbits_t;

extern __at(0x0F1E) volatile __RXM1EIDHbits_t RXM1EIDHbits;

#define _RXM1EIDH_EID8          0x01
#define _RXM1EIDH_EID9          0x02
#define _RXM1EIDH_EID10         0x04
#define _RXM1EIDH_EID11         0x08
#define _RXM1EIDH_EID12         0x10
#define _RXM1EIDH_EID13         0x20
#define _RXM1EIDH_EID14         0x40
#define _RXM1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXM1EIDL Bits

extern __at(0x0F1F) __sfr RXM1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXM1EIDLbits_t;

extern __at(0x0F1F) volatile __RXM1EIDLbits_t RXM1EIDLbits;

#define _RXM1EIDL_EID0          0x01
#define _RXM1EIDL_EID1          0x02
#define _RXM1EIDL_EID2          0x04
#define _RXM1EIDL_EID3          0x08
#define _RXM1EIDL_EID4          0x10
#define _RXM1EIDL_EID5          0x20
#define _RXM1EIDL_EID6          0x40
#define _RXM1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB2CON Bits

extern __at(0x0F20) __sfr TXB2CON;

typedef union
  {
  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned                    : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __TXB2CONbits_t;

extern __at(0x0F20) volatile __TXB2CONbits_t TXB2CONbits;

#define _TXB2CON_TXPRI0         0x01
#define _TXB2CON_TXPRI1         0x02
#define _TXB2CON_TXREQ          0x08
#define _TXB2CON_TXERR          0x10
#define _TXB2CON_TXLARB         0x20
#define _TXB2CON_TXABT          0x40

//==============================================================================


//==============================================================================
//        TXB2SIDH Bits

extern __at(0x0F21) __sfr TXB2SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __TXB2SIDHbits_t;

extern __at(0x0F21) volatile __TXB2SIDHbits_t TXB2SIDHbits;

#define _TXB2SIDH_SID3          0x01
#define _TXB2SIDH_SID4          0x02
#define _TXB2SIDH_SID5          0x04
#define _TXB2SIDH_SID6          0x08
#define _TXB2SIDH_SID7          0x10
#define _TXB2SIDH_SID8          0x20
#define _TXB2SIDH_SID9          0x40
#define _TXB2SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        TXB2SIDL Bits

extern __at(0x0F22) __sfr TXB2SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __TXB2SIDLbits_t;

extern __at(0x0F22) volatile __TXB2SIDLbits_t TXB2SIDLbits;

#define _TXB2SIDL_EID16         0x01
#define _TXB2SIDL_EID17         0x02
#define _TXB2SIDL_EXIDE         0x08
#define _TXB2SIDL_SID0          0x20
#define _TXB2SIDL_SID1          0x40
#define _TXB2SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        TXB2EIDH Bits

extern __at(0x0F23) __sfr TXB2EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __TXB2EIDHbits_t;

extern __at(0x0F23) volatile __TXB2EIDHbits_t TXB2EIDHbits;

#define _TXB2EIDH_EID8          0x01
#define _TXB2EIDH_EID9          0x02
#define _TXB2EIDH_EID10         0x04
#define _TXB2EIDH_EID11         0x08
#define _TXB2EIDH_EID12         0x10
#define _TXB2EIDH_EID13         0x20
#define _TXB2EIDH_EID14         0x40
#define _TXB2EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        TXB2EIDL Bits

extern __at(0x0F24) __sfr TXB2EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __TXB2EIDLbits_t;

extern __at(0x0F24) volatile __TXB2EIDLbits_t TXB2EIDLbits;

#define _TXB2EIDL_EID0          0x01
#define _TXB2EIDL_EID1          0x02
#define _TXB2EIDL_EID2          0x04
#define _TXB2EIDL_EID3          0x08
#define _TXB2EIDL_EID4          0x10
#define _TXB2EIDL_EID5          0x20
#define _TXB2EIDL_EID6          0x40
#define _TXB2EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB2DLC Bits

extern __at(0x0F25) __sfr TXB2DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };
  } __TXB2DLCbits_t;

extern __at(0x0F25) volatile __TXB2DLCbits_t TXB2DLCbits;

#define _TXB2DLC_DLC0           0x01
#define _TXB2DLC_DLC1           0x02
#define _TXB2DLC_DLC2           0x04
#define _TXB2DLC_DLC3           0x08
#define _TXB2DLC_TXRTR          0x40

//==============================================================================


//==============================================================================
//        TXB2D0 Bits

extern __at(0x0F26) __sfr TXB2D0;

typedef struct
  {
  unsigned TXB2D00              : 1;
  unsigned TXB2D01              : 1;
  unsigned TXB2D02              : 1;
  unsigned TXB2D03              : 1;
  unsigned TXB2D04              : 1;
  unsigned TXB2D05              : 1;
  unsigned TXB2D06              : 1;
  unsigned TXB2D07              : 1;
  } __TXB2D0bits_t;

extern __at(0x0F26) volatile __TXB2D0bits_t TXB2D0bits;

#define _TXB2D00                0x01
#define _TXB2D01                0x02
#define _TXB2D02                0x04
#define _TXB2D03                0x08
#define _TXB2D04                0x10
#define _TXB2D05                0x20
#define _TXB2D06                0x40
#define _TXB2D07                0x80

//==============================================================================


//==============================================================================
//        TXB2D1 Bits

extern __at(0x0F27) __sfr TXB2D1;

typedef struct
  {
  unsigned TXB2D10              : 1;
  unsigned TXB2D11              : 1;
  unsigned TXB2D12              : 1;
  unsigned TXB2D13              : 1;
  unsigned TXB2D14              : 1;
  unsigned TXB2D15              : 1;
  unsigned TXB2D16              : 1;
  unsigned TXB2D17              : 1;
  } __TXB2D1bits_t;

extern __at(0x0F27) volatile __TXB2D1bits_t TXB2D1bits;

#define _TXB2D10                0x01
#define _TXB2D11                0x02
#define _TXB2D12                0x04
#define _TXB2D13                0x08
#define _TXB2D14                0x10
#define _TXB2D15                0x20
#define _TXB2D16                0x40
#define _TXB2D17                0x80

//==============================================================================


//==============================================================================
//        TXB2D2 Bits

extern __at(0x0F28) __sfr TXB2D2;

typedef struct
  {
  unsigned TXB2D20              : 1;
  unsigned TXB2D21              : 1;
  unsigned TXB2D22              : 1;
  unsigned TXB2D23              : 1;
  unsigned TXB2D24              : 1;
  unsigned TXB2D25              : 1;
  unsigned TXB2D26              : 1;
  unsigned TXB2D27              : 1;
  } __TXB2D2bits_t;

extern __at(0x0F28) volatile __TXB2D2bits_t TXB2D2bits;

#define _TXB2D20                0x01
#define _TXB2D21                0x02
#define _TXB2D22                0x04
#define _TXB2D23                0x08
#define _TXB2D24                0x10
#define _TXB2D25                0x20
#define _TXB2D26                0x40
#define _TXB2D27                0x80

//==============================================================================


//==============================================================================
//        TXB2D3 Bits

extern __at(0x0F29) __sfr TXB2D3;

typedef struct
  {
  unsigned TXB2D30              : 1;
  unsigned TXB2D31              : 1;
  unsigned TXB2D32              : 1;
  unsigned TXB2D33              : 1;
  unsigned TXB2D34              : 1;
  unsigned TXB2D35              : 1;
  unsigned TXB2D36              : 1;
  unsigned TXB2D37              : 1;
  } __TXB2D3bits_t;

extern __at(0x0F29) volatile __TXB2D3bits_t TXB2D3bits;

#define _TXB2D30                0x01
#define _TXB2D31                0x02
#define _TXB2D32                0x04
#define _TXB2D33                0x08
#define _TXB2D34                0x10
#define _TXB2D35                0x20
#define _TXB2D36                0x40
#define _TXB2D37                0x80

//==============================================================================


//==============================================================================
//        TXB2D4 Bits

extern __at(0x0F2A) __sfr TXB2D4;

typedef struct
  {
  unsigned TXB2D40              : 1;
  unsigned TXB2D41              : 1;
  unsigned TXB2D42              : 1;
  unsigned TXB2D43              : 1;
  unsigned TXB2D44              : 1;
  unsigned TXB2D45              : 1;
  unsigned TXB2D46              : 1;
  unsigned TXB2D47              : 1;
  } __TXB2D4bits_t;

extern __at(0x0F2A) volatile __TXB2D4bits_t TXB2D4bits;

#define _TXB2D40                0x01
#define _TXB2D41                0x02
#define _TXB2D42                0x04
#define _TXB2D43                0x08
#define _TXB2D44                0x10
#define _TXB2D45                0x20
#define _TXB2D46                0x40
#define _TXB2D47                0x80

//==============================================================================


//==============================================================================
//        TXB2D5 Bits

extern __at(0x0F2B) __sfr TXB2D5;

typedef struct
  {
  unsigned TXB2D50              : 1;
  unsigned TXB2D51              : 1;
  unsigned TXB2D52              : 1;
  unsigned TXB2D53              : 1;
  unsigned TXB2D54              : 1;
  unsigned TXB2D55              : 1;
  unsigned TXB2D56              : 1;
  unsigned TXB2D57              : 1;
  } __TXB2D5bits_t;

extern __at(0x0F2B) volatile __TXB2D5bits_t TXB2D5bits;

#define _TXB2D50                0x01
#define _TXB2D51                0x02
#define _TXB2D52                0x04
#define _TXB2D53                0x08
#define _TXB2D54                0x10
#define _TXB2D55                0x20
#define _TXB2D56                0x40
#define _TXB2D57                0x80

//==============================================================================


//==============================================================================
//        TXB2D6 Bits

extern __at(0x0F2C) __sfr TXB2D6;

typedef struct
  {
  unsigned TXB2D60              : 1;
  unsigned TXB2D61              : 1;
  unsigned TXB2D62              : 1;
  unsigned TXB2D63              : 1;
  unsigned TXB2D64              : 1;
  unsigned TXB2D65              : 1;
  unsigned TXB2D66              : 1;
  unsigned TXB2D67              : 1;
  } __TXB2D6bits_t;

extern __at(0x0F2C) volatile __TXB2D6bits_t TXB2D6bits;

#define _TXB2D60                0x01
#define _TXB2D61                0x02
#define _TXB2D62                0x04
#define _TXB2D63                0x08
#define _TXB2D64                0x10
#define _TXB2D65                0x20
#define _TXB2D66                0x40
#define _TXB2D67                0x80

//==============================================================================


//==============================================================================
//        TXB2D7 Bits

extern __at(0x0F2D) __sfr TXB2D7;

typedef struct
  {
  unsigned TXB2D70              : 1;
  unsigned TXB2D71              : 1;
  unsigned TXB2D72              : 1;
  unsigned TXB2D73              : 1;
  unsigned TXB2D74              : 1;
  unsigned TXB2D75              : 1;
  unsigned TXB2D76              : 1;
  unsigned TXB2D77              : 1;
  } __TXB2D7bits_t;

extern __at(0x0F2D) volatile __TXB2D7bits_t TXB2D7bits;

#define _TXB2D70                0x01
#define _TXB2D71                0x02
#define _TXB2D72                0x04
#define _TXB2D73                0x08
#define _TXB2D74                0x10
#define _TXB2D75                0x20
#define _TXB2D76                0x40
#define _TXB2D77                0x80

//==============================================================================


//==============================================================================
//        CANSTATRO4 Bits

extern __at(0x0F2E) __sfr CANSTATRO4;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTATRO4bits_t;

extern __at(0x0F2E) volatile __CANSTATRO4bits_t CANSTATRO4bits;

#define _CANSTATRO4_ICODE0      0x02
#define _CANSTATRO4_ICODE1      0x04
#define _CANSTATRO4_ICODE2      0x08
#define _CANSTATRO4_OPMODE0     0x20
#define _CANSTATRO4_OPMODE1     0x40
#define _CANSTATRO4_OPMODE2     0x80

//==============================================================================


//==============================================================================
//        TXB1CON Bits

extern __at(0x0F30) __sfr TXB1CON;

typedef union
  {
  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned                    : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __TXB1CONbits_t;

extern __at(0x0F30) volatile __TXB1CONbits_t TXB1CONbits;

#define _TXB1CON_TXPRI0         0x01
#define _TXB1CON_TXPRI1         0x02
#define _TXB1CON_TXREQ          0x08
#define _TXB1CON_TXERR          0x10
#define _TXB1CON_TXLARB         0x20
#define _TXB1CON_TXABT          0x40

//==============================================================================


//==============================================================================
//        TXB1SIDH Bits

extern __at(0x0F31) __sfr TXB1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __TXB1SIDHbits_t;

extern __at(0x0F31) volatile __TXB1SIDHbits_t TXB1SIDHbits;

#define _TXB1SIDH_SID3          0x01
#define _TXB1SIDH_SID4          0x02
#define _TXB1SIDH_SID5          0x04
#define _TXB1SIDH_SID6          0x08
#define _TXB1SIDH_SID7          0x10
#define _TXB1SIDH_SID8          0x20
#define _TXB1SIDH_SID9          0x40
#define _TXB1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        TXB1SIDL Bits

extern __at(0x0F32) __sfr TXB1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __TXB1SIDLbits_t;

extern __at(0x0F32) volatile __TXB1SIDLbits_t TXB1SIDLbits;

#define _TXB1SIDL_EID16         0x01
#define _TXB1SIDL_EID17         0x02
#define _TXB1SIDL_EXIDE         0x08
#define _TXB1SIDL_SID0          0x20
#define _TXB1SIDL_SID1          0x40
#define _TXB1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        TXB1EIDH Bits

extern __at(0x0F33) __sfr TXB1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __TXB1EIDHbits_t;

extern __at(0x0F33) volatile __TXB1EIDHbits_t TXB1EIDHbits;

#define _TXB1EIDH_EID8          0x01
#define _TXB1EIDH_EID9          0x02
#define _TXB1EIDH_EID10         0x04
#define _TXB1EIDH_EID11         0x08
#define _TXB1EIDH_EID12         0x10
#define _TXB1EIDH_EID13         0x20
#define _TXB1EIDH_EID14         0x40
#define _TXB1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        TXB1EIDL Bits

extern __at(0x0F34) __sfr TXB1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __TXB1EIDLbits_t;

extern __at(0x0F34) volatile __TXB1EIDLbits_t TXB1EIDLbits;

#define _TXB1EIDL_EID0          0x01
#define _TXB1EIDL_EID1          0x02
#define _TXB1EIDL_EID2          0x04
#define _TXB1EIDL_EID3          0x08
#define _TXB1EIDL_EID4          0x10
#define _TXB1EIDL_EID5          0x20
#define _TXB1EIDL_EID6          0x40
#define _TXB1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB1DLC Bits

extern __at(0x0F35) __sfr TXB1DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };
  } __TXB1DLCbits_t;

extern __at(0x0F35) volatile __TXB1DLCbits_t TXB1DLCbits;

#define _TXB1DLC_DLC0           0x01
#define _TXB1DLC_DLC1           0x02
#define _TXB1DLC_DLC2           0x04
#define _TXB1DLC_DLC3           0x08
#define _TXB1DLC_TXRTR          0x40

//==============================================================================


//==============================================================================
//        TXB1D0 Bits

extern __at(0x0F36) __sfr TXB1D0;

typedef struct
  {
  unsigned TXB1D00              : 1;
  unsigned TXB1D01              : 1;
  unsigned TXB1D02              : 1;
  unsigned TXB1D03              : 1;
  unsigned TXB1D04              : 1;
  unsigned TXB1D05              : 1;
  unsigned TXB1D06              : 1;
  unsigned TXB1D07              : 1;
  } __TXB1D0bits_t;

extern __at(0x0F36) volatile __TXB1D0bits_t TXB1D0bits;

#define _TXB1D00                0x01
#define _TXB1D01                0x02
#define _TXB1D02                0x04
#define _TXB1D03                0x08
#define _TXB1D04                0x10
#define _TXB1D05                0x20
#define _TXB1D06                0x40
#define _TXB1D07                0x80

//==============================================================================


//==============================================================================
//        TXB1D1 Bits

extern __at(0x0F37) __sfr TXB1D1;

typedef struct
  {
  unsigned TXB1D10              : 1;
  unsigned TXB1D11              : 1;
  unsigned TXB1D12              : 1;
  unsigned TXB1D13              : 1;
  unsigned TXB1D14              : 1;
  unsigned TXB1D15              : 1;
  unsigned TXB1D16              : 1;
  unsigned TXB1D17              : 1;
  } __TXB1D1bits_t;

extern __at(0x0F37) volatile __TXB1D1bits_t TXB1D1bits;

#define _TXB1D10                0x01
#define _TXB1D11                0x02
#define _TXB1D12                0x04
#define _TXB1D13                0x08
#define _TXB1D14                0x10
#define _TXB1D15                0x20
#define _TXB1D16                0x40
#define _TXB1D17                0x80

//==============================================================================


//==============================================================================
//        TXB1D2 Bits

extern __at(0x0F38) __sfr TXB1D2;

typedef union
  {
  struct
    {
    unsigned TXB1D20            : 1;
    unsigned TXB1D21            : 1;
    unsigned TXB1D22            : 1;
    unsigned TXB1D23            : 1;
    unsigned TXB1D24            : 1;
    unsigned TXB1D25            : 1;
    unsigned TXB1D26            : 1;
    unsigned TXB1D27            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TBB1D23            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __TXB1D2bits_t;

extern __at(0x0F38) volatile __TXB1D2bits_t TXB1D2bits;

#define _TXB1D20                0x01
#define _TXB1D21                0x02
#define _TXB1D22                0x04
#define _TXB1D23                0x08
#define _TBB1D23                0x08
#define _TXB1D24                0x10
#define _TXB1D25                0x20
#define _TXB1D26                0x40
#define _TXB1D27                0x80

//==============================================================================


//==============================================================================
//        TXB1D3 Bits

extern __at(0x0F39) __sfr TXB1D3;

typedef struct
  {
  unsigned TXB1D30              : 1;
  unsigned TXB1D31              : 1;
  unsigned TXB1D32              : 1;
  unsigned TXB1D33              : 1;
  unsigned TXB1D34              : 1;
  unsigned TXB1D35              : 1;
  unsigned TXB1D36              : 1;
  unsigned TXB1D37              : 1;
  } __TXB1D3bits_t;

extern __at(0x0F39) volatile __TXB1D3bits_t TXB1D3bits;

#define _TXB1D30                0x01
#define _TXB1D31                0x02
#define _TXB1D32                0x04
#define _TXB1D33                0x08
#define _TXB1D34                0x10
#define _TXB1D35                0x20
#define _TXB1D36                0x40
#define _TXB1D37                0x80

//==============================================================================


//==============================================================================
//        TXB1D4 Bits

extern __at(0x0F3A) __sfr TXB1D4;

typedef struct
  {
  unsigned TXB1D40              : 1;
  unsigned TXB1D41              : 1;
  unsigned TXB1D42              : 1;
  unsigned TXB1D43              : 1;
  unsigned TXB1D44              : 1;
  unsigned TXB1D45              : 1;
  unsigned TXB1D46              : 1;
  unsigned TXB1D47              : 1;
  } __TXB1D4bits_t;

extern __at(0x0F3A) volatile __TXB1D4bits_t TXB1D4bits;

#define _TXB1D40                0x01
#define _TXB1D41                0x02
#define _TXB1D42                0x04
#define _TXB1D43                0x08
#define _TXB1D44                0x10
#define _TXB1D45                0x20
#define _TXB1D46                0x40
#define _TXB1D47                0x80

//==============================================================================


//==============================================================================
//        TXB1D5 Bits

extern __at(0x0F3B) __sfr TXB1D5;

typedef struct
  {
  unsigned TXB1D50              : 1;
  unsigned TXB1D51              : 1;
  unsigned TXB1D52              : 1;
  unsigned TXB1D53              : 1;
  unsigned TXB1D54              : 1;
  unsigned TXB1D55              : 1;
  unsigned TXB1D56              : 1;
  unsigned TXB1D57              : 1;
  } __TXB1D5bits_t;

extern __at(0x0F3B) volatile __TXB1D5bits_t TXB1D5bits;

#define _TXB1D50                0x01
#define _TXB1D51                0x02
#define _TXB1D52                0x04
#define _TXB1D53                0x08
#define _TXB1D54                0x10
#define _TXB1D55                0x20
#define _TXB1D56                0x40
#define _TXB1D57                0x80

//==============================================================================


//==============================================================================
//        TXB1D6 Bits

extern __at(0x0F3C) __sfr TXB1D6;

typedef struct
  {
  unsigned TXB1D60              : 1;
  unsigned TXB1D61              : 1;
  unsigned TXB1D62              : 1;
  unsigned TXB1D63              : 1;
  unsigned TXB1D64              : 1;
  unsigned TXB1D65              : 1;
  unsigned TXB1D66              : 1;
  unsigned TXB1D67              : 1;
  } __TXB1D6bits_t;

extern __at(0x0F3C) volatile __TXB1D6bits_t TXB1D6bits;

#define _TXB1D60                0x01
#define _TXB1D61                0x02
#define _TXB1D62                0x04
#define _TXB1D63                0x08
#define _TXB1D64                0x10
#define _TXB1D65                0x20
#define _TXB1D66                0x40
#define _TXB1D67                0x80

//==============================================================================


//==============================================================================
//        TXB1D7 Bits

extern __at(0x0F3D) __sfr TXB1D7;

typedef struct
  {
  unsigned TXB1D70              : 1;
  unsigned TXB1D71              : 1;
  unsigned TXB1D72              : 1;
  unsigned TXB1D73              : 1;
  unsigned TXB1D74              : 1;
  unsigned TXB1D75              : 1;
  unsigned TXB1D76              : 1;
  unsigned TXB1D77              : 1;
  } __TXB1D7bits_t;

extern __at(0x0F3D) volatile __TXB1D7bits_t TXB1D7bits;

#define _TXB1D70                0x01
#define _TXB1D71                0x02
#define _TXB1D72                0x04
#define _TXB1D73                0x08
#define _TXB1D74                0x10
#define _TXB1D75                0x20
#define _TXB1D76                0x40
#define _TXB1D77                0x80

//==============================================================================


//==============================================================================
//        CANSTATRO3 Bits

extern __at(0x0F3E) __sfr CANSTATRO3;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTATRO3bits_t;

extern __at(0x0F3E) volatile __CANSTATRO3bits_t CANSTATRO3bits;

#define _CANSTATRO3_ICODE0      0x02
#define _CANSTATRO3_ICODE1      0x04
#define _CANSTATRO3_ICODE2      0x08
#define _CANSTATRO3_OPMODE0     0x20
#define _CANSTATRO3_OPMODE1     0x40
#define _CANSTATRO3_OPMODE2     0x80

//==============================================================================


//==============================================================================
//        TXB0CON Bits

extern __at(0x0F40) __sfr TXB0CON;

typedef union
  {
  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned                    : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __TXB0CONbits_t;

extern __at(0x0F40) volatile __TXB0CONbits_t TXB0CONbits;

#define _TXPRI0                 0x01
#define _TXPRI1                 0x02
#define _TXREQ                  0x08
#define _TXERR                  0x10
#define _TXLARB                 0x20
#define _TXABT                  0x40

//==============================================================================


//==============================================================================
//        TXB0SIDH Bits

extern __at(0x0F41) __sfr TXB0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __TXB0SIDHbits_t;

extern __at(0x0F41) volatile __TXB0SIDHbits_t TXB0SIDHbits;

#define _TXB0SIDH_SID3          0x01
#define _TXB0SIDH_SID4          0x02
#define _TXB0SIDH_SID5          0x04
#define _TXB0SIDH_SID6          0x08
#define _TXB0SIDH_SID7          0x10
#define _TXB0SIDH_SID8          0x20
#define _TXB0SIDH_SID9          0x40
#define _TXB0SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        TXB0SIDL Bits

extern __at(0x0F42) __sfr TXB0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __TXB0SIDLbits_t;

extern __at(0x0F42) volatile __TXB0SIDLbits_t TXB0SIDLbits;

#define _TXB0SIDL_EID16         0x01
#define _TXB0SIDL_EID17         0x02
#define _TXB0SIDL_EXIDE         0x08
#define _TXB0SIDL_SID0          0x20
#define _TXB0SIDL_SID1          0x40
#define _TXB0SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        TXB0EIDH Bits

extern __at(0x0F43) __sfr TXB0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __TXB0EIDHbits_t;

extern __at(0x0F43) volatile __TXB0EIDHbits_t TXB0EIDHbits;

#define _TXB0EIDH_EID8          0x01
#define _TXB0EIDH_EID9          0x02
#define _TXB0EIDH_EID10         0x04
#define _TXB0EIDH_EID11         0x08
#define _TXB0EIDH_EID12         0x10
#define _TXB0EIDH_EID13         0x20
#define _TXB0EIDH_EID14         0x40
#define _TXB0EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        TXB0EIDL Bits

extern __at(0x0F44) __sfr TXB0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __TXB0EIDLbits_t;

extern __at(0x0F44) volatile __TXB0EIDLbits_t TXB0EIDLbits;

#define _TXB0EIDL_EID0          0x01
#define _TXB0EIDL_EID1          0x02
#define _TXB0EIDL_EID2          0x04
#define _TXB0EIDL_EID3          0x08
#define _TXB0EIDL_EID4          0x10
#define _TXB0EIDL_EID5          0x20
#define _TXB0EIDL_EID6          0x40
#define _TXB0EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB0DLC Bits

extern __at(0x0F45) __sfr TXB0DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };
  } __TXB0DLCbits_t;

extern __at(0x0F45) volatile __TXB0DLCbits_t TXB0DLCbits;

#define _TXB0DLC_DLC0           0x01
#define _TXB0DLC_DLC1           0x02
#define _TXB0DLC_DLC2           0x04
#define _TXB0DLC_DLC3           0x08
#define _TXB0DLC_TXRTR          0x40

//==============================================================================


//==============================================================================
//        TXB0D0 Bits

extern __at(0x0F46) __sfr TXB0D0;

typedef struct
  {
  unsigned TXB0D00              : 1;
  unsigned TXB0D01              : 1;
  unsigned TXB0D02              : 1;
  unsigned TXB0D03              : 1;
  unsigned TXB0D04              : 1;
  unsigned TXB0D05              : 1;
  unsigned TXB0D06              : 1;
  unsigned TXB0D07              : 1;
  } __TXB0D0bits_t;

extern __at(0x0F46) volatile __TXB0D0bits_t TXB0D0bits;

#define _TXB0D00                0x01
#define _TXB0D01                0x02
#define _TXB0D02                0x04
#define _TXB0D03                0x08
#define _TXB0D04                0x10
#define _TXB0D05                0x20
#define _TXB0D06                0x40
#define _TXB0D07                0x80

//==============================================================================


//==============================================================================
//        TXB0D1 Bits

extern __at(0x0F47) __sfr TXB0D1;

typedef struct
  {
  unsigned TXB0D10              : 1;
  unsigned TXB0D11              : 1;
  unsigned TXB0D12              : 1;
  unsigned TXB0D13              : 1;
  unsigned TXB0D14              : 1;
  unsigned TXB0D15              : 1;
  unsigned TXB0D16              : 1;
  unsigned TXB0D17              : 1;
  } __TXB0D1bits_t;

extern __at(0x0F47) volatile __TXB0D1bits_t TXB0D1bits;

#define _TXB0D10                0x01
#define _TXB0D11                0x02
#define _TXB0D12                0x04
#define _TXB0D13                0x08
#define _TXB0D14                0x10
#define _TXB0D15                0x20
#define _TXB0D16                0x40
#define _TXB0D17                0x80

//==============================================================================


//==============================================================================
//        TXB0D2 Bits

extern __at(0x0F48) __sfr TXB0D2;

typedef struct
  {
  unsigned TXB0D20              : 1;
  unsigned TXB0D21              : 1;
  unsigned TXB0D22              : 1;
  unsigned TXB0D23              : 1;
  unsigned TXB0D24              : 1;
  unsigned TXB0D25              : 1;
  unsigned TXB0D26              : 1;
  unsigned TXB0D27              : 1;
  } __TXB0D2bits_t;

extern __at(0x0F48) volatile __TXB0D2bits_t TXB0D2bits;

#define _TXB0D20                0x01
#define _TXB0D21                0x02
#define _TXB0D22                0x04
#define _TXB0D23                0x08
#define _TXB0D24                0x10
#define _TXB0D25                0x20
#define _TXB0D26                0x40
#define _TXB0D27                0x80

//==============================================================================


//==============================================================================
//        TXB0D3 Bits

extern __at(0x0F49) __sfr TXB0D3;

typedef struct
  {
  unsigned TXB0D30              : 1;
  unsigned TXB0D31              : 1;
  unsigned TXB0D32              : 1;
  unsigned TXB0D33              : 1;
  unsigned TXB0D34              : 1;
  unsigned TXB0D35              : 1;
  unsigned TXB0D36              : 1;
  unsigned TXB0D37              : 1;
  } __TXB0D3bits_t;

extern __at(0x0F49) volatile __TXB0D3bits_t TXB0D3bits;

#define _TXB0D30                0x01
#define _TXB0D31                0x02
#define _TXB0D32                0x04
#define _TXB0D33                0x08
#define _TXB0D34                0x10
#define _TXB0D35                0x20
#define _TXB0D36                0x40
#define _TXB0D37                0x80

//==============================================================================


//==============================================================================
//        TXB0D4 Bits

extern __at(0x0F4A) __sfr TXB0D4;

typedef struct
  {
  unsigned TXB0D40              : 1;
  unsigned TXB0D41              : 1;
  unsigned TXB0D42              : 1;
  unsigned TXB0D43              : 1;
  unsigned TXB0D44              : 1;
  unsigned TXB0D45              : 1;
  unsigned TXB0D46              : 1;
  unsigned TXB0D47              : 1;
  } __TXB0D4bits_t;

extern __at(0x0F4A) volatile __TXB0D4bits_t TXB0D4bits;

#define _TXB0D40                0x01
#define _TXB0D41                0x02
#define _TXB0D42                0x04
#define _TXB0D43                0x08
#define _TXB0D44                0x10
#define _TXB0D45                0x20
#define _TXB0D46                0x40
#define _TXB0D47                0x80

//==============================================================================


//==============================================================================
//        TXB0D5 Bits

extern __at(0x0F4B) __sfr TXB0D5;

typedef struct
  {
  unsigned TXB0D50              : 1;
  unsigned TXB0D51              : 1;
  unsigned TXB0D52              : 1;
  unsigned TXB0D53              : 1;
  unsigned TXB0D54              : 1;
  unsigned TXB0D55              : 1;
  unsigned TXB0D56              : 1;
  unsigned TXB0D57              : 1;
  } __TXB0D5bits_t;

extern __at(0x0F4B) volatile __TXB0D5bits_t TXB0D5bits;

#define _TXB0D50                0x01
#define _TXB0D51                0x02
#define _TXB0D52                0x04
#define _TXB0D53                0x08
#define _TXB0D54                0x10
#define _TXB0D55                0x20
#define _TXB0D56                0x40
#define _TXB0D57                0x80

//==============================================================================


//==============================================================================
//        TXB0D6 Bits

extern __at(0x0F4C) __sfr TXB0D6;

typedef struct
  {
  unsigned TXB0D60              : 1;
  unsigned TXB0D61              : 1;
  unsigned TXB0D62              : 1;
  unsigned TXB0D63              : 1;
  unsigned TXB0D64              : 1;
  unsigned TXB0D65              : 1;
  unsigned TXB0D66              : 1;
  unsigned TXB0D67              : 1;
  } __TXB0D6bits_t;

extern __at(0x0F4C) volatile __TXB0D6bits_t TXB0D6bits;

#define _TXB0D60                0x01
#define _TXB0D61                0x02
#define _TXB0D62                0x04
#define _TXB0D63                0x08
#define _TXB0D64                0x10
#define _TXB0D65                0x20
#define _TXB0D66                0x40
#define _TXB0D67                0x80

//==============================================================================


//==============================================================================
//        TXB0D7 Bits

extern __at(0x0F4D) __sfr TXB0D7;

typedef struct
  {
  unsigned TXB0D70              : 1;
  unsigned TXB0D71              : 1;
  unsigned TXB0D72              : 1;
  unsigned TXB0D73              : 1;
  unsigned TXB0D74              : 1;
  unsigned TXB0D75              : 1;
  unsigned TXB0D76              : 1;
  unsigned TXB0D77              : 1;
  } __TXB0D7bits_t;

extern __at(0x0F4D) volatile __TXB0D7bits_t TXB0D7bits;

#define _TXB0D70                0x01
#define _TXB0D71                0x02
#define _TXB0D72                0x04
#define _TXB0D73                0x08
#define _TXB0D74                0x10
#define _TXB0D75                0x20
#define _TXB0D76                0x40
#define _TXB0D77                0x80

//==============================================================================


//==============================================================================
//        CANSTATRO2 Bits

extern __at(0x0F4E) __sfr CANSTATRO2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTATRO2bits_t;

extern __at(0x0F4E) volatile __CANSTATRO2bits_t CANSTATRO2bits;

#define _CANSTATRO2_ICODE0      0x02
#define _CANSTATRO2_ICODE1      0x04
#define _CANSTATRO2_ICODE2      0x08
#define _CANSTATRO2_OPMODE0     0x20
#define _CANSTATRO2_OPMODE1     0x40
#define _CANSTATRO2_OPMODE2     0x80

//==============================================================================


//==============================================================================
//        RXB1CON Bits

extern __at(0x0F50) __sfr RXB1CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned RXRTRRO            : 1;
    unsigned                    : 1;
    unsigned RXM0               : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned FILHIT             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RXM                : 2;
    unsigned                    : 1;
    };
  } __RXB1CONbits_t;

extern __at(0x0F50) volatile __RXB1CONbits_t RXB1CONbits;

#define _RXB1CON_FILHIT0        0x01
#define _RXB1CON_FILHIT1        0x02
#define _RXB1CON_FILHIT2        0x04
#define _RXB1CON_RXRTRRO        0x08
#define _RXB1CON_RXM0           0x20
#define _RXB1CON_RXM1           0x40
#define _RXB1CON_RXFUL          0x80

//==============================================================================


//==============================================================================
//        RXB1SIDH Bits

extern __at(0x0F51) __sfr RXB1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXB1SIDHbits_t;

extern __at(0x0F51) volatile __RXB1SIDHbits_t RXB1SIDHbits;

#define _RXB1SIDH_SID3          0x01
#define _RXB1SIDH_SID4          0x02
#define _RXB1SIDH_SID5          0x04
#define _RXB1SIDH_SID6          0x08
#define _RXB1SIDH_SID7          0x10
#define _RXB1SIDH_SID8          0x20
#define _RXB1SIDH_SID9          0x40
#define _RXB1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXB1SIDL Bits

extern __at(0x0F52) __sfr RXB1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXID               : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXB1SIDLbits_t;

extern __at(0x0F52) volatile __RXB1SIDLbits_t RXB1SIDLbits;

#define _RXB1SIDL_EID16         0x01
#define _RXB1SIDL_EID17         0x02
#define _RXB1SIDL_EXID          0x08
#define _RXB1SIDL_SRR           0x10
#define _RXB1SIDL_SID0          0x20
#define _RXB1SIDL_SID1          0x40
#define _RXB1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXB1EIDH Bits

extern __at(0x0F53) __sfr RXB1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXB1EIDHbits_t;

extern __at(0x0F53) volatile __RXB1EIDHbits_t RXB1EIDHbits;

#define _RXB1EIDH_EID8          0x01
#define _RXB1EIDH_EID9          0x02
#define _RXB1EIDH_EID10         0x04
#define _RXB1EIDH_EID11         0x08
#define _RXB1EIDH_EID12         0x10
#define _RXB1EIDH_EID13         0x20
#define _RXB1EIDH_EID14         0x40
#define _RXB1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXB1EIDL Bits

extern __at(0x0F54) __sfr RXB1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXB1EIDLbits_t;

extern __at(0x0F54) volatile __RXB1EIDLbits_t RXB1EIDLbits;

#define _RXB1EIDL_EID0          0x01
#define _RXB1EIDL_EID1          0x02
#define _RXB1EIDL_EID2          0x04
#define _RXB1EIDL_EID3          0x08
#define _RXB1EIDL_EID4          0x10
#define _RXB1EIDL_EID5          0x20
#define _RXB1EIDL_EID6          0x40
#define _RXB1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXB1DLC Bits

extern __at(0x0F55) __sfr RXB1DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RESB0              : 1;
    unsigned RESB1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RESB               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __RXB1DLCbits_t;

extern __at(0x0F55) volatile __RXB1DLCbits_t RXB1DLCbits;

#define _RXB1DLC_DLC0           0x01
#define _RXB1DLC_DLC1           0x02
#define _RXB1DLC_DLC2           0x04
#define _RXB1DLC_DLC3           0x08
#define _RXB1DLC_RB0            0x10
#define _RXB1DLC_RESB0          0x10
#define _RXB1DLC_RB1            0x20
#define _RXB1DLC_RESB1          0x20
#define _RXB1DLC_RXRTR          0x40

//==============================================================================


//==============================================================================
//        RXB1D0 Bits

extern __at(0x0F56) __sfr RXB1D0;

typedef struct
  {
  unsigned RXB1D00              : 1;
  unsigned RXB1D01              : 1;
  unsigned RXB1D02              : 1;
  unsigned RXB1D03              : 1;
  unsigned RXB1D04              : 1;
  unsigned RXB1D05              : 1;
  unsigned RXB1D06              : 1;
  unsigned RXB1D07              : 1;
  } __RXB1D0bits_t;

extern __at(0x0F56) volatile __RXB1D0bits_t RXB1D0bits;

#define _RXB1D00                0x01
#define _RXB1D01                0x02
#define _RXB1D02                0x04
#define _RXB1D03                0x08
#define _RXB1D04                0x10
#define _RXB1D05                0x20
#define _RXB1D06                0x40
#define _RXB1D07                0x80

//==============================================================================


//==============================================================================
//        RXB1D1 Bits

extern __at(0x0F57) __sfr RXB1D1;

typedef struct
  {
  unsigned RXB1D10              : 1;
  unsigned RXB1D11              : 1;
  unsigned RXB1D12              : 1;
  unsigned RXB1D13              : 1;
  unsigned RXB1D14              : 1;
  unsigned RXB1D15              : 1;
  unsigned RXB1D16              : 1;
  unsigned RXB1D17              : 1;
  } __RXB1D1bits_t;

extern __at(0x0F57) volatile __RXB1D1bits_t RXB1D1bits;

#define _RXB1D10                0x01
#define _RXB1D11                0x02
#define _RXB1D12                0x04
#define _RXB1D13                0x08
#define _RXB1D14                0x10
#define _RXB1D15                0x20
#define _RXB1D16                0x40
#define _RXB1D17                0x80

//==============================================================================


//==============================================================================
//        RXB1D2 Bits

extern __at(0x0F58) __sfr RXB1D2;

typedef struct
  {
  unsigned RXB1D20              : 1;
  unsigned RXB1D21              : 1;
  unsigned RXB1D22              : 1;
  unsigned RXB1D23              : 1;
  unsigned RXB1D24              : 1;
  unsigned RXB1D25              : 1;
  unsigned RXB1D26              : 1;
  unsigned RXB1D27              : 1;
  } __RXB1D2bits_t;

extern __at(0x0F58) volatile __RXB1D2bits_t RXB1D2bits;

#define _RXB1D20                0x01
#define _RXB1D21                0x02
#define _RXB1D22                0x04
#define _RXB1D23                0x08
#define _RXB1D24                0x10
#define _RXB1D25                0x20
#define _RXB1D26                0x40
#define _RXB1D27                0x80

//==============================================================================


//==============================================================================
//        RXB1D3 Bits

extern __at(0x0F59) __sfr RXB1D3;

typedef struct
  {
  unsigned RXB1D30              : 1;
  unsigned RXB1D31              : 1;
  unsigned RXB1D32              : 1;
  unsigned RXB1D33              : 1;
  unsigned RXB1D34              : 1;
  unsigned RXB1D35              : 1;
  unsigned RXB1D36              : 1;
  unsigned RXB1D37              : 1;
  } __RXB1D3bits_t;

extern __at(0x0F59) volatile __RXB1D3bits_t RXB1D3bits;

#define _RXB1D30                0x01
#define _RXB1D31                0x02
#define _RXB1D32                0x04
#define _RXB1D33                0x08
#define _RXB1D34                0x10
#define _RXB1D35                0x20
#define _RXB1D36                0x40
#define _RXB1D37                0x80

//==============================================================================


//==============================================================================
//        RXB1D4 Bits

extern __at(0x0F5A) __sfr RXB1D4;

typedef struct
  {
  unsigned RXB1D40              : 1;
  unsigned RXB1D41              : 1;
  unsigned RXB1D42              : 1;
  unsigned RXB1D43              : 1;
  unsigned RXB1D44              : 1;
  unsigned RXB1D45              : 1;
  unsigned RXB1D46              : 1;
  unsigned RXB1D47              : 1;
  } __RXB1D4bits_t;

extern __at(0x0F5A) volatile __RXB1D4bits_t RXB1D4bits;

#define _RXB1D40                0x01
#define _RXB1D41                0x02
#define _RXB1D42                0x04
#define _RXB1D43                0x08
#define _RXB1D44                0x10
#define _RXB1D45                0x20
#define _RXB1D46                0x40
#define _RXB1D47                0x80

//==============================================================================


//==============================================================================
//        RXB1D5 Bits

extern __at(0x0F5B) __sfr RXB1D5;

typedef struct
  {
  unsigned RXB1D50              : 1;
  unsigned RXB1D51              : 1;
  unsigned RXB1D52              : 1;
  unsigned RXB1D53              : 1;
  unsigned RXB1D54              : 1;
  unsigned RXB1D55              : 1;
  unsigned RXB1D56              : 1;
  unsigned RXB1D57              : 1;
  } __RXB1D5bits_t;

extern __at(0x0F5B) volatile __RXB1D5bits_t RXB1D5bits;

#define _RXB1D50                0x01
#define _RXB1D51                0x02
#define _RXB1D52                0x04
#define _RXB1D53                0x08
#define _RXB1D54                0x10
#define _RXB1D55                0x20
#define _RXB1D56                0x40
#define _RXB1D57                0x80

//==============================================================================


//==============================================================================
//        RXB1D6 Bits

extern __at(0x0F5C) __sfr RXB1D6;

typedef struct
  {
  unsigned RXB1D60              : 1;
  unsigned RXB1D61              : 1;
  unsigned RXB1D62              : 1;
  unsigned RXB1D63              : 1;
  unsigned RXB1D64              : 1;
  unsigned RXB1D65              : 1;
  unsigned RXB1D66              : 1;
  unsigned RXB1D67              : 1;
  } __RXB1D6bits_t;

extern __at(0x0F5C) volatile __RXB1D6bits_t RXB1D6bits;

#define _RXB1D60                0x01
#define _RXB1D61                0x02
#define _RXB1D62                0x04
#define _RXB1D63                0x08
#define _RXB1D64                0x10
#define _RXB1D65                0x20
#define _RXB1D66                0x40
#define _RXB1D67                0x80

//==============================================================================


//==============================================================================
//        RXB1D7 Bits

extern __at(0x0F5D) __sfr RXB1D7;

typedef struct
  {
  unsigned RXB1D70              : 1;
  unsigned RXB1D71              : 1;
  unsigned RXB1D72              : 1;
  unsigned RXB1D73              : 1;
  unsigned RXB1D74              : 1;
  unsigned RXB1D75              : 1;
  unsigned RXB1D76              : 1;
  unsigned RXB1D77              : 1;
  } __RXB1D7bits_t;

extern __at(0x0F5D) volatile __RXB1D7bits_t RXB1D7bits;

#define _RXB1D70                0x01
#define _RXB1D71                0x02
#define _RXB1D72                0x04
#define _RXB1D73                0x08
#define _RXB1D74                0x10
#define _RXB1D75                0x20
#define _RXB1D76                0x40
#define _RXB1D77                0x80

//==============================================================================


//==============================================================================
//        CANSTATRO1 Bits

extern __at(0x0F5E) __sfr CANSTATRO1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTATRO1bits_t;

extern __at(0x0F5E) volatile __CANSTATRO1bits_t CANSTATRO1bits;

#define _CANSTATRO1_ICODE0      0x02
#define _CANSTATRO1_ICODE1      0x04
#define _CANSTATRO1_ICODE2      0x08
#define _CANSTATRO1_OPMODE0     0x20
#define _CANSTATRO1_OPMODE1     0x40
#define _CANSTATRO1_OPMODE2     0x80

//==============================================================================


//==============================================================================
//        RXB0CON Bits

extern __at(0x0F60) __sfr RXB0CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0            : 1;
    unsigned JTOFF              : 1;
    unsigned RXB0DBEN           : 1;
    unsigned RXRTRRO            : 1;
    unsigned                    : 1;
    unsigned RXM0               : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RXM                : 2;
    unsigned                    : 1;
    };
  } __RXB0CONbits_t;

extern __at(0x0F60) volatile __RXB0CONbits_t RXB0CONbits;

#define _FILHIT0                0x01
#define _JTOFF                  0x02
#define _RXB0DBEN               0x04
#define _RXRTRRO                0x08
#define _RXM0                   0x20
#define _RXM1                   0x40
#define _RXFUL                  0x80

//==============================================================================


//==============================================================================
//        RXB0SIDH Bits

extern __at(0x0F61) __sfr RXB0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXB0SIDHbits_t;

extern __at(0x0F61) volatile __RXB0SIDHbits_t RXB0SIDHbits;

#define _SID3                   0x01
#define _SID4                   0x02
#define _SID5                   0x04
#define _SID6                   0x08
#define _SID7                   0x10
#define _SID8                   0x20
#define _SID9                   0x40
#define _SID10                  0x80

//==============================================================================


//==============================================================================
//        RXB0SIDL Bits

extern __at(0x0F62) __sfr RXB0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXID               : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXB0SIDLbits_t;

extern __at(0x0F62) volatile __RXB0SIDLbits_t RXB0SIDLbits;

#define _EID16                  0x01
#define _EID17                  0x02
#define _EXID                   0x08
#define _SRR                    0x10
#define _SID0                   0x20
#define _SID1                   0x40
#define _SID2                   0x80

//==============================================================================


//==============================================================================
//        RXB0EIDH Bits

extern __at(0x0F63) __sfr RXB0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXB0EIDHbits_t;

extern __at(0x0F63) volatile __RXB0EIDHbits_t RXB0EIDHbits;

#define _EID8                   0x01
#define _EID9                   0x02
#define _EID10                  0x04
#define _EID11                  0x08
#define _EID12                  0x10
#define _EID13                  0x20
#define _EID14                  0x40
#define _EID15                  0x80

//==============================================================================


//==============================================================================
//        RXB0EIDL Bits

extern __at(0x0F64) __sfr RXB0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXB0EIDLbits_t;

extern __at(0x0F64) volatile __RXB0EIDLbits_t RXB0EIDLbits;

#define _EID0                   0x01
#define _EID1                   0x02
#define _EID2                   0x04
#define _EID3                   0x08
#define _EID4                   0x10
#define _EID5                   0x20
#define _EID6                   0x40
#define _EID7                   0x80

//==============================================================================


//==============================================================================
//        RXB0DLC Bits

extern __at(0x0F65) __sfr RXB0DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RESB0              : 1;
    unsigned RESB1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RESB               : 2;
    unsigned                    : 2;
    };
  } __RXB0DLCbits_t;

extern __at(0x0F65) volatile __RXB0DLCbits_t RXB0DLCbits;

#define _RXB0DLC_DLC0           0x01
#define _RXB0DLC_DLC1           0x02
#define _RXB0DLC_DLC2           0x04
#define _RXB0DLC_DLC3           0x08
#define _RXB0DLC_RB0            0x10
#define _RXB0DLC_RESB0          0x10
#define _RXB0DLC_RB1            0x20
#define _RXB0DLC_RESB1          0x20
#define _RXB0DLC_RXRTR          0x40

//==============================================================================


//==============================================================================
//        RXB0D0 Bits

extern __at(0x0F66) __sfr RXB0D0;

typedef union
  {
  struct
    {
    unsigned RXB0D00            : 1;
    unsigned RXB0D01            : 1;
    unsigned RXB0D02            : 1;
    unsigned RXB0D03            : 1;
    unsigned RXB0D04            : 1;
    unsigned RXB0D05            : 1;
    unsigned RXB0D06            : 1;
    unsigned RXB0D07            : 1;
    };

  struct
    {
    unsigned RB0D00             : 1;
    unsigned RB0D01             : 1;
    unsigned RB0D02             : 1;
    unsigned RB0D03             : 1;
    unsigned RB0D04             : 1;
    unsigned RB0D05             : 1;
    unsigned RB0D06             : 1;
    unsigned RB0D07             : 1;
    };
  } __RXB0D0bits_t;

extern __at(0x0F66) volatile __RXB0D0bits_t RXB0D0bits;

#define _RXB0D00                0x01
#define _RB0D00                 0x01
#define _RXB0D01                0x02
#define _RB0D01                 0x02
#define _RXB0D02                0x04
#define _RB0D02                 0x04
#define _RXB0D03                0x08
#define _RB0D03                 0x08
#define _RXB0D04                0x10
#define _RB0D04                 0x10
#define _RXB0D05                0x20
#define _RB0D05                 0x20
#define _RXB0D06                0x40
#define _RB0D06                 0x40
#define _RXB0D07                0x80
#define _RB0D07                 0x80

//==============================================================================


//==============================================================================
//        RXB0D1 Bits

extern __at(0x0F67) __sfr RXB0D1;

typedef union
  {
  struct
    {
    unsigned RXB0D10            : 1;
    unsigned RXB0D11            : 1;
    unsigned RXB0D12            : 1;
    unsigned RXB0D13            : 1;
    unsigned RXB0D14            : 1;
    unsigned RXB0D15            : 1;
    unsigned RXB0D16            : 1;
    unsigned RXB0D17            : 1;
    };

  struct
    {
    unsigned RB0D10             : 1;
    unsigned RB0D11             : 1;
    unsigned RB0D12             : 1;
    unsigned RB0D13             : 1;
    unsigned RB0D14             : 1;
    unsigned RB0D15             : 1;
    unsigned RB0D16             : 1;
    unsigned RB0D17             : 1;
    };
  } __RXB0D1bits_t;

extern __at(0x0F67) volatile __RXB0D1bits_t RXB0D1bits;

#define _RXB0D10                0x01
#define _RB0D10                 0x01
#define _RXB0D11                0x02
#define _RB0D11                 0x02
#define _RXB0D12                0x04
#define _RB0D12                 0x04
#define _RXB0D13                0x08
#define _RB0D13                 0x08
#define _RXB0D14                0x10
#define _RB0D14                 0x10
#define _RXB0D15                0x20
#define _RB0D15                 0x20
#define _RXB0D16                0x40
#define _RB0D16                 0x40
#define _RXB0D17                0x80
#define _RB0D17                 0x80

//==============================================================================


//==============================================================================
//        RXB0D2 Bits

extern __at(0x0F68) __sfr RXB0D2;

typedef union
  {
  struct
    {
    unsigned RXB0D20            : 1;
    unsigned RXB0D21            : 1;
    unsigned RXB0D22            : 1;
    unsigned RXB0D23            : 1;
    unsigned RXB0D24            : 1;
    unsigned RXB0D25            : 1;
    unsigned RXB0D26            : 1;
    unsigned RXB0D27            : 1;
    };

  struct
    {
    unsigned RB0D20             : 1;
    unsigned RB0D21             : 1;
    unsigned RB0D22             : 1;
    unsigned RB0D23             : 1;
    unsigned RB0D24             : 1;
    unsigned RB0D25             : 1;
    unsigned RB0D26             : 1;
    unsigned RB0D27             : 1;
    };
  } __RXB0D2bits_t;

extern __at(0x0F68) volatile __RXB0D2bits_t RXB0D2bits;

#define _RXB0D20                0x01
#define _RB0D20                 0x01
#define _RXB0D21                0x02
#define _RB0D21                 0x02
#define _RXB0D22                0x04
#define _RB0D22                 0x04
#define _RXB0D23                0x08
#define _RB0D23                 0x08
#define _RXB0D24                0x10
#define _RB0D24                 0x10
#define _RXB0D25                0x20
#define _RB0D25                 0x20
#define _RXB0D26                0x40
#define _RB0D26                 0x40
#define _RXB0D27                0x80
#define _RB0D27                 0x80

//==============================================================================


//==============================================================================
//        RXB0D3 Bits

extern __at(0x0F69) __sfr RXB0D3;

typedef union
  {
  struct
    {
    unsigned RXB0D30            : 1;
    unsigned RXB0D31            : 1;
    unsigned RXB0D32            : 1;
    unsigned RXB0D33            : 1;
    unsigned RXB0D34            : 1;
    unsigned RXB0D35            : 1;
    unsigned RXB0D36            : 1;
    unsigned RXB0D37            : 1;
    };

  struct
    {
    unsigned RB0D30             : 1;
    unsigned RB0D31             : 1;
    unsigned RB0D32             : 1;
    unsigned RB0D33             : 1;
    unsigned RB0D34             : 1;
    unsigned RB0D35             : 1;
    unsigned RB0D36             : 1;
    unsigned RB0D37             : 1;
    };
  } __RXB0D3bits_t;

extern __at(0x0F69) volatile __RXB0D3bits_t RXB0D3bits;

#define _RXB0D30                0x01
#define _RB0D30                 0x01
#define _RXB0D31                0x02
#define _RB0D31                 0x02
#define _RXB0D32                0x04
#define _RB0D32                 0x04
#define _RXB0D33                0x08
#define _RB0D33                 0x08
#define _RXB0D34                0x10
#define _RB0D34                 0x10
#define _RXB0D35                0x20
#define _RB0D35                 0x20
#define _RXB0D36                0x40
#define _RB0D36                 0x40
#define _RXB0D37                0x80
#define _RB0D37                 0x80

//==============================================================================


//==============================================================================
//        RXB0D4 Bits

extern __at(0x0F6A) __sfr RXB0D4;

typedef union
  {
  struct
    {
    unsigned RXB0D40            : 1;
    unsigned RXB0D41            : 1;
    unsigned RXB0D42            : 1;
    unsigned RXB0D43            : 1;
    unsigned RXB0D44            : 1;
    unsigned RXB0D45            : 1;
    unsigned RXB0D46            : 1;
    unsigned RXB0D47            : 1;
    };

  struct
    {
    unsigned RB0D40             : 1;
    unsigned RB0D41             : 1;
    unsigned RB0D42             : 1;
    unsigned RB0D43             : 1;
    unsigned RB0D44             : 1;
    unsigned RB0D45             : 1;
    unsigned RB0D46             : 1;
    unsigned RB0D47             : 1;
    };
  } __RXB0D4bits_t;

extern __at(0x0F6A) volatile __RXB0D4bits_t RXB0D4bits;

#define _RXB0D40                0x01
#define _RB0D40                 0x01
#define _RXB0D41                0x02
#define _RB0D41                 0x02
#define _RXB0D42                0x04
#define _RB0D42                 0x04
#define _RXB0D43                0x08
#define _RB0D43                 0x08
#define _RXB0D44                0x10
#define _RB0D44                 0x10
#define _RXB0D45                0x20
#define _RB0D45                 0x20
#define _RXB0D46                0x40
#define _RB0D46                 0x40
#define _RXB0D47                0x80
#define _RB0D47                 0x80

//==============================================================================


//==============================================================================
//        RXB0D5 Bits

extern __at(0x0F6B) __sfr RXB0D5;

typedef union
  {
  struct
    {
    unsigned RXB0D50            : 1;
    unsigned RXB0D51            : 1;
    unsigned RXB0D52            : 1;
    unsigned RXB0D53            : 1;
    unsigned RXB0D54            : 1;
    unsigned RXB0D55            : 1;
    unsigned RXB0D56            : 1;
    unsigned RXB0D57            : 1;
    };

  struct
    {
    unsigned RB0D50             : 1;
    unsigned RB0D51             : 1;
    unsigned RB0D52             : 1;
    unsigned RB0D53             : 1;
    unsigned RB0D54             : 1;
    unsigned RB0D55             : 1;
    unsigned RB0D56             : 1;
    unsigned RB0D57             : 1;
    };
  } __RXB0D5bits_t;

extern __at(0x0F6B) volatile __RXB0D5bits_t RXB0D5bits;

#define _RXB0D50                0x01
#define _RB0D50                 0x01
#define _RXB0D51                0x02
#define _RB0D51                 0x02
#define _RXB0D52                0x04
#define _RB0D52                 0x04
#define _RXB0D53                0x08
#define _RB0D53                 0x08
#define _RXB0D54                0x10
#define _RB0D54                 0x10
#define _RXB0D55                0x20
#define _RB0D55                 0x20
#define _RXB0D56                0x40
#define _RB0D56                 0x40
#define _RXB0D57                0x80
#define _RB0D57                 0x80

//==============================================================================


//==============================================================================
//        RXB0D6 Bits

extern __at(0x0F6C) __sfr RXB0D6;

typedef union
  {
  struct
    {
    unsigned RXB0D60            : 1;
    unsigned RXB0D61            : 1;
    unsigned RXB0D62            : 1;
    unsigned RXB0D63            : 1;
    unsigned RXB0D64            : 1;
    unsigned RXB0D65            : 1;
    unsigned RXB0D66            : 1;
    unsigned RXB0D67            : 1;
    };

  struct
    {
    unsigned RB0D60             : 1;
    unsigned RB0D61             : 1;
    unsigned RB0D62             : 1;
    unsigned RB0D63             : 1;
    unsigned RB0D64             : 1;
    unsigned RB0D65             : 1;
    unsigned RB0D66             : 1;
    unsigned RB0D67             : 1;
    };
  } __RXB0D6bits_t;

extern __at(0x0F6C) volatile __RXB0D6bits_t RXB0D6bits;

#define _RXB0D60                0x01
#define _RB0D60                 0x01
#define _RXB0D61                0x02
#define _RB0D61                 0x02
#define _RXB0D62                0x04
#define _RB0D62                 0x04
#define _RXB0D63                0x08
#define _RB0D63                 0x08
#define _RXB0D64                0x10
#define _RB0D64                 0x10
#define _RXB0D65                0x20
#define _RB0D65                 0x20
#define _RXB0D66                0x40
#define _RB0D66                 0x40
#define _RXB0D67                0x80
#define _RB0D67                 0x80

//==============================================================================


//==============================================================================
//        RXB0D7 Bits

extern __at(0x0F6D) __sfr RXB0D7;

typedef union
  {
  struct
    {
    unsigned RXB0D70            : 1;
    unsigned RXB0D71            : 1;
    unsigned RXB0D72            : 1;
    unsigned RXB0D73            : 1;
    unsigned RXB0D74            : 1;
    unsigned RXB0D75            : 1;
    unsigned RXB0D76            : 1;
    unsigned RXB0D77            : 1;
    };

  struct
    {
    unsigned RB0D70             : 1;
    unsigned RB0D71             : 1;
    unsigned RB0D72             : 1;
    unsigned RB0D73             : 1;
    unsigned RB0D74             : 1;
    unsigned RB0D75             : 1;
    unsigned RB0D76             : 1;
    unsigned RB0D77             : 1;
    };
  } __RXB0D7bits_t;

extern __at(0x0F6D) volatile __RXB0D7bits_t RXB0D7bits;

#define _RXB0D70                0x01
#define _RB0D70                 0x01
#define _RXB0D71                0x02
#define _RB0D71                 0x02
#define _RXB0D72                0x04
#define _RB0D72                 0x04
#define _RXB0D73                0x08
#define _RB0D73                 0x08
#define _RXB0D74                0x10
#define _RB0D74                 0x10
#define _RXB0D75                0x20
#define _RB0D75                 0x20
#define _RXB0D76                0x40
#define _RB0D76                 0x40
#define _RXB0D77                0x80
#define _RB0D77                 0x80

//==============================================================================


//==============================================================================
//        CANSTAT Bits

extern __at(0x0F6E) __sfr CANSTAT;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTATbits_t;

extern __at(0x0F6E) volatile __CANSTATbits_t CANSTATbits;

#define _ICODE0                 0x02
#define _ICODE1                 0x04
#define _ICODE2                 0x08
#define _OPMODE0                0x20
#define _OPMODE1                0x40
#define _OPMODE2                0x80

//==============================================================================


//==============================================================================
//        CANCON Bits

extern __at(0x0F6F) __sfr CANCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned ABAT               : 1;
    unsigned REQOP0             : 1;
    unsigned REQOP1             : 1;
    unsigned REQOP2             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned REQOP              : 3;
    };
  } __CANCONbits_t;

extern __at(0x0F6F) volatile __CANCONbits_t CANCONbits;

#define _WIN0                   0x02
#define _WIN1                   0x04
#define _WIN2                   0x08
#define _ABAT                   0x10
#define _REQOP0                 0x20
#define _REQOP1                 0x40
#define _REQOP2                 0x80

//==============================================================================


//==============================================================================
//        BRGCON1 Bits

extern __at(0x0F70) __sfr BRGCON1;

typedef union
  {
  struct
    {
    unsigned BRP0               : 1;
    unsigned BRP1               : 1;
    unsigned BRP2               : 1;
    unsigned BRP3               : 1;
    unsigned BRP4               : 1;
    unsigned BRP5               : 1;
    unsigned SJW0               : 1;
    unsigned SJW1               : 1;
    };

  struct
    {
    unsigned BRP                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SJW                : 2;
    };
  } __BRGCON1bits_t;

extern __at(0x0F70) volatile __BRGCON1bits_t BRGCON1bits;

#define _BRP0                   0x01
#define _BRP1                   0x02
#define _BRP2                   0x04
#define _BRP3                   0x08
#define _BRP4                   0x10
#define _BRP5                   0x20
#define _SJW0                   0x40
#define _SJW1                   0x80

//==============================================================================


//==============================================================================
//        BRGCON2 Bits

extern __at(0x0F71) __sfr BRGCON2;

typedef union
  {
  struct
    {
    unsigned PRSEG0             : 1;
    unsigned PRSEG1             : 1;
    unsigned PRSEG2             : 1;
    unsigned SEG1PH0            : 1;
    unsigned SEG1PH1            : 1;
    unsigned SEG1PH2            : 1;
    unsigned SAM                : 1;
    unsigned SEG2PHTS           : 1;
    };

  struct
    {
    unsigned PRSEG              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned SEG1PH             : 3;
    unsigned                    : 2;
    };
  } __BRGCON2bits_t;

extern __at(0x0F71) volatile __BRGCON2bits_t BRGCON2bits;

#define _PRSEG0                 0x01
#define _PRSEG1                 0x02
#define _PRSEG2                 0x04
#define _SEG1PH0                0x08
#define _SEG1PH1                0x10
#define _SEG1PH2                0x20
#define _SAM                    0x40
#define _SEG2PHTS               0x80

//==============================================================================


//==============================================================================
//        BRGCON3 Bits

extern __at(0x0F72) __sfr BRGCON3;

typedef union
  {
  struct
    {
    unsigned SEG2PH0            : 1;
    unsigned SEG2PH1            : 1;
    unsigned SEG2PH2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned WAKFIL             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SEG2PH             : 3;
    unsigned                    : 5;
    };
  } __BRGCON3bits_t;

extern __at(0x0F72) volatile __BRGCON3bits_t BRGCON3bits;

#define _SEG2PH0                0x01
#define _SEG2PH1                0x02
#define _SEG2PH2                0x04
#define _WAKFIL                 0x40

//==============================================================================


//==============================================================================
//        CIOCON Bits

extern __at(0x0F73) __sfr CIOCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CANCAP               : 1;
  unsigned ENDRHI               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CIOCONbits_t;

extern __at(0x0F73) volatile __CIOCONbits_t CIOCONbits;

#define _CANCAP                 0x10
#define _ENDRHI                 0x20

//==============================================================================


//==============================================================================
//        COMSTAT Bits

extern __at(0x0F74) __sfr COMSTAT;

typedef union
  {
  struct
    {
    unsigned EWARN              : 1;
    unsigned RXWARN             : 1;
    unsigned TXWARN             : 1;
    unsigned RXBP               : 1;
    unsigned TXBP               : 1;
    unsigned TXBO               : 1;
    unsigned RXB1OVFL           : 1;
    unsigned RXB0OVFL           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX2OVFL            : 1;
    unsigned RX1OVFL            : 1;
    };
  } __COMSTATbits_t;

extern __at(0x0F74) volatile __COMSTATbits_t COMSTATbits;

#define _EWARN                  0x01
#define _RXWARN                 0x02
#define _TXWARN                 0x04
#define _RXBP                   0x08
#define _TXBP                   0x10
#define _TXBO                   0x20
#define _RXB1OVFL               0x40
#define _RX2OVFL                0x40
#define _RXB0OVFL               0x80
#define _RX1OVFL                0x80

//==============================================================================


//==============================================================================
//        RXERRCNT Bits

extern __at(0x0F75) __sfr RXERRCNT;

typedef struct
  {
  unsigned REC0                 : 1;
  unsigned REC1                 : 1;
  unsigned REC2                 : 1;
  unsigned REC3                 : 1;
  unsigned REC4                 : 1;
  unsigned REC5                 : 1;
  unsigned REC6                 : 1;
  unsigned REC7                 : 1;
  } __RXERRCNTbits_t;

extern __at(0x0F75) volatile __RXERRCNTbits_t RXERRCNTbits;

#define _REC0                   0x01
#define _REC1                   0x02
#define _REC2                   0x04
#define _REC3                   0x08
#define _REC4                   0x10
#define _REC5                   0x20
#define _REC6                   0x40
#define _REC7                   0x80

//==============================================================================


//==============================================================================
//        TXERRCNT Bits

extern __at(0x0F76) __sfr TXERRCNT;

typedef struct
  {
  unsigned TEC0                 : 1;
  unsigned TEC1                 : 1;
  unsigned TEC2                 : 1;
  unsigned TEC3                 : 1;
  unsigned TEC4                 : 1;
  unsigned TEC5                 : 1;
  unsigned TEC6                 : 1;
  unsigned TEC7                 : 1;
  } __TXERRCNTbits_t;

extern __at(0x0F76) volatile __TXERRCNTbits_t TXERRCNTbits;

#define _TEC0                   0x01
#define _TEC1                   0x02
#define _TEC2                   0x04
#define _TEC3                   0x08
#define _TEC4                   0x10
#define _TEC5                   0x20
#define _TEC6                   0x40
#define _TEC7                   0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned T0CKI              : 1;
    unsigned AN4                : 1;
    unsigned OSC2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CVREF              : 1;
    unsigned                    : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned                    : 1;
    unsigned NOT_SS             : 1;
    unsigned CLKO               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 7;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_CVREF            0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_RA2              0x04
#define _PORTA_AN2              0x04
#define _PORTA_VREFM            0x04
#define _PORTA_RA3              0x08
#define _PORTA_AN3              0x08
#define _PORTA_VREFP            0x08
#define _PORTA_RA4              0x10
#define _PORTA_T0CKI            0x10
#define _PORTA_RA5              0x20
#define _PORTA_AN4              0x20
#define _PORTA_NOT_SS           0x20
#define _PORTA_SS               0x20
#define _PORTA_LVDIN            0x20
#define _PORTA_RA6              0x40
#define _PORTA_OSC2             0x40
#define _PORTA_CLKO             0x40

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned CANTX              : 1;
    unsigned CANRX              : 1;
    unsigned                    : 1;
    unsigned PGM                : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned INT                : 2;
    unsigned                    : 6;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_INT0             0x01
#define _PORTB_RB1              0x02
#define _PORTB_INT1             0x02
#define _PORTB_RB2              0x04
#define _PORTB_CANTX            0x04
#define _PORTB_RB3              0x08
#define _PORTB_CANRX            0x08
#define _PORTB_RB4              0x10
#define _PORTB_RB5              0x20
#define _PORTB_PGM              0x20
#define _PORTB_RB6              0x40
#define _PORTB_PGC              0x40
#define _PORTB_RB7              0x80
#define _PORTB_PGD              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned CCP1               : 1;
    unsigned SCK                : 1;
    unsigned SDI                : 1;
    unsigned SDO                : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T1CKI              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCL                : 1;
    unsigned SDA                : 1;
    unsigned                    : 1;
    unsigned CK                 : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T1CKI            0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_RC2              0x04
#define _PORTC_CCP1             0x04
#define _PORTC_RC3              0x08
#define _PORTC_SCK              0x08
#define _PORTC_SCL              0x08
#define _PORTC_RC4              0x10
#define _PORTC_SDI              0x10
#define _PORTC_SDA              0x10
#define _PORTC_RC5              0x20
#define _PORTC_SDO              0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef union
  {
  struct
    {
    unsigned LATA0              : 1;
    unsigned LATA1              : 1;
    unsigned LATA2              : 1;
    unsigned LATA3              : 1;
    unsigned LATA4              : 1;
    unsigned LATA5              : 1;
    unsigned LATA6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATA               : 7;
    unsigned                    : 1;
    };
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 7;
    unsigned                    : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20
#define _TRISA6                 0x40
#define _RA6                    0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 7;
    unsigned                    : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC3                 0x08
#define _RC3                    0x08
#define _TRISC4                 0x10
#define _RC4                    0x10
#define _TRISC5                 0x20
#define _RC5                    0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC3           0x08
#define _TRISC_RC3              0x08
#define _TRISC_TRISC4           0x10
#define _TRISC_RC4              0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_RC5              0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSPIE                : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned                      : 1;
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSPIF                : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned                      : 1;
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef struct
  {
  unsigned TMR1IP               : 1;
  unsigned TMR2IP               : 1;
  unsigned CCP1IP               : 1;
  unsigned SSPIP                : 1;
  unsigned TXIP                 : 1;
  unsigned RCIP                 : 1;
  unsigned ADIP                 : 1;
  unsigned                      : 1;
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSPIP                  0x08
#define _TXIP                   0x10
#define _RCIP                   0x20
#define _ADIP                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR3IE               : 1;
  unsigned LVDIE                : 1;
  unsigned BCLIE                : 1;
  unsigned EEIE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _TMR3IE                 0x02
#define _LVDIE                  0x04
#define _BCLIE                  0x08
#define _EEIE                   0x10

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR3IF               : 1;
  unsigned LVDIF                : 1;
  unsigned BCLIF                : 1;
  unsigned EEIF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _TMR3IF                 0x02
#define _LVDIF                  0x04
#define _BCLIF                  0x08
#define _EEIF                   0x10

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR3IP               : 1;
  unsigned LVDIP                : 1;
  unsigned BCLIP                : 1;
  unsigned EEIP                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _TMR3IP                 0x02
#define _LVDIP                  0x04
#define _BCLIP                  0x08
#define _EEIP                   0x10

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef union
  {
  struct
    {
    unsigned RXB0IE             : 1;
    unsigned RXB1IE             : 1;
    unsigned TXB0IE             : 1;
    unsigned TXB1IE             : 1;
    unsigned TXB2IE             : 1;
    unsigned ERRIE              : 1;
    unsigned WAKIE              : 1;
    unsigned IRXIE              : 1;
    };

  struct
    {
    unsigned RX0IE              : 1;
    unsigned RX1IE              : 1;
    unsigned TX0IE              : 1;
    unsigned TX1IE              : 1;
    unsigned TX2IE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IVRE               : 1;
    };
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _RXB0IE                 0x01
#define _RX0IE                  0x01
#define _RXB1IE                 0x02
#define _RX1IE                  0x02
#define _TXB0IE                 0x04
#define _TX0IE                  0x04
#define _TXB1IE                 0x08
#define _TX1IE                  0x08
#define _TXB2IE                 0x10
#define _TX2IE                  0x10
#define _ERRIE                  0x20
#define _WAKIE                  0x40
#define _IRXIE                  0x80
#define _IVRE                   0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef union
  {
  struct
    {
    unsigned RXB0IF             : 1;
    unsigned RXB1IF             : 1;
    unsigned TXB0IF             : 1;
    unsigned TXB1IF             : 1;
    unsigned TXB2IF             : 1;
    unsigned ERRIF              : 1;
    unsigned WAKIF              : 1;
    unsigned IRXIF              : 1;
    };

  struct
    {
    unsigned RX0IF              : 1;
    unsigned RX1IF              : 1;
    unsigned TX0IF              : 1;
    unsigned TX1IF              : 1;
    unsigned TX2IF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IVRF               : 1;
    };
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _RXB0IF                 0x01
#define _RX0IF                  0x01
#define _RXB1IF                 0x02
#define _RX1IF                  0x02
#define _TXB0IF                 0x04
#define _TX0IF                  0x04
#define _TXB1IF                 0x08
#define _TX1IF                  0x08
#define _TXB2IF                 0x10
#define _TX2IF                  0x10
#define _ERRIF                  0x20
#define _WAKIF                  0x40
#define _IRXIF                  0x80
#define _IVRF                   0x80

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef union
  {
  struct
    {
    unsigned RXB0IP             : 1;
    unsigned RXB1IP             : 1;
    unsigned TXB0IP             : 1;
    unsigned TXB1IP             : 1;
    unsigned TXB2IP             : 1;
    unsigned ERRIP              : 1;
    unsigned WAKIP              : 1;
    unsigned IRXIP              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IVRP               : 1;
    };
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _RXB0IP                 0x01
#define _RXB1IP                 0x02
#define _TXB0IP                 0x04
#define _TXB1IP                 0x08
#define _TXB2IP                 0x10
#define _ERRIP                  0x20
#define _WAKIP                  0x40
#define _IRXIP                  0x80
#define _IVRP                   0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef union
  {
  struct
    {
    unsigned RD                 : 1;
    unsigned WR                 : 1;
    unsigned WREN               : 1;
    unsigned WRERR              : 1;
    unsigned FREE               : 1;
    unsigned                    : 1;
    unsigned CFGS               : 1;
    unsigned EEPGD              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned EEFS               : 1;
    unsigned                    : 1;
    };
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEFS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;
extern __at(0x0FA8) __sfr EEDATA;
extern __at(0x0FA9) __sfr EEADR;

//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC9                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _RC8_9                  0x40
#define _NOT_RC8                0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _TX8_9                  0x40
#define _NOT_TX8                0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAF) __sfr SPBRG;

//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned TMR3CS             : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned T3CCP1             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned T3ECCP1            : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_TMR3CS           0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_T3INSYNC         0x04
#define _T3CON_T3SYNC           0x04
#define _T3CON_T3CCP1           0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_T3ECCP1          0x40
#define _T3CON_RD16             0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned PCFG0              : 1;
    unsigned PCFG1              : 1;
    unsigned PCFG2              : 1;
    unsigned PCFG3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned PCFG               : 4;
    unsigned                    : 4;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04
#define _PCFG3                  0x08
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CHS                : 3;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned ADCS               : 2;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x04
#define _DONE                   0x04
#define _GO_DONE                0x04
#define _GO                     0x04
#define _NOT_DONE               0x04
#define _CHS0                   0x08
#define _CHS1                   0x10
#define _CHS2                   0x20
#define _ADCS0                  0x40
#define _ADCS1                  0x80

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned I2C_DATA           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _I2C_READ               0x04
#define _R                      0x04
#define _READ_WRITE             0x04
#define _NOT_WRITE              0x04
#define _NOT_W                  0x04
#define _R_W                    0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _I2C_DATA               0x20
#define _D                      0x20
#define _DATA_ADDRESS           0x20
#define _NOT_ADDRESS            0x20
#define _NOT_A                  0x20
#define _D_A                    0x20
#define _I2C_DAT                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned                    : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1INSYNC               0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _RD16                   0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_IPEN           : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _IPEN                   0x80
#define _NOT_IPEN               0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0FD2) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x0FD2) volatile __LVDCONbits_t LVDCONbits;

#define _LVDL0                  0x01
#define _LVDL1                  0x02
#define _LVDL2                  0x04
#define _LVDL3                  0x08
#define _LVDEN                  0x10
#define _IRVST                  0x20
#define _IVRST                  0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef struct
  {
  unsigned SCS                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS                    0x01

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned                    : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned                    : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned                    : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned                    : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned                    : 1;
    unsigned TMR0IP             : 1;
    unsigned                    : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================


//==============================================================================
//        INTCON1 Bits

extern __at(0x0FF2) __sfr INTCON1;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCON1bits_t;

extern __at(0x0FF2) volatile __INTCON1bits_t INTCON1bits;

#define _INTCON1_RBIF           0x01
#define _INTCON1_INT0IF         0x02
#define _INTCON1_INT0F          0x02
#define _INTCON1_TMR0IF         0x04
#define _INTCON1_T0IF           0x04
#define _INTCON1_RBIE           0x08
#define _INTCON1_INT0IE         0x10
#define _INTCON1_INT0E          0x10
#define _INTCON1_TMR0IE         0x20
#define _INTCON1_T0IE           0x20
#define _INTCON1_PEIE_GIEL      0x40
#define _INTCON1_PEIE           0x40
#define _INTCON1_GIEL           0x40
#define _INTCON1_GIE_GIEH       0x80
#define _INTCON1_GIE            0x80
#define _INTCON1_GIEH           0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned STKPTR0            : 1;
    unsigned STKPTR1            : 1;
    unsigned STKPTR2            : 1;
    unsigned STKPTR3            : 1;
    unsigned STKPTR4            : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned STKPTR             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _STKPTR0                0x01
#define _SP0                    0x01
#define _STKPTR1                0x02
#define _SP1                    0x02
#define _STKPTR2                0x04
#define _SP2                    0x04
#define _STKPTR3                0x08
#define _SP3                    0x08
#define _STKPTR4                0x10
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1H Options -------------------------------

#define _LP_OSC                 0xF8    // LP oscillator.
#define _LP_OSC_1H              0xF8    // LP oscillator.
#define _XT_OSC                 0xF9    // XT oscillator.
#define _XT_OSC_1H              0xF9    // XT oscillator.
#define _HS_OSC                 0xFA    // HS oscillator.
#define _HS_OSC_1H              0xFA    // HS oscillator.
#define _RC_OSC                 0xFB    // RC oscillator.
#define _RC_OSC_1H              0xFB    // RC oscillator.
#define _EC_OSC                 0xFC    // EC oscillator w/ OSC2 configured as divide-by-4 clock output.
#define _EC_OSC_1H              0xFC    // EC oscillator w/ OSC2 configured as divide-by-4 clock output.
#define _ECIO_OSC               0xFD    // EC oscillator w/ OSC2 configured as RA6.
#define _ECIO_OSC_1H            0xFD    // EC oscillator w/ OSC2 configured as RA6.
#define _HSPLL_OSC              0xFE    // HS oscillator with PLL enabled/Clock frequency = (4 x FOSC).
#define _HSPLL_OSC_1H           0xFE    // HS oscillator with PLL enabled/Clock frequency = (4 x FOSC).
#define _RCIO_OSC               0xFF    // RC oscillator w/ OSC2 configured as RA6.
#define _RCIO_OSC_1H            0xFF    // RC oscillator w/ OSC2 configured as RA6.
#define _OSCS_ON_1H             0xDF    // Oscillator system clock switch option is enabled (oscillator switching is enabled).
#define _OSCS_OFF_1H            0xFF    // Oscillator system clock switch option is disabled (main oscillator is source).

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRT_ON_2L             0xFE    // PWRT enabled.
#define _PWRT_OFF_2L            0xFF    // PWRT disabled.
#define _BOR_OFF_2L             0xFD    // Brown-out Reset disabled.
#define _BOR_ON_2L              0xFF    // Brown-out Reset enabled.
#define _BORV_45_2L             0xF3    // VBOR set to 4.5V.
#define _BORV_42_2L             0xF7    // VBOR set to 4.2V.
#define _BORV_27_2L             0xFB    // VBOR set to 2.7V.
#define _BORV_25                0xFF    // VBOR set to 2.5V.
#define _BORV_25_2L             0xFF    // VBOR set to 2.5V.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDT_OFF_2H             0xFE    // WDT disabled (control is placed on the SWDTEN bit).
#define _WDT_ON_2H              0xFF    // WDT enabled.
#define _WDTPS_1_2H             0xF1    // 1:1.
#define _WDTPS_2_2H             0xF3    // 1:2.
#define _WDTPS_4_2H             0xF5    // 1:4.
#define _WDTPS_8_2H             0xF7    // 1:8.
#define _WDTPS_16_2H            0xF9    // 1:16.
#define _WDTPS_32_2H            0xFB    // 1:32.
#define _WDTPS_64_2H            0xFD    // 1:64.
#define _WDTPS_128_2H           0xFF    // 1:128.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVR_OFF_4L            0xFE    // Stack Full/Underflow will not cause Reset.
#define _STVR_ON_4L             0xFF    // Stack Full/Underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Low-Voltage ICSP disabled.
#define _LVP_ON_4L              0xFF    // Low-Voltage ICSP enabled.
#define _DEBUG_ON_4L            0x7F    // Background Debugger enabled. RB6 and RB7 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background Debugger disabled. RB6 and RB7 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 (000200-001FFFh) code protected.
#define _CP0_OFF_5L             0xFF    // Block 0 (000200-001FFFh) not code protected.
#define _CP1_ON_5L              0xFD    // Block 1 (002000-003FFFh) code protected.
#define _CP1_OFF_5L             0xFF    // Block 1 (002000-003FFFh) not code protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot Block (000000-0001FFh) code protected.
#define _CPB_OFF_5H             0xFF    // Boot Block (000000-0001FFh) not code protected.
#define _CPD_ON_5H              0x7F    // Data EEPROM code protected.
#define _CPD_OFF_5H             0xFF    // Data EEPROM not code protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 (000200-001FFFh) write protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 (000200-001FFFh) not write protected.
#define _WRT1_ON_6L             0xFD    // Block 1 (002000-003FFFh) write protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 (002000-003FFFh) not write protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers (300000-3000FFh) write protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers (300000-3000FFh) not write protected.
#define _WRTB_ON_6H             0xBF    // Boot Block (000000-0001FFh) write protected.
#define _WRTB_OFF_6H            0xFF    // Boot Block (000000-0001FFh) not write protected.
#define _WRTD_ON_6H             0x7F    // Data EEPROM write protected.
#define _WRTD_OFF_6H            0xFF    // Data EEPROM not write protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 (000200-001FFFh) protected from Table Reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 (000200-001FFFh) not protected from Table Reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 (002000-003FFFh) protected from Table Reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 (002000-003FFFh) not protected from Table Reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot Block (000000-0001FFh) protected from Table Reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot Block (000000-0001FFh) not protected from Table Reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F248_H__
