import { Stylesheet, TextDocument } from 'vscode-css-languageservice';
import { Position } from 'vscode-languageserver';
import { Document, DocumentMapper, ReadableDocument } from '../../lib/documents';
import { CSSLanguageServices } from './service';
export interface CSSDocumentBase extends DocumentMapper, TextDocument {
    languageId: string;
    stylesheet: Stylesheet;
}
export declare class CSSDocument extends ReadableDocument implements DocumentMapper {
    private parent;
    private styleInfo;
    readonly version: number;
    stylesheet: Stylesheet;
    languageId: string;
    constructor(parent: Document, languageServices: CSSLanguageServices);
    /**
     * Get the fragment position relative to the parent
     * @param pos Position in fragment
     */
    getOriginalPosition(pos: Position): Position;
    /**
     * Get the position relative to the start of the fragment
     * @param pos Position in parent
     */
    getGeneratedPosition(pos: Position): Position;
    /**
     * Returns true if the given parent position is inside of this fragment
     * @param pos Position in parent
     */
    isInGenerated(pos: Position): boolean;
    /**
     * Get the fragment text from the parent
     */
    getText(): string;
    /**
     * Returns the length of the fragment as calculated from the start and end positon
     */
    getTextLength(): number;
    /**
     * Return the parent file path
     */
    getFilePath(): string | null;
    getURL(): string;
    getAttributes(): Record<string, string>;
    private get language();
}
