import { FoldingRange } from 'vscode-languageserver-types';
import { Document } from '../../../lib/documents';
import { FoldingRangeProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
import { LSConfigManager } from '../../../ls-config';
export declare class FoldingRangeProviderImpl implements FoldingRangeProvider {
    private readonly lsAndTsDocResolver;
    private readonly configManager;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, configManager: LSConfigManager);
    private readonly foldEndPairCharacters;
    getFoldingRanges(document: Document): Promise<FoldingRange[]>;
    private mapToOriginalRange;
    /**
     * Doing this here with the svelte2tsx's svelte ast is slightly
     * less prone to error and faster than
     * using the svelte ast in the svelte plugins.
     */
    private collectSvelteBlockFolding;
    private getIfBlockFolding;
    private getStartForNodeWithExpression;
    private createFoldingRange;
    private convertOutliningSpan;
    private getFoldingRangeKind;
    private adjustFoldingEndToNotHideEnd;
    private getSvelteTagFoldingIfParserError;
    private getHtmlTemplateRangesForChecking;
    private previousLineOfEndLine;
}
