/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.util.RTPMediaThread;
import java.util.Vector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SessionEvent;

public class RTPEventHandler
extends RTPMediaThread {
    private RTPSessionMgr sm;
    private Vector eventQueue = new Vector();
    private boolean killed = false;

    public RTPEventHandler(RTPSessionMgr sm) {
        super("RTPEventHandler");
        this.sm = sm;
        this.useControlPriority();
        this.setDaemon(true);
        this.start();
    }

    protected void processEvent(RTPEvent evt) {
        if (evt instanceof SessionEvent) {
            int i = 0;
            while (i < this.sm.sessionlistener.size()) {
                SessionListener sl = (SessionListener)this.sm.sessionlistener.elementAt(i);
                if (sl != null) {
                    sl.update((SessionEvent)evt);
                }
                ++i;
            }
            return;
        }
        if (evt instanceof RemoteEvent) {
            int i = 0;
            while (i < this.sm.remotelistener.size()) {
                RemoteListener sl = (RemoteListener)this.sm.remotelistener.elementAt(i);
                if (sl != null) {
                    sl.update((RemoteEvent)evt);
                }
                ++i;
            }
            return;
        }
        if (evt instanceof ReceiveStreamEvent) {
            int i = 0;
            while (i < this.sm.streamlistener.size()) {
                ReceiveStreamListener sl = (ReceiveStreamListener)this.sm.streamlistener.elementAt(i);
                if (sl != null) {
                    sl.update((ReceiveStreamEvent)evt);
                }
                ++i;
            }
            return;
        }
        if (evt instanceof SendStreamEvent) {
            int i = 0;
            while (i < this.sm.sendstreamlistener.size()) {
                SendStreamListener sl = (SendStreamListener)this.sm.sendstreamlistener.elementAt(i);
                if (sl != null) {
                    sl.update((SendStreamEvent)evt);
                }
                ++i;
            }
        }
    }

    protected void dispatchEvents() {
        RTPEvent evt;
        RTPEventHandler rTPEventHandler = this;
        synchronized (rTPEventHandler) {
            try {
                while (this.eventQueue.size() == 0 && !this.killed) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.killed) {
                return;
            }
            evt = (RTPEvent)this.eventQueue.elementAt(0);
            this.eventQueue.removeElementAt(0);
        }
        this.processEvent(evt);
    }

    public synchronized void postEvent(RTPEvent evt) {
        this.eventQueue.addElement(evt);
        this.notifyAll();
    }

    public synchronized void close() {
        this.killed = true;
        this.notifyAll();
    }

    public void run() {
        while (!this.killed) {
            this.dispatchEvents();
        }
    }
}

