/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.sdkmanager.internal;

import com.android.SdkConstants;
import com.jakewharton.sdkmanager.internal.AndroidCommand;
import com.jakewharton.sdkmanager.internal.System;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.io.FileInputStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.StopExecutionException;

public class PackageResolver
implements GroovyObject {
    private static final String GOOGLE_API_PREFIX = "Google Inc.:Google APIs:";
    private static final String GOOGLE_GDK_PREFIX = "Google Inc.:Glass Development Kit Preview:";
    private final Logger log;
    private final Project project;
    private final File sdk;
    private final File buildToolsDir;
    private final File platformToolsDir;
    private final File platformsDir;
    private final File addonsDir;
    private final File androidRepositoryDir;
    private final File googleRepositoryDir;
    private final AndroidCommand androidCommand;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public PackageResolver(Project project, File file, AndroidCommand androidCommand) {
        void androidCommand2;
        void project2;
        void sdk;
        MetaClass metaClass;
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        Object object = callSiteArray[0].call(Logging.class, PackageResolver.class);
        this.log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var7_7 = sdk;
        this.sdk = (File)ScriptBytecodeAdapter.castToType((Object)var7_7, File.class);
        void var8_8 = project2;
        this.project = (Project)ScriptBytecodeAdapter.castToType((Object)var8_8, Project.class);
        void var9_9 = androidCommand2;
        this.androidCommand = (AndroidCommand)ScriptBytecodeAdapter.castToType((Object)var9_9, AndroidCommand.class);
        Object object2 = callSiteArray[1].callConstructor(File.class, (Object)sdk, callSiteArray[2].callGetProperty(SdkConstants.class));
        this.buildToolsDir = (File)ScriptBytecodeAdapter.castToType((Object)object2, File.class);
        Object object3 = callSiteArray[3].callConstructor(File.class, (Object)sdk, callSiteArray[4].callGetProperty(SdkConstants.class));
        this.platformToolsDir = (File)ScriptBytecodeAdapter.castToType((Object)object3, File.class);
        Object object4 = callSiteArray[5].callConstructor(File.class, (Object)sdk, callSiteArray[6].callGetProperty(SdkConstants.class));
        this.platformsDir = (File)ScriptBytecodeAdapter.castToType((Object)object4, File.class);
        Object object5 = callSiteArray[7].callConstructor(File.class, (Object)sdk, callSiteArray[8].callGetProperty(SdkConstants.class));
        this.addonsDir = (File)ScriptBytecodeAdapter.castToType((Object)object5, File.class);
        Object extrasDir = callSiteArray[9].callConstructor(File.class, (Object)sdk, callSiteArray[10].callGetProperty(SdkConstants.class));
        Object androidExtrasDir = callSiteArray[11].callConstructor(File.class, extrasDir, (Object)"android");
        Object object6 = callSiteArray[12].callConstructor(File.class, androidExtrasDir, callSiteArray[13].callGetProperty(SdkConstants.class));
        this.androidRepositoryDir = (File)ScriptBytecodeAdapter.castToType((Object)object6, File.class);
        Object googleExtrasDir = callSiteArray[14].callConstructor(File.class, extrasDir, (Object)"google");
        Object object7 = callSiteArray[15].callConstructor(File.class, googleExtrasDir, callSiteArray[16].callGetProperty(SdkConstants.class));
        this.googleRepositoryDir = (File)ScriptBytecodeAdapter.castToType((Object)object7, File.class);
    }

    public static void resolve(Project project, File sdk) {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        callSiteArray[17].call(callSiteArray[18].callConstructor(PackageResolver.class, (Object)project, (Object)sdk, callSiteArray[19].callConstructor(AndroidCommand.Real.class, (Object)sdk, callSiteArray[20].callConstructor(System.Real.class))));
    }

    public static boolean folderExists(File folder) {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call((Object)folder)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[22].callGetProperty(callSiteArray[23].call((Object)folder)), (Object)0);
    }

    public Object resolve() {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[24].callCurrent((GroovyObject)this);
            callSiteArray[25].callCurrent((GroovyObject)this);
            callSiteArray[26].callCurrent((GroovyObject)this);
            callSiteArray[27].callCurrent((GroovyObject)this);
            callSiteArray[28].callCurrent((GroovyObject)this);
            return callSiteArray[29].callCurrent((GroovyObject)this);
        }
        this.resolveBuildTools();
        this.resolvePlatformTools();
        this.resolveCompileVersion();
        this.resolveSupportLibraryRepository();
        this.resolvePlayServiceRepository();
        return this.resolveEmulator();
    }

    public Object resolveBuildTools() {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        Object buildToolsRevision = callSiteArray[30].callGetProperty(callSiteArray[31].callGetProperty((Object)this.project));
        callSiteArray[32].call((Object)this.log, (Object)new GStringImpl(new Object[]{buildToolsRevision}, new String[]{"Build tools version: ", ""}));
        Object buildToolsRevisionDir = callSiteArray[33].callConstructor(File.class, (Object)this.buildToolsDir, callSiteArray[34].call(buildToolsRevision));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].callStatic(PackageResolver.class, buildToolsRevisionDir))) {
            callSiteArray[36].call((Object)this.log, (Object)"Build tools found!");
            return null;
        }
        callSiteArray[37].call((Object)this.log, (Object)new GStringImpl(new Object[]{buildToolsRevision}, new String[]{"Build tools ", " missing. Downloading..."}));
        Object code = callSiteArray[38].call((Object)this.androidCommand, (Object)new GStringImpl(new Object[]{buildToolsRevision}, new String[]{"build-tools-", ""}));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)code, (Object)0)) {
            throw (Throwable)callSiteArray[39].callConstructor(StopExecutionException.class, (Object)new GStringImpl(new Object[]{code}, new String[]{"Build tools download failed with code ", "."}));
        }
        return null;
    }

    public Object resolvePlatformTools() {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].callStatic(PackageResolver.class, (Object)this.platformToolsDir))) {
            callSiteArray[41].call((Object)this.log, (Object)"Platform tools found!");
            return null;
        }
        callSiteArray[42].call((Object)this.log, (Object)"Platform tools missing. Downloading...");
        Object code = callSiteArray[43].call((Object)this.androidCommand, (Object)"platform-tools");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)code, (Object)0)) {
            throw (Throwable)callSiteArray[44].callConstructor(StopExecutionException.class, (Object)new GStringImpl(new Object[]{code}, new String[]{"Platform tools download failed with code ", "."}));
        }
        return null;
    }

    public Object resolveCompileVersion() {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        String compileVersion = ShortTypeHandling.castToString((Object)callSiteArray[45].callGetProperty(callSiteArray[46].callGetProperty((Object)this.project)));
        callSiteArray[47].call((Object)this.log, (Object)new GStringImpl(new Object[]{compileVersion}, new String[]{"Compile API version: ", ""}));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call((Object)compileVersion, (Object)GOOGLE_API_PREFIX))) {
            Object baseVersion = callSiteArray[49].call((Object)compileVersion, (Object)GOOGLE_API_PREFIX, (Object)"android-");
            callSiteArray[50].callCurrent((GroovyObject)this, (Object)this.platformsDir, baseVersion);
            Object addonVersion = callSiteArray[51].call((Object)compileVersion, (Object)GOOGLE_API_PREFIX, (Object)"addon-google_apis-google-");
            return callSiteArray[52].callCurrent((GroovyObject)this, (Object)this.addonsDir, addonVersion);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].call((Object)compileVersion, (Object)GOOGLE_GDK_PREFIX))) {
            Object gdkVersion = callSiteArray[54].call((Object)compileVersion, (Object)GOOGLE_GDK_PREFIX, (Object)"addon-google_gdk-google-");
            return callSiteArray[55].callCurrent((GroovyObject)this, (Object)this.platformsDir, gdkVersion);
        }
        return callSiteArray[56].callCurrent((GroovyObject)this, (Object)this.platformsDir, (Object)compileVersion);
    }

    public Object installIfMissing(Object baseDir, Object version) {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        Object existingDir = callSiteArray[57].callConstructor(File.class, baseDir, version);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].callStatic(PackageResolver.class, existingDir))) {
            callSiteArray[59].call((Object)this.log, (Object)new GStringImpl(new Object[]{version}, new String[]{"Compilation API ", " found!"}));
            return null;
        }
        callSiteArray[60].call((Object)this.log, (Object)new GStringImpl(new Object[]{version}, new String[]{"Compilation API ", " missing. Downloading..."}));
        Object code = callSiteArray[61].call((Object)this.androidCommand, version);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)code, (Object)0)) {
            throw (Throwable)callSiteArray[62].callConstructor(StopExecutionException.class, (Object)new GStringImpl(new Object[]{version, code}, new String[]{"Compilation API ", " download failed with code ", "."}));
        }
        return null;
    }

    public Object resolveSupportLibraryRepository() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        Object supportDeps = null;
        supportDeps = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[63].callCurrent((GroovyObject)this, (Object)"com.android.support")) : (object = this.findDependenciesStartingWith("com.android.support"));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(supportDeps))) {
            callSiteArray[65].call((Object)this.log, (Object)"No support library dependency found.");
            return null;
        }
        callSiteArray[66].call((Object)this.log, (Object)new GStringImpl(new Object[]{supportDeps}, new String[]{"Found support library dependencies: ", ""}));
        class _resolveSupportLibraryRepository_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolveSupportLibraryRepository_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _resolveSupportLibraryRepository_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resolveSupportLibraryRepository_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)this);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _resolveSupportLibraryRepository_closure1.class, (GroovyObject)this, (String)"url");
                return object;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _resolveSupportLibraryRepository_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveSupportLibraryRepository_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "androidRepositoryDir";
                return new CallSiteArray(_resolveSupportLibraryRepository_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveSupportLibraryRepository_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[67].call(callSiteArray[68].callGetProperty((Object)this.project), (Object)new _resolveSupportLibraryRepository_closure1(this, this));
        Boolean needsDownload = false;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[69].callStatic(PackageResolver.class, (Object)this.androidRepositoryDir))) {
            boolean bl = true;
            needsDownload = bl;
            callSiteArray[70].call((Object)this.log, (Object)"Support library repository missing. Downloading...");
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].callCurrent((GroovyObject)this, supportDeps))) {
            boolean bl = true;
            needsDownload = bl;
            callSiteArray[72].call((Object)this.log, (Object)"Support library repository outdated. Downloading update...");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)needsDownload)) {
            Object code = callSiteArray[73].call((Object)this.androidCommand, (Object)"extra-android-m2repository");
            if (ScriptBytecodeAdapter.compareNotEqual((Object)code, (Object)0)) {
                throw (Throwable)callSiteArray[74].callConstructor(StopExecutionException.class, (Object)new GStringImpl(new Object[]{code}, new String[]{"Support repository download failed with code ", "."}));
            }
            return null;
        }
        return null;
    }

    public Object resolvePlayServiceRepository() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        Object playServicesDeps = null;
        playServicesDeps = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[75].callCurrent((GroovyObject)this, (Object)"com.google.android.gms")) : (object = this.findDependenciesWithGroup("com.google.android.gms"));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].call(playServicesDeps))) {
            callSiteArray[77].call((Object)this.log, (Object)"No Google Play Services dependency found.");
            return null;
        }
        callSiteArray[78].call((Object)this.log, (Object)new GStringImpl(new Object[]{playServicesDeps}, new String[]{"Found Google Play Services dependencies: ", ""}));
        class _resolvePlayServiceRepository_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolvePlayServiceRepository_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _resolvePlayServiceRepository_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resolvePlayServiceRepository_closure2.$getCallSiteArray();
                class _closure3
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure3(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)this);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _closure3.class, (GroovyObject)this, (String)"url");
                        return object;
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "androidRepositoryDir";
                        return new CallSiteArray(_closure3.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure3.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].callCurrent((GroovyObject)this, (Object)new _closure3((Object)this, this.getThisObject()));
                class _closure4
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure4(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)this);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _closure4.class, (GroovyObject)this, (String)"url");
                        return object;
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "googleRepositoryDir";
                        return new CallSiteArray(_closure4.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure4.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)new _closure4((Object)this, this.getThisObject()));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _resolvePlayServiceRepository_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolvePlayServiceRepository_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "maven";
                stringArray[1] = "maven";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _resolvePlayServiceRepository_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolvePlayServiceRepository_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolvePlayServiceRepository_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[79].call((Object)this.project, (Object)new _resolvePlayServiceRepository_closure2(this, this));
        Boolean needsDownload = false;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].callStatic(PackageResolver.class, (Object)this.googleRepositoryDir))) {
            boolean bl = true;
            needsDownload = bl;
            callSiteArray[81].call((Object)this.log, (Object)"Google Play Services repository missing. Downloading...");
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[82].callCurrent((GroovyObject)this, playServicesDeps))) {
            boolean bl = true;
            needsDownload = bl;
            callSiteArray[83].call((Object)this.log, (Object)"Google Play Services repository outdated. Downloading update...");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)needsDownload)) {
            Object code = callSiteArray[84].call((Object)this.androidCommand, (Object)"extra-google-m2repository");
            if (ScriptBytecodeAdapter.compareNotEqual((Object)code, (Object)0)) {
                throw (Throwable)callSiteArray[85].callConstructor(StopExecutionException.class, (Object)new GStringImpl(new Object[]{code}, new String[]{"Google Play Services repository download failed with code ", "."}));
            }
            return null;
        }
        return null;
    }

    public Object resolveEmulator() {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        Object emulatorVersion = callSiteArray[86].callGetProperty(callSiteArray[87].callGetProperty((Object)this.project));
        if (ScriptBytecodeAdapter.compareEqual((Object)emulatorVersion, null)) {
            callSiteArray[88].call((Object)this.log, (Object)"No emulator defined");
            return null;
        }
        Object emulatorArchitecture = callSiteArray[89].callGetProperty(callSiteArray[90].callGetProperty((Object)this.project));
        if (ScriptBytecodeAdapter.compareEqual((Object)emulatorArchitecture, null)) {
            String string = "armeabi-v7a";
            emulatorArchitecture = string;
            callSiteArray[91].call((Object)this.log, (Object)"No architecture specified, defaulting to armeabi-v7a");
        }
        callSiteArray[92].call((Object)this.log, (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture}, new String[]{"Found emulator: ", " ", ""}));
        Object emulatorDir = callSiteArray[93].callConstructor(File.class, (Object)this.sdk, callSiteArray[94].call(callSiteArray[95].callGetProperty(SdkConstants.class), (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture}, new String[]{"/", "/", ""})));
        Object alternativeEmulatorDir = callSiteArray[96].callConstructor(File.class, (Object)this.sdk, callSiteArray[97].call(callSiteArray[98].callGetProperty(SdkConstants.class), (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture}, new String[]{"/", "/default/", ""})));
        GStringImpl emulatorPackage = new GStringImpl(new Object[]{emulatorArchitecture, emulatorVersion}, new String[]{"sys-img-", "-", ""});
        Boolean needsDownload = false;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[99].callStatic(PackageResolver.class, emulatorDir)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[100].callStatic(PackageResolver.class, alternativeEmulatorDir))) {
                boolean bl = true;
                needsDownload = bl;
                callSiteArray[101].call((Object)this.log, (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture}, new String[]{"Emulator ", " ", " missing. Downloading..."}));
            } else {
                Object emulatorPropertiesFile = callSiteArray[102].callConstructor(File.class, emulatorDir, (Object)"source.properties");
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[103].call(emulatorPropertiesFile))) {
                    Object object;
                    emulatorPropertiesFile = object = callSiteArray[104].callConstructor(File.class, alternativeEmulatorDir, (Object)"source.properties");
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[105].call(emulatorPropertiesFile))) {
                        throw (Throwable)callSiteArray[106].callConstructor(StopExecutionException.class, callSiteArray[107].call((Object)"Could not read ", callSiteArray[108].callGetProperty(emulatorPropertiesFile)));
                    }
                }
                Object emulatorProperties = callSiteArray[109].callConstructor(Properties.class);
                callSiteArray[110].call(emulatorProperties, callSiteArray[111].callConstructor(FileInputStream.class, emulatorPropertiesFile));
                Object emulatorRevision = callSiteArray[112].call(emulatorProperties, (Object)"Pkg.Revision");
                if (ScriptBytecodeAdapter.compareEqual((Object)emulatorRevision, null)) {
                    throw (Throwable)callSiteArray[113].callConstructor(StopExecutionException.class, callSiteArray[114].call((Object)"Could not get the installed emulator revision for ", (Object)emulatorPackage));
                }
                Object currentEmulatorInfo = callSiteArray[115].call((Object)this.androidCommand, (Object)emulatorPackage);
                if (ScriptBytecodeAdapter.compareEqual((Object)currentEmulatorInfo, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[116].call(currentEmulatorInfo))) {
                    throw (Throwable)callSiteArray[117].callConstructor(StopExecutionException.class, callSiteArray[118].call((Object)"Could not get the current emulator revision for ", (Object)emulatorPackage));
                }
                Object matcher = callSiteArray[119].call(callSiteArray[120].call(Pattern.class, (Object)"Revision\\ ([0-9]+)"), currentEmulatorInfo);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[121].call(matcher))) {
                    throw (Throwable)callSiteArray[122].callConstructor(StopExecutionException.class, callSiteArray[123].call((Object)"Could not find the current emulator revision for ", (Object)emulatorPackage));
                }
                if (DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)emulatorRevision, Integer.TYPE)) < DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[124].call(matcher, (Object)1), Integer.TYPE))) {
                    boolean bl = true;
                    needsDownload = bl;
                    callSiteArray[125].call((Object)this.log, (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture}, new String[]{"Emulator ", " ", " outdated. Downloading update..."}));
                }
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[126].callStatic(PackageResolver.class, emulatorDir)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[127].callStatic(PackageResolver.class, alternativeEmulatorDir))) {
            boolean bl = true;
            needsDownload = bl;
            callSiteArray[128].call((Object)this.log, (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture}, new String[]{"Emulator ", " ", " missing. Downloading..."}));
        } else {
            Object emulatorPropertiesFile = callSiteArray[129].callConstructor(File.class, emulatorDir, (Object)"source.properties");
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[130].call(emulatorPropertiesFile))) {
                Object object;
                emulatorPropertiesFile = object = callSiteArray[131].callConstructor(File.class, alternativeEmulatorDir, (Object)"source.properties");
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[132].call(emulatorPropertiesFile))) {
                    throw (Throwable)callSiteArray[133].callConstructor(StopExecutionException.class, callSiteArray[134].call((Object)"Could not read ", callSiteArray[135].callGetProperty(emulatorPropertiesFile)));
                }
            }
            Object emulatorProperties = callSiteArray[136].callConstructor(Properties.class);
            callSiteArray[137].call(emulatorProperties, callSiteArray[138].callConstructor(FileInputStream.class, emulatorPropertiesFile));
            Object emulatorRevision = callSiteArray[139].call(emulatorProperties, (Object)"Pkg.Revision");
            if (ScriptBytecodeAdapter.compareEqual((Object)emulatorRevision, null)) {
                throw (Throwable)callSiteArray[140].callConstructor(StopExecutionException.class, callSiteArray[141].call((Object)"Could not get the installed emulator revision for ", (Object)emulatorPackage));
            }
            Object currentEmulatorInfo = callSiteArray[142].call((Object)this.androidCommand, (Object)emulatorPackage);
            if (ScriptBytecodeAdapter.compareEqual((Object)currentEmulatorInfo, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[143].call(currentEmulatorInfo))) {
                throw (Throwable)callSiteArray[144].callConstructor(StopExecutionException.class, callSiteArray[145].call((Object)"Could not get the current emulator revision for ", (Object)emulatorPackage));
            }
            Object matcher = callSiteArray[146].call(callSiteArray[147].call(Pattern.class, (Object)"Revision\\ ([0-9]+)"), currentEmulatorInfo);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[148].call(matcher))) {
                throw (Throwable)callSiteArray[149].callConstructor(StopExecutionException.class, callSiteArray[150].call((Object)"Could not find the current emulator revision for ", (Object)emulatorPackage));
            }
            if (DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)emulatorRevision, Integer.TYPE)) < DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[151].call(matcher, (Object)1), Integer.TYPE))) {
                boolean bl = true;
                needsDownload = bl;
                callSiteArray[152].call((Object)this.log, (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture}, new String[]{"Emulator ", " ", " outdated. Downloading update..."}));
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)needsDownload)) {
            Object code = callSiteArray[153].call((Object)this.androidCommand, (Object)emulatorPackage);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)code, (Object)0)) {
                throw (Throwable)callSiteArray[154].callConstructor(StopExecutionException.class, (Object)new GStringImpl(new Object[]{emulatorVersion, emulatorArchitecture, code}, new String[]{"Emulator ", " ", " download failed with code ", "."}));
            }
            return null;
        }
        return null;
    }

    public Object findDependenciesWithGroup(String group) {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        List deps = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Configuration configuration = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].call(callSiteArray[156].callGetProperty((Object)this.project)), Iterator.class);
        while (iterator.hasNext()) {
            configuration = (Configuration)ScriptBytecodeAdapter.castToType(iterator.next(), Configuration.class);
            Dependency dependency = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[157].call(callSiteArray[158].callGetProperty((Object)configuration)), Iterator.class);
            while (iterator2.hasNext()) {
                dependency = (Dependency)ScriptBytecodeAdapter.castToType(iterator2.next(), Dependency.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[159].call((Object)group, callSiteArray[160].callGetProperty((Object)dependency)))) continue;
                callSiteArray[161].call((Object)deps, (Object)dependency);
            }
        }
        return deps;
    }

    public Object findDependenciesStartingWith(String prefix) {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        List deps = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Configuration configuration = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].call(callSiteArray[163].callGetProperty((Object)this.project)), Iterator.class);
        while (iterator.hasNext()) {
            configuration = (Configuration)ScriptBytecodeAdapter.castToType(iterator.next(), Configuration.class);
            Dependency dependency = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].call(callSiteArray[165].callGetProperty((Object)configuration)), Iterator.class);
            while (iterator2.hasNext()) {
                dependency = (Dependency)ScriptBytecodeAdapter.castToType(iterator2.next(), Dependency.class);
                if (!(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[166].callGetProperty((Object)dependency), null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[167].call(callSiteArray[168].callGetProperty((Object)dependency), (Object)prefix)))) continue;
                callSiteArray[169].call((Object)deps, (Object)dependency);
            }
        }
        return deps;
    }

    public Object dependenciesAvailable(Object deps) {
        CallSite[] callSiteArray = PackageResolver.$getCallSiteArray();
        callSiteArray[170].callGetProperty(callSiteArray[171].call(callSiteArray[172].callGetProperty((Object)this.project), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Dependency[])ScriptBytecodeAdapter.asType((Object)deps, Dependency[].class)), Dependency[].class)));
        Boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
            Boolean bl2 = false;
            return bl2;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PackageResolver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static final String getGOOGLE_API_PREFIX() {
        return GOOGLE_API_PREFIX;
    }

    public static final String getGOOGLE_GDK_PREFIX() {
        return GOOGLE_GDK_PREFIX;
    }

    public final Logger getLog() {
        return this.log;
    }

    public final Project getProject() {
        return this.project;
    }

    public final File getSdk() {
        return this.sdk;
    }

    public final File getBuildToolsDir() {
        return this.buildToolsDir;
    }

    public final File getPlatformToolsDir() {
        return this.platformToolsDir;
    }

    public final File getPlatformsDir() {
        return this.platformsDir;
    }

    public final File getAddonsDir() {
        return this.addonsDir;
    }

    public final File getAndroidRepositoryDir() {
        return this.androidRepositoryDir;
    }

    public final File getGoogleRepositoryDir() {
        return this.googleRepositoryDir;
    }

    public final AndroidCommand getAndroidCommand() {
        return this.androidCommand;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "FD_BUILD_TOOLS";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "FD_PLATFORM_TOOLS";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "FD_PLATFORMS";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "FD_ADDONS";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "FD_EXTRAS";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "FD_M2_REPOSITORY";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "FD_M2_REPOSITORY";
        stringArray[17] = "resolve";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "exists";
        stringArray[22] = "length";
        stringArray[23] = "list";
        stringArray[24] = "resolveBuildTools";
        stringArray[25] = "resolvePlatformTools";
        stringArray[26] = "resolveCompileVersion";
        stringArray[27] = "resolveSupportLibraryRepository";
        stringArray[28] = "resolvePlayServiceRepository";
        stringArray[29] = "resolveEmulator";
        stringArray[30] = "buildToolsRevision";
        stringArray[31] = "android";
        stringArray[32] = "debug";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "toString";
        stringArray[35] = "folderExists";
        stringArray[36] = "debug";
        stringArray[37] = "lifecycle";
        stringArray[38] = "update";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "folderExists";
        stringArray[41] = "debug";
        stringArray[42] = "lifecycle";
        stringArray[43] = "update";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "compileSdkVersion";
        stringArray[46] = "android";
        stringArray[47] = "debug";
        stringArray[48] = "startsWith";
        stringArray[49] = "replace";
        stringArray[50] = "installIfMissing";
        stringArray[51] = "replace";
        stringArray[52] = "installIfMissing";
        stringArray[53] = "startsWith";
        stringArray[54] = "replace";
        stringArray[55] = "installIfMissing";
        stringArray[56] = "installIfMissing";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "folderExists";
        stringArray[59] = "debug";
        stringArray[60] = "lifecycle";
        stringArray[61] = "update";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "findDependenciesStartingWith";
        stringArray[64] = "isEmpty";
        stringArray[65] = "debug";
        stringArray[66] = "debug";
        stringArray[67] = "maven";
        stringArray[68] = "repositories";
        stringArray[69] = "folderExists";
        stringArray[70] = "lifecycle";
        stringArray[71] = "dependenciesAvailable";
        stringArray[72] = "lifecycle";
        stringArray[73] = "update";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "findDependenciesWithGroup";
        stringArray[76] = "isEmpty";
        stringArray[77] = "debug";
        stringArray[78] = "debug";
        stringArray[79] = "repositories";
        stringArray[80] = "folderExists";
        stringArray[81] = "lifecycle";
        stringArray[82] = "dependenciesAvailable";
        stringArray[83] = "lifecycle";
        stringArray[84] = "update";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "emulatorVersion";
        stringArray[87] = "sdkManager";
        stringArray[88] = "debug";
        stringArray[89] = "emulatorArchitecture";
        stringArray[90] = "sdkManager";
        stringArray[91] = "debug";
        stringArray[92] = "debug";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "plus";
        stringArray[95] = "FD_SYSTEM_IMAGES";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "plus";
        stringArray[98] = "FD_SYSTEM_IMAGES";
        stringArray[99] = "folderExists";
        stringArray[100] = "folderExists";
        stringArray[101] = "lifecycle";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "canRead";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "canRead";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "plus";
        stringArray[108] = "absolutePath";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "load";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "getProperty";
        stringArray[113] = "<$constructor$>";
        stringArray[114] = "plus";
        stringArray[115] = "list";
        stringArray[116] = "isEmpty";
        stringArray[117] = "<$constructor$>";
        stringArray[118] = "plus";
        stringArray[119] = "matcher";
        stringArray[120] = "compile";
        stringArray[121] = "find";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "plus";
        stringArray[124] = "group";
        stringArray[125] = "lifecycle";
        stringArray[126] = "folderExists";
        stringArray[127] = "folderExists";
        stringArray[128] = "lifecycle";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "canRead";
        stringArray[131] = "<$constructor$>";
        stringArray[132] = "canRead";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "plus";
        stringArray[135] = "absolutePath";
        stringArray[136] = "<$constructor$>";
        stringArray[137] = "load";
        stringArray[138] = "<$constructor$>";
        stringArray[139] = "getProperty";
        stringArray[140] = "<$constructor$>";
        stringArray[141] = "plus";
        stringArray[142] = "list";
        stringArray[143] = "isEmpty";
        stringArray[144] = "<$constructor$>";
        stringArray[145] = "plus";
        stringArray[146] = "matcher";
        stringArray[147] = "compile";
        stringArray[148] = "find";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "plus";
        stringArray[151] = "group";
        stringArray[152] = "lifecycle";
        stringArray[153] = "update";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "iterator";
        stringArray[156] = "configurations";
        stringArray[157] = "iterator";
        stringArray[158] = "dependencies";
        stringArray[159] = "equals";
        stringArray[160] = "group";
        stringArray[161] = "add";
        stringArray[162] = "iterator";
        stringArray[163] = "configurations";
        stringArray[164] = "iterator";
        stringArray[165] = "dependencies";
        stringArray[166] = "group";
        stringArray[167] = "startsWith";
        stringArray[168] = "group";
        stringArray[169] = "add";
        stringArray[170] = "files";
        stringArray[171] = "detachedConfiguration";
        stringArray[172] = "configurations";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[173];
        PackageResolver.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PackageResolver.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PackageResolver.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

