/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.Property;
import genj.gedcom.Repository;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class RepositoriesTableModel
extends AbstractTableModel {
    List<Repository> mRepositoriesList = new ArrayList<Repository>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(RepositoriesTableModel.class, (String)"RepositoriesTableModel.column.ID.title"), NbBundle.getMessage(RepositoriesTableModel.class, (String)"RepositoriesTableModel.column.name.title")};

    @Override
    public int getRowCount() {
        return this.mRepositoriesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.mRepositoriesList.size()) {
            Repository repository = this.mRepositoriesList.get(row);
            switch (column) {
                case 0: {
                    return repository.getId();
                }
                case 1: {
                    Property name = repository.getProperty("NAME");
                    return name != null ? name.getValue() : "";
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(Repository entity) {
        this.mRepositoriesList.add(entity);
        this.fireTableDataChanged();
    }

    public void addAll(List<Repository> mRepositoriesList) {
        this.mRepositoriesList.addAll(mRepositoriesList);
        this.fireTableDataChanged();
    }

    public Property remove(int row) {
        Property note = (Property)this.mRepositoriesList.remove(row);
        this.fireTableDataChanged();
        return note;
    }

    public void clear() {
        this.mRepositoriesList.clear();
    }

    public Repository getValueAt(int row) {
        if (row < this.mRepositoriesList.size()) {
            return this.mRepositoriesList.get(row);
        }
        return null;
    }
}

