/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.RepositoryEditor;
import ancestris.modules.editors.genealogyeditor.models.RepositoriesTableModel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyRepository;
import genj.gedcom.Repository;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RepositoriesTablePanel
extends JPanel {
    private Property mRoot;
    private final RepositoriesTableModel mRepositoriesTableModel = new RepositoriesTableModel();
    private Repository mRepository;
    private JButton addRepositoryButton;
    private JButton deleteRepositoryButton;
    private JButton editRepositoryButton;
    private EditorTable repositoriesTable;
    private JScrollPane repositoriesTableScrollPane;
    private JToolBar repositoriesToolBar;

    public RepositoriesTablePanel() {
        this.initComponents();
        this.repositoriesTable.setID(RepositoriesTablePanel.class.getName());
    }

    private void initComponents() {
        this.repositoriesToolBar = new JToolBar();
        this.addRepositoryButton = new JButton();
        this.editRepositoryButton = new JButton();
        this.deleteRepositoryButton = new JButton();
        this.repositoriesTableScrollPane = new JScrollPane();
        this.repositoriesTable = new EditorTable();
        this.repositoriesToolBar.setFloatable(false);
        this.repositoriesToolBar.setRollover(true);
        this.addRepositoryButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addRepositoryButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("RepositoriesTablePanel.addRepositoryButton.toolTipText"), new Object[0]));
        this.addRepositoryButton.setFocusable(false);
        this.addRepositoryButton.setHorizontalTextPosition(0);
        this.addRepositoryButton.setVerticalTextPosition(3);
        this.addRepositoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoriesTablePanel.this.addRepositoryButtonActionPerformed(evt);
            }
        });
        this.repositoriesToolBar.add(this.addRepositoryButton);
        this.editRepositoryButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editRepositoryButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("RepositoriesTablePanel.editRepositoryButton.toolTipText"), new Object[0]));
        this.editRepositoryButton.setFocusable(false);
        this.editRepositoryButton.setHorizontalTextPosition(0);
        this.editRepositoryButton.setVerticalTextPosition(3);
        this.editRepositoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoriesTablePanel.this.editRepositoryButtonActionPerformed(evt);
            }
        });
        this.repositoriesToolBar.add(this.editRepositoryButton);
        this.deleteRepositoryButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteRepositoryButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("RepositoriesTablePanel.deleteRepositoryButton.toolTipText"), new Object[0]));
        this.deleteRepositoryButton.setFocusable(false);
        this.deleteRepositoryButton.setHorizontalTextPosition(0);
        this.deleteRepositoryButton.setVerticalTextPosition(3);
        this.deleteRepositoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoriesTablePanel.this.deleteRepositoryButtonActionPerformed(evt);
            }
        });
        this.repositoriesToolBar.add(this.deleteRepositoryButton);
        this.repositoriesTable.setModel(this.mRepositoriesTableModel);
        this.repositoriesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RepositoriesTablePanel.this.repositoriesTableMouseClicked(evt);
            }
        });
        this.repositoriesTableScrollPane.setViewportView(this.repositoriesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoriesToolBar, -1, 539, Short.MAX_VALUE).addComponent(this.repositoriesTableScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.repositoriesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repositoriesTableScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void addRepositoryButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    RepositoriesTablePanel.this.mRepository = (Repository)gedcom.createEntity("REPO");
                }
            });
            RepositoryEditor repositoryEditor = new RepositoryEditor();
            repositoryEditor.setContext(new Context((Entity)this.mRepository));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(repositoryEditor);
            if (repositoryEditor.showPanel()) {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        Property addProperty = RepositoriesTablePanel.this.mRoot.addProperty("REPO", '@' + RepositoriesTablePanel.this.mRepository.getId() + '@');
                        ((PropertyRepository)addProperty).link();
                    }
                });
                this.mRepositoriesTableModel.add(this.mRepository);
                this.editRepositoryButton.setEnabled(true);
                this.deleteRepositoryButton.setEnabled(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            atc.getOpenEditors().remove((Object)repositoryEditor);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editRepositoryButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.repositoriesTable.getSelectedRow();
        Gedcom gedcom = this.mRoot.getGedcom();
        if (selectedRow != -1) {
            int rowIndex = this.repositoriesTable.convertRowIndexToModel(selectedRow);
            RepositoryEditor repositoryEditor = new RepositoryEditor();
            repositoryEditor.setContext(new Context((Entity)this.mRepositoriesTableModel.getValueAt(rowIndex)));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(repositoryEditor);
            repositoryEditor.showPanel();
            atc.getOpenEditors().remove((Object)repositoryEditor);
        }
    }

    private void deleteRepositoryButtonActionPerformed(ActionEvent evt) {
        Repository repository;
        DialogManager createYesNo;
        final int selectedRow = this.repositoriesTable.getSelectedRow();
        Gedcom gedcom = this.mRoot.getGedcom();
        if (selectedRow != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(RepositoriesTablePanel.class, (String)"RepositoriesTableDialog.deleteRepository.title", (Object)(repository = this.mRepositoriesTableModel.getValueAt(this.repositoriesTable.convertRowIndexToModel(selectedRow)))), (String)NbBundle.getMessage(RepositoriesTablePanel.class, (String)"RepositoriesTableDialog.deleteRepository.text", (Object)repository, (Object)this.mRoot))).show() == DialogManager.YES_OPTION) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        RepositoriesTablePanel.this.mRoot.delProperty(RepositoriesTablePanel.this.mRepositoriesTableModel.remove(RepositoriesTablePanel.this.repositoriesTable.convertRowIndexToModel(selectedRow)));
                    }
                });
                if (this.mRepositoriesTableModel.getRowCount() <= 0) {
                    this.editRepositoryButton.setEnabled(false);
                    this.deleteRepositoryButton.setEnabled(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void repositoriesTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            int selectedRow = this.repositoriesTable.getSelectedRow();
            Gedcom gedcom = this.mRoot.getGedcom();
            if (selectedRow != -1) {
                int rowIndex = this.repositoriesTable.convertRowIndexToModel(selectedRow);
                RepositoryEditor repositoryEditor = new RepositoryEditor();
                repositoryEditor.setContext(new Context((Entity)this.mRepositoriesTableModel.getValueAt(rowIndex)));
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(repositoryEditor);
                repositoryEditor.showPanel();
                atc.getOpenEditors().remove((Object)repositoryEditor);
            }
        }
    }

    public void set(Property root, List<Repository> repositoriesList) {
        this.mRoot = root;
        this.mRepositoriesTableModel.clear();
        Collections.sort(repositoriesList);
        this.mRepositoriesTableModel.addAll(repositoriesList);
        if (this.mRepositoriesTableModel.getRowCount() > 0) {
            this.editRepositoryButton.setEnabled(true);
            this.deleteRepositoryButton.setEnabled(true);
        } else {
            this.editRepositoryButton.setEnabled(false);
            this.deleteRepositoryButton.setEnabled(false);
        }
    }

    public void setToolBarVisible(boolean b) {
        this.repositoriesToolBar.setVisible(b);
    }

    public Repository getSelectedRepository() {
        int selectedRow = this.repositoriesTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.repositoriesTable.convertRowIndexToModel(selectedRow);
            return this.mRepositoriesTableModel.getValueAt(rowIndex);
        }
        return null;
    }
}

