/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.modules.commonAncestor.CommonAncestorTree;
import ancestris.modules.commonAncestor.FamilyAncestor;
import ancestris.modules.commonAncestor.PreviewTopComponent;
import ancestris.modules.commonAncestor.QuickSearchProvider;
import ancestris.modules.commonAncestor.quicksearch.module.QuickSearchComboBar;
import ancestris.modules.commonAncestor.quicksearch.module.QuickSearchPopup;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.io.FileAssociation;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SamePanel
extends JPanel
implements AncestorListener {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private static final String PREFERRED_ID = "SamePanel";
    protected static final String AUTOPREVIEW = "autopreview";
    protected static final String SEPARATED_WINDOW = "separatedWindow";
    protected static final String DISPLAY_ID = "displayIDs";
    protected static final String PRIVINFO = "privinfo";
    protected static final String HUSBWIFE = "husbwife";
    protected static final String DEGREELAW = "degreelaw";
    protected static final String LISTSORT = "listsort";
    protected static final String DEFAULT_FILE_TYPE_NAME = "FileTypeName";
    private static final String QUICKSEARCH_CATEGORY_INDIVIDU_1 = "Individu1";
    private static final String QUICKSEARCH_CATEGORY_INDIVIDU_2 = "Individu2";
    private Context context;
    private Indi currentIndi;
    private Indi individu1;
    private Indi individu2;
    private final CommonAncestorTree commonAncestorTree = new CommonAncestorTree();
    private final DefaultListModel<FamilyAncestor> ancestorListModel = new DefaultListModel();
    protected Registry registry;
    protected PreviewTopComponent previewTopComponent = null;
    private boolean isSortBusy = false;
    private JButton exportButton;
    private JButton jButtonHelp;
    private JButton jButtonSaveFile;
    private JCheckBox jCheckBoxAutoPreview;
    private JCheckBox jCheckBoxDisplayedId;
    private JCheckBox jCheckBoxRecentEvent;
    private JCheckBox jCheckBoxSeparatedWindow;
    private JComboBox<String> jComboBoxDegreeLaw;
    private JComboBox<String> jComboBoxFileType;
    private JComboBox<String> jComboBoxHusbandOrWife;
    private JLabel jLabelAncestorList;
    private JLabel jLabelIndividu1;
    private JLabel jLabelIndividu2;
    private JLabel jLabelValueIndividu1;
    private JLabel jLabelValueIndividu2;
    private JList<FamilyAncestor> jListAncestors;
    private JPanel jPanel3;
    private JPanel jPanelExportFile;
    private JPanel jPanelOption;
    private JPanel jPanelSearch1;
    private JPanel jPanelSearch2;
    private JScrollPane jScrollPaneAncestortList;
    private JToggleButton jShowToggleButton;
    private JButton jbuttonCurrentIndi1;
    private JButton jbuttonCurrentIndi2;
    private JToggleButton sortDegreeToggleButton;
    private JToggleButton sortNameToggleButton;

    public void init(Context context) {
        if (this.context != null) {
            return;
        }
        if (context == null) {
            return;
        }
        this.context = context;
        this.registry = new Registry(Registry.get(SamePanel.class), this.getClass().getName());
        this.initComponents();
        this.jListAncestors.setModel(this.ancestorListModel);
        QuickSearchProvider searchProvider1 = new QuickSearchProvider();
        searchProvider1.setSamePanel(this);
        String categoryDisplayName1 = "";
        String commandPrefix1 = "";
        int maxResult = 10;
        int allMaxResult = 10000;
        QuickSearchComboBar quickSearchIndividu1 = new QuickSearchComboBar(QUICKSEARCH_CATEGORY_INDIVIDU_1, categoryDisplayName1, searchProvider1, commandPrefix1, null, maxResult, allMaxResult, QuickSearchPopup.WidthMode.HORIZONTAL_SCOLLBAR);
        this.jPanelSearch1.setLayout(new BorderLayout());
        this.jPanelSearch1.add((Component)quickSearchIndividu1, "Center");
        QuickSearchProvider searchProvider2 = new QuickSearchProvider();
        searchProvider2.setSamePanel(this);
        String categoryDisplayName2 = "";
        String commandPrefix2 = "";
        QuickSearchComboBar quickSearchIndividu2 = new QuickSearchComboBar(QUICKSEARCH_CATEGORY_INDIVIDU_2, categoryDisplayName2, searchProvider2, commandPrefix2, null, maxResult, allMaxResult, QuickSearchPopup.WidthMode.HORIZONTAL_SCOLLBAR);
        this.jPanelSearch2.setLayout(new BorderLayout());
        this.jPanelSearch2.add((Component)quickSearchIndividu2, "Center");
        this.jShowToggleButton.setEnabled(false);
        this.jShowToggleButton.setSelected(false);
        this.jCheckBoxSeparatedWindow.setSelected(this.registry.get(SEPARATED_WINDOW, false));
        this.jCheckBoxDisplayedId.setSelected(this.registry.get(DISPLAY_ID, false));
        this.jCheckBoxRecentEvent.setSelected(this.registry.get(PRIVINFO, true));
        this.jComboBoxHusbandOrWife.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(SamePanel.class, (String)"SamePanel.husband"), NbBundle.getMessage(SamePanel.class, (String)"SamePanel.wife")}));
        this.jComboBoxHusbandOrWife.setSelectedIndex(this.registry.get(HUSBWIFE, 0));
        this.jComboBoxDegreeLaw.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(SamePanel.class, (String)"SamePanel.canonlaw"), NbBundle.getMessage(SamePanel.class, (String)"SamePanel.civillaw")}));
        this.jComboBoxDegreeLaw.setSelectedIndex(this.registry.get(DEGREELAW, 0));
        this.jComboBoxFileType.setModel(new DefaultComboBoxModel<String>(this.commonAncestorTree.getFileTypeNames().toArray(new String[this.commonAncestorTree.getFileTypeNames().size()])));
        if (this.jComboBoxFileType.getModel().getSize() > 0) {
            this.jComboBoxFileType.setSelectedItem(this.registry.get(DEFAULT_FILE_TYPE_NAME, (String)this.jComboBoxFileType.getModel().getElementAt(0)));
        } else {
            this.jComboBoxFileType.setEnabled(false);
        }
        this.updateCurrentIndividu(context.getEntity());
        if (context.getGedcom() != null) {
            String id2;
            String id1 = context.getGedcom().getRegistry().get("SamePanel.individu1", "");
            if (!id1.equalsIgnoreCase("")) {
                this.individu1 = (Indi)context.getGedcom().getEntity("INDI", id1);
                if (this.individu1 != null) {
                    this.jLabelValueIndividu1.setText(this.individu1.toString());
                }
            }
            if (!(id2 = context.getGedcom().getRegistry().get("SamePanel.individu2", "")).equalsIgnoreCase("")) {
                this.individu2 = (Indi)context.getGedcom().getEntity("INDI", id2);
                if (this.individu2 != null) {
                    this.jLabelValueIndividu2.setText(this.individu2.toString());
                }
            }
        } else {
            this.individu1 = null;
            this.individu2 = null;
            this.jLabelValueIndividu1.setText("");
            this.jLabelValueIndividu2.setText("");
        }
        this.sortDegreeToggleButton.setSelected(this.registry.get(LISTSORT, true));
        this.sortNameToggleButton.setSelected(!this.sortDegreeToggleButton.isSelected());
        this.findCommonAncestors();
        this.revalidate();
        this.jCheckBoxAutoPreview.setSelected(this.registry.get(AUTOPREVIEW, false));
        if (this.jCheckBoxAutoPreview.isSelected()) {
            this.togglePreview(true);
        }
    }

    public void togglePreview(boolean set) {
        this.jShowToggleButton.setSelected(set);
        if (this.jShowToggleButton.isSelected()) {
            this.openPreview();
        } else {
            this.closePreview();
        }
    }

    void openPreview() {
        int i = this.jListAncestors.getSelectedIndex();
        if (i == -1) {
            return;
        }
        if (this.context != null) {
            if (this.previewTopComponent == null) {
                this.previewTopComponent = PreviewTopComponent.createInstance(this);
                if (this.previewTopComponent == null) {
                    return;
                }
                this.previewTopComponent.addAncestorListener(this);
                this.jCheckBoxSeparatedWindow.setSelected(this.previewTopComponent.getSeparatedWindowFlag());
                this.jCheckBoxSeparatedWindow.setEnabled(true);
            } else {
                this.previewTopComponent.requestActive();
            }
            int husband_or_wife_first = this.jComboBoxHusbandOrWife.getSelectedIndex();
            int degreelaw = this.jComboBoxDegreeLaw.getSelectedIndex();
            FamilyAncestor ancestor = null;
            if (this.jListAncestors.getSelectedIndex() >= 0) {
                ancestor = this.ancestorListModel.getElementAt(this.jListAncestors.getSelectedIndex());
            }
            boolean displayRecentYears = this.jCheckBoxRecentEvent.isSelected();
            boolean displayId = this.jCheckBoxDisplayedId.isSelected();
            this.commonAncestorTree.createPreview(this.individu1, this.individu2, ancestor.fam, displayId, displayRecentYears, husband_or_wife_first, degreelaw, this.previewTopComponent);
        }
    }

    protected void closePreview() {
        if (this.previewTopComponent != null) {
            this.previewTopComponent.close();
            this.previewTopComponent = null;
        }
    }

    protected void onClosePreview() {
        this.previewTopComponent = null;
        this.jShowToggleButton.setSelected(false);
    }

    public Context getContext() {
        return this.context;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateCurrentIndividu(Entity entity) {
        block8: {
            block9: {
                if (entity == null) break block8;
                if (!(entity instanceof Fam)) break block9;
                if (((Fam)entity).getNoOfSpouses() == 0) {
                    return;
                }
                Fam focusFam = (Fam)entity;
                Indi husb = focusFam.getHusband();
                Indi wife = focusFam.getWife();
                if (husb == null && wife == null) {
                    this.currentIndi = null;
                    break block8;
                } else if (wife == null) {
                    this.currentIndi = husb;
                    break block8;
                } else {
                    if (husb != null) {
                        this.currentIndi = husb;
                        this.jbuttonCurrentIndi1.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"SamePanel.selectAsFirst", (Object)husb.getName()));
                        this.jbuttonCurrentIndi2.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"SamePanel.selectAsSecond", (Object)wife.getName()));
                        this.jbuttonCurrentIndi1.setEnabled(true);
                        this.jbuttonCurrentIndi2.setEnabled(true);
                        this.setIndividu1(husb);
                        this.setIndividu2(wife);
                        return;
                    }
                    this.currentIndi = wife;
                }
                break block8;
            }
            if (entity instanceof Indi) {
                this.currentIndi = (Indi)entity;
            }
        }
        if (this.currentIndi != null) {
            this.jbuttonCurrentIndi1.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"SamePanel.selectAsFirst", (Object)this.currentIndi.getName()));
            this.jbuttonCurrentIndi2.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"SamePanel.selectAsSecond", (Object)this.currentIndi.getName()));
            this.jbuttonCurrentIndi1.setEnabled(true);
            this.jbuttonCurrentIndi2.setEnabled(true);
            return;
        }
        this.jbuttonCurrentIndi1.setToolTipText(null);
        this.jbuttonCurrentIndi2.setToolTipText(null);
        this.jbuttonCurrentIndi1.setEnabled(false);
        this.jbuttonCurrentIndi2.setEnabled(false);
    }

    private void saveFile() {
        if (this.ancestorListModel.size() > 0) {
            FamilyAncestor ancestor = this.ancestorListModel.getElementAt(this.jListAncestors.getSelectedIndex());
            int husband_or_wife_first = this.jComboBoxHusbandOrWife.getSelectedIndex();
            int degreelaw = this.jComboBoxDegreeLaw.getSelectedIndex();
            String fileTypeName = (String)this.jComboBoxFileType.getModel().getSelectedItem();
            String extension = this.commonAncestorTree.getOutputList().get(fileTypeName).getFileExtension();
            boolean displayRecentYears = this.jCheckBoxRecentEvent.isSelected();
            boolean displayId = this.jCheckBoxDisplayedId.isSelected();
            String defaultFileName = "Ancetre commun - " + this.individu1.getFirstName() + " " + this.individu1.getLastName() + " - " + this.individu2.getFirstName() + " " + this.individu2.getLastName();
            File outpuFile = this.getFileFromUser(NbBundle.getMessage(this.getClass(), (String)"TITL_CommonAncestorsResult"), AbstractAncestrisAction.TXT_OK, defaultFileName, true, extension);
            if (outpuFile != null) {
                String suffix = "." + extension;
                if (!outpuFile.getPath().endsWith(suffix)) {
                    outpuFile = new File(outpuFile.getPath() + suffix);
                }
                this.commonAncestorTree.createCommonTree(this.individu1, this.individu2, ancestor.fam, outpuFile, displayId, displayRecentYears, husband_or_wife_first, degreelaw, fileTypeName);
            }
            this.registry.put(DEFAULT_FILE_TYPE_NAME, fileTypeName);
        }
    }

    public void setIndividu1(Indi indi) {
        this.jLabelValueIndividu1.setText(indi.toString());
        this.individu1 = indi;
        this.findCommonAncestors();
        if (this.individu1 != null) {
            this.context.getGedcom().getRegistry().put("SamePanel.individu1", this.individu1.getId());
        }
        if (this.jCheckBoxAutoPreview.isSelected()) {
            this.togglePreview(true);
        }
    }

    public void setIndividu2(Indi indi) {
        this.jLabelValueIndividu2.setText(indi.toString());
        this.individu2 = indi;
        this.findCommonAncestors();
        if (this.individu2 != null) {
            this.context.getGedcom().getRegistry().put("SamePanel.individu2", this.individu2.getId());
        }
        if (this.jCheckBoxAutoPreview.isSelected()) {
            this.togglePreview(true);
        }
    }

    private void findCommonAncestors() {
        Utilities.setCursorWaiting((JPanel)this);
        this.ancestorListModel.clear();
        this.jLabelAncestorList.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelAncestorList.text", (Object)NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelAncestorList.searching")));
        Set<Fam> ancestorList = this.commonAncestorTree.findCommonAncestors(this.individu1, this.individu2);
        for (Fam ancestor : ancestorList) {
            String relationshipDegree = this.commonAncestorTree.getRelationshipDegree(this.individu1, this.individu2, ancestor, this.jComboBoxDegreeLaw.getSelectedIndex());
            this.ancestorListModel.addElement(new FamilyAncestor(ancestor, relationshipDegree, this.commonAncestorTree.getTotalDegree()));
        }
        this.sortAncestorList();
        if (this.ancestorListModel.size() > 0) {
            int cellHeight = this.jListAncestors.getCellBounds((int)0, (int)(this.ancestorListModel.getSize() - 1)).height;
            this.jListAncestors.setPreferredSize(new Dimension(this.jListAncestors.getPreferredSize().width, cellHeight));
        } else {
            this.jListAncestors.setPreferredSize(new Dimension(this.jListAncestors.getPreferredSize().width, 0));
        }
        if (this.ancestorListModel.size() > 0) {
            this.jListAncestors.setSelectedIndex(0);
            this.jButtonSaveFile.setEnabled(true);
        } else {
            this.jButtonSaveFile.setEnabled(false);
        }
        this.jLabelAncestorList.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelAncestorList.text", (Object)(" (" + ancestorList.size() + ")")));
        Utilities.setCursorNormal((JPanel)this);
    }

    public File getFileFromUser(String title, String buttonLabel, String defaultFileName, boolean askForOverwrite, String extension) {
        File file = new FileChooserBuilder(SamePanel.class.getCanonicalName()).setFilesOnly(true).setDefaultBadgeProvider().setTitle(title).setApproveText(buttonLabel).setDefaultExtension(extension).setFileFilter((FileFilter)(extension != null ? new FileExtensionFilter(extension) : null)).setSelectedFile(new File(defaultFileName)).setFileHiding(true).showSaveDialog();
        return file;
    }

    @Override
    public void ancestorAdded(AncestorEvent ae) {
        if (this.previewTopComponent != null) {
            Mode dockModeTemp = WindowManager.getDefault().findMode((TopComponent)this.previewTopComponent);
            if (dockModeTemp == null || dockModeTemp.getName().startsWith("anonymous")) {
                this.jCheckBoxSeparatedWindow.setSelected(true);
            } else {
                this.jCheckBoxSeparatedWindow.setSelected(false);
            }
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ae) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ae) {
    }

    private void sortAncestorList() {
        this.isSortBusy = true;
        ArrayList<FamilyAncestor> sortedAncestorList = new ArrayList<FamilyAncestor>();
        for (Object o : this.ancestorListModel.toArray()) {
            sortedAncestorList.add((FamilyAncestor)o);
        }
        if (this.sortDegreeToggleButton.isSelected()) {
            Collections.sort(sortedAncestorList);
        }
        if (this.sortNameToggleButton.isSelected()) {
            Collections.sort(sortedAncestorList, (o1, o2) -> {
                FamilyAncestor ancestor1 = (FamilyAncestor)o1;
                FamilyAncestor ancestor2 = (FamilyAncestor)o2;
                return ancestor1.fam.getDisplayComparator().compare((Object)ancestor1.fam, (Object)ancestor2.fam);
            });
        }
        this.ancestorListModel.clear();
        for (FamilyAncestor ancestor : sortedAncestorList) {
            this.ancestorListModel.addElement(ancestor);
        }
        this.isSortBusy = false;
    }

    private void exportAncestorList() {
        String title = NbBundle.getMessage(SamePanel.class, (String)"SamePanel.export.title");
        File file = new FileChooserBuilder(SamePanel.class).setTitle(title).setApproveText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.export.approve")).setFileHiding(true).setParent((Component)this).setFileFilter((FileFilter)new FileNameExtensionFilter(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.export.extension"), "csv")).setSelectedFile(new File(this.individu1.getLastName() + "+" + this.individu2.getLastName() + ".csv")).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setDefaultBadgeProvider().setDefaultWorkingDirectory(new File(System.getProperty("user.home"))).showSaveDialog(true);
        if (file == null) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write("\"" + NbBundle.getMessage(SamePanel.class, (String)"SamePanel.export.sortdegree") + "\";");
            writer.write("\"" + NbBundle.getMessage(SamePanel.class, (String)"SamePanel.export.degree") + "\";");
            writer.write("\"" + NbBundle.getMessage(SamePanel.class, (String)"SamePanel.export.family") + "\";");
            writer.write("\n");
            for (int r = 0; r < this.ancestorListModel.getSize(); ++r) {
                FamilyAncestor ancestor = this.ancestorListModel.get(r);
                writer.write("\"");
                writer.write(String.valueOf(ancestor.degree));
                writer.write("\";\"");
                writer.write(ancestor.relationshipDegree);
                writer.write("\";\"");
                writer.write(ancestor.fam.getDisplayTitle(true));
                writer.write("\"\n");
            }
        }
        catch (IOException e) {
            DialogManager.createError((String)title, (String)NbBundle.getMessage(SamePanel.class, (String)"SamePanel.export.error", (Object)file.getAbsolutePath())).show();
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jButtonHelp = new JButton();
        this.jLabelIndividu1 = new JLabel();
        this.jLabelValueIndividu1 = new JLabel();
        this.jPanelSearch1 = new JPanel();
        this.jbuttonCurrentIndi1 = new JButton();
        this.jLabelIndividu2 = new JLabel();
        this.jLabelValueIndividu2 = new JLabel();
        this.jbuttonCurrentIndi2 = new JButton();
        this.jPanelSearch2 = new JPanel();
        this.jLabelAncestorList = new JLabel();
        this.jScrollPaneAncestortList = new JScrollPane();
        this.jListAncestors = new JList();
        this.sortDegreeToggleButton = new JToggleButton();
        this.sortNameToggleButton = new JToggleButton();
        this.exportButton = new JButton();
        this.jPanelExportFile = new JPanel();
        this.jComboBoxFileType = new JComboBox();
        this.jButtonSaveFile = new JButton();
        this.jPanelOption = new JPanel();
        this.jCheckBoxAutoPreview = new JCheckBox();
        this.jCheckBoxSeparatedWindow = new JCheckBox();
        this.jCheckBoxDisplayedId = new JCheckBox();
        this.jCheckBoxRecentEvent = new JCheckBox();
        this.jComboBoxHusbandOrWife = new JComboBox();
        this.jComboBoxDegreeLaw = new JComboBox();
        this.jShowToggleButton = new JToggleButton();
        this.setPreferredSize(new Dimension(250, 630));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jPanel3.border.title")));
        this.jPanel3.setPreferredSize(new Dimension(232, 323));
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/commonAncestor/information.png")));
        this.jButtonHelp.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jButtonHelp.text"));
        this.jButtonHelp.setToolTipText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jButtonHelp.toolTipText"));
        this.jButtonHelp.setBorderPainted(false);
        this.jButtonHelp.setPreferredSize(new Dimension(26, 24));
        this.jButtonHelp.setRequestFocusEnabled(false);
        this.jButtonHelp.setRolloverEnabled(false);
        this.jButtonHelp.setVerifyInputWhenFocusTarget(false);
        this.jButtonHelp.setVerticalAlignment(1);
        this.jButtonHelp.setVerticalTextPosition(1);
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelIndividu1.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelIndividu1.text"));
        this.jLabelIndividu1.setFocusable(false);
        this.jLabelIndividu1.setRequestFocusEnabled(false);
        this.jLabelIndividu1.setVerifyInputWhenFocusTarget(false);
        this.jLabelValueIndividu1.setFont(this.jLabelValueIndividu1.getFont().deriveFont(this.jLabelValueIndividu1.getFont().getStyle() | 1));
        this.jLabelValueIndividu1.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelValueIndividu1.text"));
        this.jPanelSearch1.setBackground(new Color(255, 255, 255));
        this.jPanelSearch1.setPreferredSize(new Dimension(50, 20));
        GroupLayout jPanelSearch1Layout = new GroupLayout(this.jPanelSearch1);
        this.jPanelSearch1.setLayout(jPanelSearch1Layout);
        jPanelSearch1Layout.setHorizontalGroup(jPanelSearch1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelSearch1Layout.setVerticalGroup(jPanelSearch1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.jbuttonCurrentIndi1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/commonAncestor/CurrentIndi.png")));
        this.jbuttonCurrentIndi1.setBorder(null);
        this.jbuttonCurrentIndi1.setBorderPainted(false);
        this.jbuttonCurrentIndi1.setPreferredSize(new Dimension(24, 24));
        this.jbuttonCurrentIndi1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jbuttonCurrentIndi1ActionPerformed(evt);
            }
        });
        this.jLabelIndividu2.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelIndividu2.text"));
        this.jLabelIndividu2.setMaximumSize(new Dimension(42, 14));
        this.jLabelIndividu2.setMinimumSize(new Dimension(42, 14));
        this.jLabelIndividu2.setPreferredSize(new Dimension(42, 14));
        this.jLabelIndividu2.setRequestFocusEnabled(false);
        this.jLabelIndividu2.setVerifyInputWhenFocusTarget(false);
        this.jLabelValueIndividu2.setFont(this.jLabelValueIndividu2.getFont().deriveFont(this.jLabelValueIndividu2.getFont().getStyle() | 1));
        this.jLabelValueIndividu2.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelValueIndividu2.text"));
        this.jbuttonCurrentIndi2.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/commonAncestor/CurrentIndi.png")));
        this.jbuttonCurrentIndi2.setBorder(null);
        this.jbuttonCurrentIndi2.setBorderPainted(false);
        this.jbuttonCurrentIndi2.setPreferredSize(new Dimension(24, 24));
        this.jbuttonCurrentIndi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jbuttonCurrentIndi2ActionPerformed(evt);
            }
        });
        this.jPanelSearch2.setBackground(new Color(255, 255, 255));
        this.jPanelSearch2.setMinimumSize(new Dimension(50, 20));
        this.jPanelSearch2.setPreferredSize(new Dimension(50, 20));
        GroupLayout jPanelSearch2Layout = new GroupLayout(this.jPanelSearch2);
        this.jPanelSearch2.setLayout(jPanelSearch2Layout);
        jPanelSearch2Layout.setHorizontalGroup(jPanelSearch2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelSearch2Layout.setVerticalGroup(jPanelSearch2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.jLabelAncestorList.setFont(this.jLabelAncestorList.getFont().deriveFont(this.jLabelAncestorList.getFont().getStyle() | 1));
        this.jLabelAncestorList.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jLabelAncestorList.text"));
        this.jScrollPaneAncestortList.setMinimumSize(new Dimension(100, 82));
        this.jScrollPaneAncestortList.setPreferredSize(new Dimension(100, 84));
        this.jListAncestors.setSelectionMode(0);
        this.jListAncestors.setPreferredSize(new Dimension(80, 80));
        this.jListAncestors.setVisibleRowCount(5);
        this.jListAncestors.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SamePanel.this.jListAncestorsValueChanged(evt);
            }
        });
        this.jScrollPaneAncestortList.setViewportView(this.jListAncestors);
        this.sortDegreeToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/commonAncestor/sortDegree.png")));
        this.sortDegreeToggleButton.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.sortDegreeToggleButton.text"));
        this.sortDegreeToggleButton.setToolTipText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.sortDegreeToggleButton.toolTipText"));
        this.sortDegreeToggleButton.setPreferredSize(new Dimension(26, 24));
        this.sortDegreeToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.sortDegreeToggleButtonActionPerformed(evt);
            }
        });
        this.sortNameToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/commonAncestor/sortName.png")));
        this.sortNameToggleButton.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.sortNameToggleButton.text"));
        this.sortNameToggleButton.setToolTipText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.sortNameToggleButton.toolTipText"));
        this.sortNameToggleButton.setPreferredSize(new Dimension(26, 24));
        this.sortNameToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.sortNameToggleButtonActionPerformed(evt);
            }
        });
        this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/commonAncestor/download.png")));
        this.exportButton.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.exportButton.text"));
        this.exportButton.setToolTipText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.exportButton.toolTipText"));
        this.exportButton.setPreferredSize(new Dimension(26, 24));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.exportButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelIndividu1, -2, 56, -2).addComponent(this.jLabelIndividu2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -2, -1, -2)).addComponent(this.jScrollPaneAncestortList, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelAncestorList).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.sortDegreeToggleButton, -2, -1, -2).addGap(2, 2, 2).addComponent(this.sortNameToggleButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportButton, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jbuttonCurrentIndi2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSearch2, -1, 178, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jbuttonCurrentIndi1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSearch1, -1, 178, Short.MAX_VALUE)).addComponent(this.jLabelValueIndividu1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelValueIndividu2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelIndividu1)).addComponent(this.jButtonHelp, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelValueIndividu1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelSearch1, -2, -1, -2).addComponent(this.jbuttonCurrentIndi1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabelIndividu2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelValueIndividu2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelSearch2, -2, -1, -2).addComponent(this.jbuttonCurrentIndi2, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelAncestorList, GroupLayout.Alignment.TRAILING).addComponent(this.sortDegreeToggleButton, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.sortNameToggleButton, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.exportButton, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneAncestortList, -1, 87, Short.MAX_VALUE).addContainerGap()));
        this.jLabelIndividu1.getAccessibleContext().setAccessibleName("null");
        this.jLabelIndividu2.getAccessibleContext().setAccessibleName("");
        this.jPanelExportFile.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jPanelExportFile.border.title")));
        this.jPanelExportFile.setPreferredSize(new Dimension(110, 107));
        this.jComboBoxFileType.setMaximumRowCount(3);
        this.jComboBoxFileType.setModel(new DefaultComboBoxModel<String>(new String[]{"PDF", "PNG", "SVG"}));
        this.jComboBoxFileType.setMinimumSize(new Dimension(50, 18));
        this.jComboBoxFileType.setName("jComboBoxFileType");
        this.jComboBoxFileType.setPreferredSize(new Dimension(30, 24));
        this.jButtonSaveFile.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jButtonSaveFile.text"));
        this.jButtonSaveFile.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSaveFile.setMaximumSize(null);
        this.jButtonSaveFile.setMinimumSize(new Dimension(70, 28));
        this.jButtonSaveFile.setPreferredSize(new Dimension(60, 28));
        this.jButtonSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jButtonSaveFileActionPerformed(evt);
            }
        });
        GroupLayout jPanelExportFileLayout = new GroupLayout(this.jPanelExportFile);
        this.jPanelExportFile.setLayout(jPanelExportFileLayout);
        jPanelExportFileLayout.setHorizontalGroup(jPanelExportFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExportFileLayout.createSequentialGroup().addContainerGap().addGroup(jPanelExportFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxFileType, 0, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveFile, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelExportFileLayout.setVerticalGroup(jPanelExportFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExportFileLayout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxFileType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveFile, -2, -1, -2).addContainerGap(21, Short.MAX_VALUE)));
        this.jButtonSaveFile.getAccessibleContext().setAccessibleName("");
        this.jPanelOption.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jPanelOption.border.title")));
        this.jCheckBoxAutoPreview.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jButtonPreview.text"));
        this.jCheckBoxAutoPreview.setPreferredSize(new Dimension(50, 20));
        this.jCheckBoxAutoPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jCheckBoxAutoPreviewActionPerformed(evt);
            }
        });
        this.jCheckBoxSeparatedWindow.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jCheckBoxSeparatedWindow.text"));
        this.jCheckBoxSeparatedWindow.setInheritsPopupMenu(true);
        this.jCheckBoxSeparatedWindow.setPreferredSize(new Dimension(125, 20));
        this.jCheckBoxSeparatedWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jCheckBoxSeparatedWindowActionPerformed(evt);
            }
        });
        this.jCheckBoxDisplayedId.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jCheckBoxDisplayedId.text"));
        this.jCheckBoxDisplayedId.setPreferredSize(new Dimension(70, 20));
        this.jCheckBoxDisplayedId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jCheckBoxDisplayedIdActionPerformed(evt);
            }
        });
        this.jCheckBoxRecentEvent.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jCheckBoxRecentEvent.text"));
        this.jCheckBoxRecentEvent.setPreferredSize(new Dimension(70, 20));
        this.jCheckBoxRecentEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jCheckBoxRecentEventActionPerformed(evt);
            }
        });
        this.jComboBoxHusbandOrWife.setMaximumRowCount(2);
        this.jComboBoxHusbandOrWife.setToolTipText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jComboBoxHusbandOrWife.toolTipText"));
        this.jComboBoxHusbandOrWife.setPreferredSize(new Dimension(70, 24));
        this.jComboBoxHusbandOrWife.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SamePanel.this.jComboBoxHusbandOrWifeItemStateChanged(evt);
            }
        });
        this.jComboBoxDegreeLaw.setMaximumRowCount(2);
        this.jComboBoxDegreeLaw.setToolTipText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jComboBoxDegreeLaw.toolTipText"));
        this.jComboBoxDegreeLaw.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SamePanel.this.jComboBoxDegreeLawItemStateChanged(evt);
            }
        });
        this.jShowToggleButton.setText(NbBundle.getMessage(SamePanel.class, (String)"SamePanel.jShowToggleButton.text"));
        this.jShowToggleButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SamePanel.this.jShowToggleButtonStateChanged(evt);
            }
        });
        this.jShowToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SamePanel.this.jShowToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanelOptionLayout = new GroupLayout(this.jPanelOption);
        this.jPanelOption.setLayout(jPanelOptionLayout);
        jPanelOptionLayout.setHorizontalGroup(jPanelOptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSeparatedWindow, -1, 202, Short.MAX_VALUE).addComponent(this.jCheckBoxDisplayedId, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxRecentEvent, -1, -1, Short.MAX_VALUE).addGroup(jPanelOptionLayout.createSequentialGroup().addComponent(this.jCheckBoxAutoPreview, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowToggleButton)).addGroup(jPanelOptionLayout.createSequentialGroup().addComponent(this.jComboBoxHusbandOrWife, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDegreeLaw, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanelOptionLayout.setVerticalGroup(jPanelOptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxAutoPreview, -2, -1, -2).addComponent(this.jShowToggleButton)).addGap(3, 3, 3).addComponent(this.jCheckBoxSeparatedWindow, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDisplayedId, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxRecentEvent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelOptionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxHusbandOrWife, -2, 25, -2).addComponent(this.jComboBoxDegreeLaw, -2, -1, -2)).addContainerGap()));
        this.jCheckBoxAutoPreview.getAccessibleContext().setAccessibleName("null");
        this.jCheckBoxSeparatedWindow.getAccessibleContext().setAccessibleName("");
        this.jCheckBoxDisplayedId.getAccessibleContext().setAccessibleName("");
        this.jCheckBoxRecentEvent.getAccessibleContext().setAccessibleName("");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelOption, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelExportFile, -1, 226, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 226, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelOption, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelExportFile, -2, 112, -2)));
        this.jPanelExportFile.getAccessibleContext().setAccessibleName("");
    }

    private void jButtonSaveFileActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private void jCheckBoxAutoPreviewActionPerformed(ActionEvent evt) {
        this.registry.put(AUTOPREVIEW, Boolean.valueOf(this.jCheckBoxAutoPreview.isSelected()));
        if (this.jCheckBoxAutoPreview.isSelected() && this.jShowToggleButton.isSelected()) {
            this.openPreview();
        }
    }

    private void jCheckBoxDisplayedIdActionPerformed(ActionEvent evt) {
        this.registry.put(DISPLAY_ID, Boolean.valueOf(this.jCheckBoxDisplayedId.isSelected()));
        if (this.jCheckBoxAutoPreview.isSelected()) {
            this.togglePreview(true);
        }
    }

    private void jCheckBoxRecentEventActionPerformed(ActionEvent evt) {
        this.registry.put(PRIVINFO, Boolean.valueOf(this.jCheckBoxRecentEvent.isSelected()));
        if (this.jCheckBoxAutoPreview.isSelected()) {
            this.togglePreview(true);
        }
    }

    private void jComboBoxHusbandOrWifeItemStateChanged(ItemEvent evt) {
        this.registry.put(HUSBWIFE, this.jComboBoxHusbandOrWife.getSelectedIndex());
        if (this.jCheckBoxAutoPreview.isSelected()) {
            this.togglePreview(true);
        }
    }

    private void jCheckBoxSeparatedWindowActionPerformed(ActionEvent evt) {
        this.registry.put(SEPARATED_WINDOW, Boolean.valueOf(this.jCheckBoxSeparatedWindow.isSelected()));
        if (this.previewTopComponent != null && this.jCheckBoxAutoPreview.isSelected()) {
            this.previewTopComponent.setSeparatedWindowFlag(this.jCheckBoxSeparatedWindow.isSelected());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        String id = NbBundle.getMessage(SamePanel.class, (String)"SamePanel.helpPage");
        try {
            FileAssociation.getDefault().execute(new URL(id));
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.FINE, "Unable to open URL", ex);
        }
    }

    private void jListAncestorsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            boolean validList = this.jListAncestors.getSelectedIndex() != -1;
            this.jShowToggleButton.setEnabled(validList);
            if (validList && this.jCheckBoxAutoPreview.isSelected()) {
                this.togglePreview(true);
            }
        }
    }

    private void jbuttonCurrentIndi2ActionPerformed(ActionEvent evt) {
        this.setIndividu2(this.currentIndi);
    }

    private void jbuttonCurrentIndi1ActionPerformed(ActionEvent evt) {
        this.setIndividu1(this.currentIndi);
    }

    private void jShowToggleButtonActionPerformed(ActionEvent evt) {
        if (this.jShowToggleButton.isSelected()) {
            this.openPreview();
        } else {
            this.closePreview();
        }
    }

    private void jShowToggleButtonStateChanged(ChangeEvent evt) {
        if (this.jShowToggleButton.isSelected()) {
            this.jShowToggleButton.setText(NbBundle.getMessage(this.getClass(), (String)"SamePanel.jShowToggleButton.textalt"));
        } else {
            this.jShowToggleButton.setText(NbBundle.getMessage(this.getClass(), (String)"SamePanel.jShowToggleButton.text"));
        }
    }

    private void jComboBoxDegreeLawItemStateChanged(ItemEvent evt) {
        this.registry.put(DEGREELAW, this.jComboBoxDegreeLaw.getSelectedIndex());
        if (this.jCheckBoxAutoPreview.isSelected()) {
            this.togglePreview(true);
        }
        this.findCommonAncestors();
    }

    private void sortDegreeToggleButtonActionPerformed(ActionEvent evt) {
        this.sortNameToggleButton.setSelected(!this.sortDegreeToggleButton.isSelected());
        if (!this.isSortBusy) {
            this.sortAncestorList();
        }
        this.registry.put(LISTSORT, Boolean.valueOf(this.sortDegreeToggleButton.isSelected()));
    }

    private void sortNameToggleButtonActionPerformed(ActionEvent evt) {
        this.sortDegreeToggleButton.setSelected(!this.sortNameToggleButton.isSelected());
        if (!this.isSortBusy) {
            this.sortAncestorList();
        }
        this.registry.put(LISTSORT, Boolean.valueOf(this.sortDegreeToggleButton.isSelected()));
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        this.exportAncestorList();
    }

    private class FileExtensionFilter
    extends FileFilter {
        private final String extension;

        public FileExtensionFilter(String extension) {
            this.extension = extension.toLowerCase();
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith("." + this.extension);
        }

        @Override
        public String getDescription() {
            return this.extension.toUpperCase() + " files";
        }
    }
}

