/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.pluginservice;

import ancestris.core.pluginservice.PluginInterface;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

public abstract class AncestrisPlugin
implements PluginInterface {
    private static final InstanceContent ic = new InstanceContent();
    private static final AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)ic);
    private final ModuleInfo info = Modules.getDefault().ownerOf(this.getClass());

    public static void register(Object o) {
        ic.add(o);
    }

    public static void unregister(Object o) {
        ic.remove(o);
    }

    public static <T> Collection<? extends T> lookupAll(Class<T> clazz) {
        return abstractLookup.lookupAll(clazz);
    }

    public static <T> T lookup(Class<T> clazz) {
        return (T)abstractLookup.lookup(clazz);
    }

    public static <T> Class<T> lookupForName(Class<T> clazz, String name) {
        for (Object sInterface : Lookup.getDefault().lookupAll(clazz)) {
            if (!sInterface.getClass().getCanonicalName().equals(name)) continue;
            return sInterface.getClass();
        }
        return null;
    }

    public static <T> Collection<Class<T>> lookupForName(Class<T> clazz, String[] names) {
        ArrayList<Class<T>> openedViews = new ArrayList<Class<T>>();
        if (names != null) {
            List<String> namesList = Arrays.asList(names);
            for (Object sInterface : Lookup.getDefault().lookupAll(clazz)) {
                if (!namesList.contains(sInterface.getClass().getCanonicalName())) continue;
                openedViews.add(sInterface.getClass());
            }
        }
        return openedViews;
    }

    @Override
    public String getPluginName() {
        return this.info.getCodeNameBase();
    }

    @Override
    public String getPluginDisplayName() {
        return this.info.getDisplayName();
    }

    @Override
    public String getPluginVersion() {
        return this.info.getSpecificationVersion().toString();
    }

    @Override
    public String getPluginShortDescription() {
        return this.info.getLocalizedAttribute("OpenIDE-Module-Short-Description").toString();
    }

    @Override
    public String getPluginDescription() {
        return this.info.getLocalizedAttribute("OpenIDE-Module-Long-Description").toString();
    }

    @Override
    public boolean launchModule(Object o) {
        return true;
    }

    @Override
    public Collection<Class<? extends TopComponent>> getDefaultOpenedViews() {
        return new ArrayList<Class<? extends TopComponent>>();
    }

    @Override
    public int compareTo(PluginInterface o) {
        if (o == null) {
            return 1;
        }
        return this.safeCompare(this.getPluginDisplayName(), o.getPluginDisplayName());
    }

    private int safeCompare(String s1, String s2) {
        Collator coll = Collator.getInstance(Locale.getDefault());
        coll.setStrength(0);
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        return s2 == null ? 1 : coll.compare(s1, s2);
    }
}

