/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.core.TextOptions;
import ancestris.util.TimingUtility;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySex;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.io.InputSource;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;

public class Indi
extends Entity {
    private static final TagPath PATH_INDI = new TagPath("INDI");
    private static final TagPath PATH_INDIFAMS = new TagPath("INDI:FAMS");
    private static final TagPath PATH_INDIFAMC = new TagPath("INDI:FAMC");
    private static final TagPath PATH_INDIBIRTDATE = new TagPath("INDI:BIRT:DATE");
    private static final TagPath PATH_INDIDEATDATE = new TagPath("INDI:DEAT:DATE");
    private static final TagPath PATH_INDIBIRTPLACE = new TagPath("INDI:BIRT:PLAC");
    private static final TagPath PATH_INDIDEATPLACE = new TagPath("INDI:DEAT:PLAC");
    private static final TagPath PATH_INDIDEAT = new TagPath("INDI:DEAT");
    public static final ImageIcon IMG_MALE = Grammar.V55.getMeta(PATH_INDI).getImage("male");
    public static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(PATH_INDI).getImage("female");
    public static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(PATH_INDI).getImage();
    public static String TAG_SOSADABOVILLE = "_SOSADABOVILLE";
    public static String TAG_SOSA = "_SOSA";
    public static String TAG_DABOVILLE = "_DABOVILLE";
    private boolean nouveau = false;

    public Indi() {
        super("INDI", "?");
    }

    public Indi(String tag, String id) {
        super(tag, id);
        this.assertTag("INDI");
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty();
    }

    @Override
    public void setNew() {
        this.nouveau = true;
    }

    @Override
    public void setOld() {
        this.nouveau = false;
    }

    public boolean isNew() {
        return this.nouveau;
    }

    @Override
    public void moveEntityValue() {
        if (!this.getValue().isEmpty()) {
            try {
                this.addProperty("NAME", this.getValue(), 0);
                this.setValue("");
            }
            catch (GedcomException ex) {
                super.moveEntityValue();
            }
        }
    }

    public PropertyDate getBirthDate() {
        return this.getBirthDate(false);
    }

    public PropertyDate getBirthDate(boolean create) {
        PropertyDate date = (PropertyDate)this.getProperty(PATH_INDIBIRTDATE);
        if (null != date || !create) {
            return date;
        }
        return (PropertyDate)this.setValue(PATH_INDIBIRTDATE, "");
    }

    public PropertyDate getBirthDateOption() {
        PropertyDate birth = this.getBirthDate(false);
        if (birth == null && TextOptions.getInstance().isUseChr()) {
            birth = (PropertyDate)this.getProperty(new TagPath("INDI:CHR:DATE"));
        }
        return birth;
    }

    public PropertyPlace getBirthPlace() {
        return (PropertyPlace)this.getProperty(PATH_INDIBIRTPLACE);
    }

    public PropertyPlace getBirthPlaceOption() {
        PropertyPlace birth = (PropertyPlace)this.getProperty(PATH_INDIBIRTPLACE);
        if (birth == null && TextOptions.getInstance().isUseChr()) {
            birth = (PropertyPlace)this.getProperty(new TagPath("INDI:CHR:PLAC"));
        }
        return birth;
    }

    public PropertyDate getDeathDate() {
        return this.getDeathDate(false);
    }

    public PropertyDate getDeathDate(boolean create) {
        PropertyDate date = (PropertyDate)this.getProperty(PATH_INDIDEATDATE);
        if (null != date || !create) {
            return date;
        }
        return (PropertyDate)this.setValue(PATH_INDIDEATDATE, "");
    }

    public PropertyDate getDeathDateOption() {
        PropertyDate death = this.getDeathDate(false);
        if (death == null && TextOptions.getInstance().isUseBuri()) {
            death = (PropertyDate)this.getProperty(new TagPath("INDI:BURI:DATE"));
        }
        return death;
    }

    public PropertyPlace getDeathPlace() {
        return (PropertyPlace)this.getProperty(PATH_INDIDEATPLACE);
    }

    public PropertyPlace getDeathPlaceOption() {
        PropertyPlace death = (PropertyPlace)this.getProperty(PATH_INDIDEATPLACE);
        if (death == null && TextOptions.getInstance().isUseBuri()) {
            death = (PropertyPlace)this.getProperty(new TagPath("INDI:BURI:PLAC"));
        }
        return death;
    }

    public Indi[] getBrothers(boolean includeUnknown) {
        return this.getSiblings(1, includeUnknown);
    }

    public Indi[] getSisters(boolean includeUnknown) {
        return this.getSiblings(2, includeUnknown);
    }

    private Indi[] getSiblings(int sex, boolean includeUnknown) {
        ArrayList<Indi> l = new ArrayList<Indi>();
        for (Indi i : this.getSiblings(false)) {
            int s = i.getSex();
            if (s != sex && (!includeUnknown || s != 0)) continue;
            l.add(i);
        }
        Indi[] result = new Indi[l.size()];
        l.toArray(result);
        return result;
    }

    public Indi[] getSiblings(boolean includeMe) {
        Indi[] siblings;
        Fam fam = this.getFamilyWhereBiologicalChild();
        if (fam == null) {
            return new Indi[0];
        }
        ArrayList<Indi> result = new ArrayList<Indi>(fam.getNoOfChildren());
        for (Indi sibling : siblings = fam.getChildren()) {
            if (!includeMe && sibling == this) continue;
            result.add(sibling);
        }
        return Indi.toIndiArray(result);
    }

    public Indi[] getYoungerSiblings() {
        Indi[] siblings = this.getSiblings(true);
        Arrays.sort(siblings, new PropertyComparator("INDI:BIRT:DATE"));
        ArrayList<Indi> result = new ArrayList<Indi>(siblings.length);
        for (int i = siblings.length - 1; i >= 0 && siblings[i] != this; --i) {
            result.add(0, siblings[i]);
        }
        return Indi.toIndiArray(result);
    }

    public PropertyMultilineValue getAddress() {
        Property[] rs;
        for (Property r : rs = this.getProperties("RESI", false)) {
            PropertyDate date;
            PropertyMultilineValue address = (PropertyMultilineValue)r.getProperty("ADDR");
            if (address == null || (date = (PropertyDate)r.getProperty("DATE")) != null && date.isRange()) continue;
            return address;
        }
        return null;
    }

    public Indi[] getOlderSiblings() {
        Indi[] siblings = this.getSiblings(true);
        Arrays.sort(siblings, new PropertyComparator("INDI:BIRT:DATE"));
        ArrayList<Indi> result = new ArrayList<Indi>(siblings.length);
        int j = siblings.length;
        for (int i = 0; i < j && siblings[i] != this; ++i) {
            result.add(siblings[i]);
        }
        return Indi.toIndiArray(result);
    }

    public boolean isSiblingOf(Indi indi2, boolean biological) {
        Fam[] fams = new Fam[1];
        if (biological) {
            Fam fam = this.getFamilyWhereBiologicalChild();
            if (fam == null) {
                return false;
            }
            fams[0] = fam;
        } else {
            fams = this.getFamiliesWhereChild();
        }
        for (Fam fam : fams) {
            Indi[] children;
            for (Indi child : children = fam.getChildren()) {
                if (child != indi2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isChildIn(Fam fam2) {
        for (Indi indi : fam2.getChildren()) {
            if (this != indi) continue;
            return true;
        }
        return false;
    }

    public Indi[] getPartners() {
        Fam[] fs = this.getFamiliesWhereSpouse();
        ArrayList<Indi> l = new ArrayList<Indi>(fs.length);
        for (Fam f : fs) {
            Indi p = f.getOtherSpouse(this);
            if (p == null) continue;
            l.add(p);
        }
        Indi[] result = new Indi[l.size()];
        l.toArray(result);
        return result;
    }

    public boolean isSpouseOf(Indi indi2) {
        Indi[] partners;
        for (Indi partner : partners = this.getPartners()) {
            if (partner != indi2) continue;
            return true;
        }
        return false;
    }

    public boolean isSpouseIn(Fam fam2) {
        return this == fam2.getHusband() || this == fam2.getWife();
    }

    public List<Indi> getParents() {
        ArrayList<Indi> parents = new ArrayList<Indi>(2);
        for (Fam fam : this.getFamiliesWhereChild()) {
            Indi wife;
            Indi husband = fam.getHusband();
            if (husband != null) {
                parents.add(husband);
            }
            if ((wife = fam.getWife()) == null) continue;
            parents.add(wife);
        }
        return parents;
    }

    public Indi[] getChildren() {
        Fam[] fs = this.getFamiliesWhereSpouse();
        ArrayList<Indi> l = new ArrayList<Indi>(fs.length);
        for (Fam f : fs) {
            Indi[] cs;
            for (Indi c : cs = f.getChildren()) {
                if (l.contains(c)) continue;
                l.add(c);
            }
        }
        Indi[] result = new Indi[l.size()];
        l.toArray(result);
        return result;
    }

    public Indi[] getBiologicalChildren() {
        ArrayList<Entity> retour = new ArrayList<Entity>();
        ArrayList<Fam> fs = new ArrayList<Fam>();
        for (Fam fam : this.getFamiliesWhereSpouse()) {
            fs.add(fam);
        }
        for (Entity entity : this.getChildren()) {
            Fam f = ((Indi)entity).getFamilyWhereBiologicalChild();
            if (!fs.contains(f)) continue;
            retour.add(entity);
        }
        Indi[] result = new Indi[retour.size()];
        retour.toArray(result);
        return result;
    }

    public String getBirthAsString() {
        PropertyDate p = this.getBirthDate();
        if (p == null) {
            return "";
        }
        return p.getDisplayValue();
    }

    public String getDeathAsString() {
        PropertyDate p = this.getDeathDate();
        if (p == null) {
            return "";
        }
        return p.getDisplayValue();
    }

    public Fam[] getFamiliesWhereSpouse() {
        return this.getFamiliesWhereSpouse(true);
    }

    public Fam[] getFamiliesWhereSpouse(boolean sorted) {
        ArrayList<Fam> result = new ArrayList<Fam>(this.getNoOfProperties());
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"FAMS".equals(prop.getTag()) || !prop.isValid() || !(prop instanceof PropertyFamilySpouse)) continue;
            result.add(((PropertyFamilySpouse)prop).getFamily());
        }
        Fam[] fams = Fam.toFamArray(result);
        if (fams.length > 1 && sorted) {
            return this.sortFams(fams);
        }
        return fams;
    }

    private Fam[] sortFams(Fam[] fams) {
        TagPath FAMS_SORTING_PATH = new TagPath("FAM:MARR:DATE");
        Fam[] ret = new Fam[fams.length];
        ArrayList<Fam> tmp = new ArrayList<Fam>();
        for (Fam f : fams) {
            if (f.getProperty(FAMS_SORTING_PATH) == null) continue;
            tmp.add(f);
        }
        if (tmp.size() == fams.length) {
            Arrays.sort(fams, new PropertyComparator(FAMS_SORTING_PATH));
            return fams;
        }
        Fam[] datedFams = Fam.toFamArray(tmp);
        Arrays.sort(datedFams, new PropertyComparator(FAMS_SORTING_PATH));
        int j = 0;
        for (int i = 0; i < fams.length; ++i) {
            if (tmp.contains(fams[i])) {
                ret[i] = datedFams[j];
                ++j;
                continue;
            }
            ret[i] = fams[i];
        }
        return ret;
    }

    public Fam getPreferredFamily() {
        Fam preferredFam = null;
        Fam[] fams = this.getFamiliesWhereSpouse(true);
        if (fams.length > 0) {
            preferredFam = fams[0];
            for (Fam f : fams) {
                if (!f.isPreferred()) continue;
                preferredFam = f;
                break;
            }
        }
        return preferredFam;
    }

    public Fam[] getFamiliesWhereChild() {
        List<PropertyFamilyChild> famcs = this.getProperties(PropertyFamilyChild.class);
        HashSet<Fam> result = new HashSet<Fam>(famcs.size());
        for (int i = 0; i < famcs.size(); ++i) {
            PropertyFamilyChild famc = famcs.get(i);
            if (!famc.isValid()) continue;
            result.add((Fam)famc.getTargetEntity());
        }
        return Fam.toFamArray(result);
    }

    public Fam getFamilyWhereBiologicalChild() {
        Fam result = null;
        List<PropertyFamilyChild> famcs = this.getProperties(PropertyFamilyChild.class);
        for (int i = 0; i < famcs.size(); ++i) {
            PropertyFamilyChild famc = famcs.get(i);
            if (!famc.isValid()) continue;
            Boolean biological = famc.isBiological();
            if (Boolean.TRUE.equals(biological)) {
                return (Fam)famc.getTargetEntity();
            }
            if (biological != null || result != null) continue;
            result = (Fam)famc.getTargetEntity();
        }
        return result;
    }

    public String getFirstName() {
        PropertyName p = (PropertyName)this.getProperty("NAME", false);
        return p != null ? p.getFirstName() : "";
    }

    public String[] getFirstNames() {
        Property[] ps = this.getProperties("NAME", false);
        if (ps == null) {
            return null;
        }
        String[] firstNames = new String[ps.length];
        int i = 0;
        for (Property prop : ps) {
            firstNames[i++] = ((PropertyName)prop).getFirstName();
        }
        return firstNames;
    }

    public String getLastName() {
        PropertyName p = (PropertyName)this.getProperty("NAME", false);
        return p != null ? p.getLastName() : "";
    }

    public String[] getLastNames() {
        Property[] ps = this.getProperties("NAME", false);
        if (ps == null) {
            return null;
        }
        String[] lastNames = new String[ps.length];
        int i = 0;
        for (Property prop : ps) {
            lastNames[i++] = ((PropertyName)prop).getLastName();
        }
        return lastNames;
    }

    public String[] getPartnersLastNames() {
        HashSet<String> lastNames = new HashSet<String>();
        for (Indi partner : this.getPartners()) {
            lastNames.addAll(Arrays.asList(partner.getLastNames()));
        }
        return lastNames.toArray(new String[lastNames.size()]);
    }

    public String[] getPartnersFirstNames() {
        HashSet<String> firstNames = new HashSet<String>();
        for (Indi partner : this.getPartners()) {
            firstNames.addAll(Arrays.asList(partner.getFirstNames()));
        }
        return firstNames.toArray(new String[firstNames.size()]);
    }

    public String getSurnamePrefix() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        return p != null ? p.getSurnamePrefix() : "";
    }

    public String getNameSuffix() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        return p != null ? p.getSuffix() : "";
    }

    public void setName(String first, String last) {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        if (p == null) {
            p = (PropertyName)this.addProperty(new PropertyName());
        }
        p.setName(first, last);
    }

    public void setName(String first, String sPfx, String last) {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        if (p == null) {
            p = (PropertyName)this.addProperty(new PropertyName());
        }
        p.setName("", first, sPfx, last, "");
    }

    public String getName() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        if (p == null) {
            return "";
        }
        return p.getDisplayValue();
    }

    public PropertyName getNameProperty() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        if (p == null) {
            return null;
        }
        return p;
    }

    public int getNoOfFams() {
        int result = 0;
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"FAMS".equals(prop.getTag()) || !prop.isValid()) continue;
            ++result;
        }
        return result;
    }

    public int getSex() {
        PropertySex p = (PropertySex)this.getProperty("SEX", true);
        return p != null ? p.getSex() : 0;
    }

    public void setSex(int sex) {
        PropertySex p = (PropertySex)this.getProperty("SEX", false);
        if (p != null && !p.isValid()) {
            return;
        }
        if (p == null) {
            p = (PropertySex)this.addProperty(new PropertySex());
        }
        p.setSex(sex);
    }

    public boolean isDescendantOf(Indi indi) {
        return indi.isAncestorOf(this);
    }

    public boolean isAncestorOf(Indi indi) {
        return this.recursiveIsAncestorOf(indi, new HashSet<Indi>());
    }

    private boolean recursiveIsAncestorOf(Indi indi, Set<Indi> visited) {
        if (visited.contains(indi)) {
            return false;
        }
        visited.add(indi);
        for (PropertyFamilyChild famc : indi.getProperties(PropertyFamilyChild.class)) {
            Indi mother;
            if (!famc.isValid() || Boolean.FALSE.equals(famc.isBiological())) continue;
            Fam fam = famc.getFamily();
            Indi father = fam.getHusband();
            if (father != null) {
                if (father == this) {
                    return true;
                }
                if (this.recursiveIsAncestorOf(father, visited)) {
                    return true;
                }
            }
            if ((mother = fam.getWife()) == null) continue;
            if (mother == this) {
                return true;
            }
            if (!this.recursiveIsAncestorOf(mother, visited)) continue;
            return true;
        }
        return false;
    }

    public List<List<Indi>> getAncestorLinesWith(Indi indi) {
        ArrayList<List<Indi>> lines = new ArrayList<List<Indi>>();
        TimingUtility.getInstance().reset();
        Set<Indi> descendants = this.getDescendants();
        this.recursiveLinesToAncestorFrom(indi, lines, new ArrayList<Indi>(), descendants);
        return lines;
    }

    private boolean recursiveLinesToAncestorFrom(Indi indi, List<List<Indi>> lines, List<Indi> currentLine, Set<Indi> descendants) {
        Indi mother;
        if (currentLine.contains(indi)) {
            return false;
        }
        currentLine.add(indi);
        int minLength = Integer.MAX_VALUE;
        for (List<Indi> line : lines) {
            if (line.size() >= minLength) continue;
            minLength = line.size();
        }
        if (currentLine.size() >= minLength) {
            return false;
        }
        Indi father = indi.getBiologicalFather();
        if (father != null && descendants.contains(father)) {
            ArrayList<Indi> fatherLine = new ArrayList<Indi>();
            fatherLine.addAll(currentLine);
            if (father == this) {
                fatherLine.add(father);
                lines.add(fatherLine);
                return true;
            }
            this.recursiveLinesToAncestorFrom(father, lines, fatherLine, descendants);
        }
        if ((mother = indi.getBiologicalMother()) != null && descendants.contains(mother)) {
            ArrayList<Indi> motherLine = new ArrayList<Indi>();
            motherLine.addAll(currentLine);
            if (mother == this) {
                motherLine.add(mother);
                lines.add(motherLine);
                return true;
            }
            this.recursiveLinesToAncestorFrom(mother, lines, motherLine, descendants);
        }
        return false;
    }

    private Set<Indi> getDescendants() {
        HashSet<Indi> seen = new HashSet<Indi>();
        Stack<Indi> todos = new Stack<Indi>();
        todos.add(this);
        while (!todos.isEmpty()) {
            Indi todo = (Indi)todos.pop();
            if (seen.contains(todo)) continue;
            seen.add(todo);
            for (Indi child : todo.getChildren()) {
                if (child == null || seen.contains(child)) continue;
                todos.push(child);
            }
        }
        return seen;
    }

    public boolean isDescendantOf(Fam fam) {
        Indi[] children;
        for (Indi child : children = fam.getChildren(false)) {
            if (child != this) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Fam fam) {
        Indi wife;
        Indi husband = fam.getHusband();
        if (husband != null) {
            if (husband == this) {
                return true;
            }
            if (this.isAncestorOf(husband)) {
                return true;
            }
        }
        if ((wife = fam.getWife()) != null) {
            if (wife == this) {
                return true;
            }
            if (this.isAncestorOf(wife)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" (");
        String birth = this.getBirthAsString();
        String chr = this.getCHRAsString();
        if ("".equals(birth) && TextOptions.getInstance().isUseChr() && !"".equals(chr)) {
            sb.append(TextOptions.getInstance().getBaptismSymbol());
            birth = chr;
        } else {
            sb.append(TextOptions.getInstance().getBirthSymbol());
        }
        sb.append(birth);
        sb.append(' ');
        String death = this.getDeathAsString();
        String burial = this.getBuriAsString();
        if ("".equals(death) && TextOptions.getInstance().isUseBuri() && !"".equals(burial)) {
            sb.append(TextOptions.getInstance().getBurialSymbol());
            death = burial;
        } else {
            sb.append(TextOptions.getInstance().getDeathSymbol());
        }
        sb.append(death);
        sb.append(')');
        return sb.toString();
    }

    public String getCHRAsString() {
        PropertyDate p = (PropertyDate)this.getProperty(new TagPath("INDI:CHR:DATE"));
        if (p == null) {
            return "";
        }
        return p.getDisplayValue();
    }

    public String getBuriAsString() {
        PropertyDate p = (PropertyDate)this.getProperty(new TagPath("INDI:BURI:DATE"));
        if (p == null) {
            return "";
        }
        return p.getDisplayValue();
    }

    @Override
    public String getDisplayTitle() {
        return this.getDisplayTitle(true);
    }

    @Override
    public String getDisplayTitle(boolean showid) {
        PropertyName p = this.getNameProperty();
        String spfx = p != null && !p.getSurnamePrefix().isEmpty() ? p.getSurnamePrefix() + " " : "";
        String[] lastNames = this.getLastName().split(",");
        String[] firstNames = this.getFirstName().split(",");
        String lastname = lastNames.length > 0 ? spfx + lastNames[0] : "?";
        String firstname = firstNames.length > 0 ? firstNames[0] : "?";
        String birthDate = this.getBirthAsString();
        if ("".equals(birthDate) && TextOptions.getInstance().isUseChr() && !"".equals(this.getCHRAsString())) {
            birthDate = TextOptions.getInstance().getBaptismSymbol() + this.getCHRAsString();
        }
        return (showid ? this.getId() + " - " : "") + firstname + " " + lastname + " (" + birthDate + " - " + this.getDeathAsString() + ")";
    }

    static Indi[] toIndiArray(Collection<Indi> c) {
        return c.toArray(new Indi[c.size()]);
    }

    @Override
    public ImageIcon getImage(boolean checkValid) {
        switch (this.getSex()) {
            case 1: {
                return IMG_MALE;
            }
            case 2: {
                return IMG_FEMALE;
            }
        }
        return IMG_UNKNOWN;
    }

    public String getAgeString(PointInTime pit) {
        Delta delta = this.getAge(pit);
        return delta != null ? delta.toString() : "";
    }

    public Delta getAge(PointInTime pit) {
        return PropertyAge.getAge(this, pit);
    }

    public PointInTime getStartPITOfAge() {
        return PropertyAge.getStartPITOfAge(this);
    }

    @Override
    public List<PropertyEventDetails> getEvents() {
        ArrayList<PropertyEventDetails> eventList = new ArrayList<PropertyEventDetails>();
        this.getAllProperties(null).stream().filter(prop -> prop.isEvent()).forEachOrdered(prop -> eventList.add((PropertyEventDetails)prop));
        for (PropertyFamilySpouse fam : this.getProperties(PropertyFamilySpouse.class)) {
            Fam targetFam = fam.getFamily();
            if (targetFam == null) continue;
            targetFam.getAllProperties(null).stream().filter(prop -> prop.isEvent()).forEachOrdered(prop -> eventList.add((PropertyEventDetails)prop));
        }
        return eventList;
    }

    public Indi getBiologicalFather() {
        Fam f = this.getFamilyWhereBiologicalChild();
        return f != null ? f.getHusband() : null;
    }

    public Indi getBiologicalMother() {
        Fam f = this.getFamilyWhereBiologicalChild();
        return f != null ? f.getWife() : null;
    }

    public boolean isDeceased() {
        Delta delta;
        PropertyDate birt;
        PropertyEvent deat = (PropertyEvent)this.getProperty("DEAT");
        if (deat != null) {
            if (deat.isKnownToHaveHappened().booleanValue()) {
                return true;
            }
            Property date = deat.getProperty("DATE");
            if (date != null && date.isValid()) {
                return true;
            }
        }
        return (birt = this.getBirthDate()) != null && (delta = birt.getAnniversary()) != null && delta.getYears() > 100;
    }

    public InputSource getMediaFile() {
        Property obje = this.getProperty("OBJE");
        if (obje != null) {
            if (obje instanceof PropertyMedia) {
                PropertyMedia pm = (PropertyMedia)obje;
                Media media = (Media)pm.getTargetEntity();
                if (media != null) {
                    return media.getFile();
                }
            } else {
                Optional<InputSource> ois;
                PropertyFile file = (PropertyFile)obje.getProperty("FILE");
                if (file != null && (ois = file.getInput()).isPresent()) {
                    return ois.get();
                }
            }
        }
        return null;
    }

    public Property getSosa(boolean validOnly) {
        Property p = this.getProperty(TAG_SOSADABOVILLE, validOnly);
        if (p != null) {
            return p;
        }
        p = this.getProperty(TAG_SOSA, validOnly);
        if (p != null) {
            return p;
        }
        p = this.getProperty(TAG_DABOVILLE, validOnly);
        if (p != null) {
            return p;
        }
        return null;
    }

    public String getSosaString() {
        Property p = this.getSosa(true);
        if (p != null) {
            return p.getDisplayValue();
        }
        return "";
    }

    @Override
    public PropertyComparator2 getDisplayComparator() {
        return INDIComparator.getInstance();
    }

    private static class INDIComparator
    extends PropertyComparator2.Default<Indi> {
        private static final PropertyComparator2 INSTANCE = new INDIComparator();

        private INDIComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(Indi i1, Indi i2) {
            Property n2;
            Property n1;
            int r = this.compareNull(i1, i2);
            if (r == Integer.MAX_VALUE && (r = this.compareNull(n1 = i1.getProperty("NAME", false), n2 = i2.getProperty("NAME", false))) == Integer.MAX_VALUE) {
                r = n1.getDisplayComparator().compare(n1, n2);
            }
            return r;
        }

        @Override
        public String getSortGroup(Indi p) {
            PropertyName name = (PropertyName)p.getProperty("NAME", false);
            if (name == null) {
                return "";
            }
            return this.shortcut(name.getDisplayValue(), 1);
        }
    }
}

