/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.Structure;

public class Path
implements Structure {
    private static final Logger logger = Logger.getLogger(Path.class.getSimpleName());
    private Node root = null;
    Stack<Edge> edgePath = new Stack();
    Stack<Node> nodePath = new Stack();

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        if (this.root == null) {
            this.root = root;
            this.nodePath.push(root);
        } else {
            logger.warning("Root node is not null - first use the clear method.");
        }
    }

    public boolean contains(Node node) {
        return this.nodePath.contains(node);
    }

    public boolean contains(Edge edge) {
        return this.edgePath.contains(edge);
    }

    public boolean empty() {
        return this.nodePath.empty();
    }

    public int size() {
        return this.nodePath.size();
    }

    public Double getPathWeight(String characteristic) {
        double d = 0.0;
        for (Edge l : this.edgePath) {
            d += ((Double)l.getAttribute(characteristic, Number.class)).doubleValue();
        }
        return d;
    }

    public List<Edge> getEdgePath() {
        return this.edgePath;
    }

    public List<Node> getNodePath() {
        return this.nodePath;
    }

    public void add(Node from, Edge edge) {
        if (this.root == null) {
            if (from == null) {
                throw new IllegalArgumentException("From node cannot be null.");
            }
            this.setRoot(from);
        }
        if (from == null) {
            from = this.nodePath.peek();
        }
        if (!this.nodePath.peek().equals(from)) {
            throw new IllegalArgumentException("From node must be at the head of the path");
        }
        if (!edge.getSourceNode().equals(from) && !edge.getTargetNode().equals(from)) {
            throw new IllegalArgumentException("From node must be part of the edge");
        }
        this.nodePath.push(edge.getOpposite(from));
        this.edgePath.push(edge);
    }

    public void add(Edge edge) {
        if (this.nodePath.isEmpty()) {
            this.add(null, edge);
        } else {
            this.add(this.nodePath.peek(), edge);
        }
    }

    public void push(Node from, Edge edge) {
        this.add(from, edge);
    }

    public void push(Edge edge) {
        this.add(edge);
    }

    public Edge popEdge() {
        this.nodePath.pop();
        return this.edgePath.pop();
    }

    public Node popNode() {
        this.edgePath.pop();
        return this.nodePath.pop();
    }

    public Node peekNode() {
        return this.nodePath.peek();
    }

    public Edge peekEdge() {
        return this.edgePath.peek();
    }

    public void clear() {
        this.nodePath.clear();
        this.edgePath.clear();
        this.root = null;
    }

    public Path getACopy() {
        Path newPath = new Path();
        newPath.root = this.root;
        newPath.edgePath = (Stack)this.edgePath.clone();
        newPath.nodePath = (Stack)this.nodePath.clone();
        return newPath;
    }

    public void removeLoops() {
        int n = this.nodePath.size();
        int i = 0;
        while (i < n) {
            int j = n - 1;
            while (j > i) {
                if (this.nodePath.get(i) == this.nodePath.get(j)) {
                    int k = i + 1;
                    while (k <= j) {
                        this.nodePath.remove(i + 1);
                        this.edgePath.remove(i);
                        ++k;
                    }
                    n -= j - i;
                    j = i;
                }
                --j;
            }
            ++i;
        }
    }

    public boolean equals(Path p) {
        if (this.nodePath.size() != p.nodePath.size()) {
            return false;
        }
        int i = 0;
        while (i < this.nodePath.size()) {
            if (this.nodePath.get(i) != p.nodePath.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.nodePath.toString();
    }

    @Override
    public int getNodeCount() {
        return this.nodePath.size();
    }

    @Override
    public int getEdgeCount() {
        return this.edgePath.size();
    }

    @Override
    public Stream<Node> nodes() {
        return this.nodePath.stream();
    }

    @Override
    public Stream<Edge> edges() {
        return this.edgePath.stream();
    }

    public <T extends Node> Collection<T> getNodeSet() {
        return this.nodePath;
    }

    public <T extends Edge> Collection<T> getEdgeSet() {
        return this.edgePath;
    }
}

