// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_COCOA_NOTIFICATIONS_NOTIFICATION_BUILDER_BASE_H_
#define CHROME_BROWSER_UI_COCOA_NOTIFICATIONS_NOTIFICATION_BUILDER_BASE_H_

#import <Foundation/Foundation.h>

#include "base/mac/scoped_nsobject.h"
#include "chrome/services/mac_notifications/public/cpp/notification_constants_mac.h"

@interface NotificationBuilderBase : NSObject {
  base::scoped_nsobject<NSMutableDictionary> _notificationData;
}

// Initializes a builder with default values for the button labels.
- (instancetype)initWithCloseLabel:(NSString*)closeLabel
                      optionsLabel:(NSString*)optionsLabel
                     settingsLabel:(NSString*)settingsLabel;

// Initializes a builder by deserializing |data|. The |data| must have been
// generated by calling the buildDictionary function on another builder
// instance.
- (instancetype)initWithDictionary:(NSDictionary*)data;

// Setters
// Note for XPC users. Always use the setters from Chrome's main app. Do not
// attempt to use them from XPC since some of the default strings and other
// defaults are not available from the xpc service.
- (void)setTitle:(NSString*)title;
- (void)setSubTitle:(NSString*)subTitle;
- (void)setContextMessage:(NSString*)contextMessage;
- (void)setButtons:(NSString*)primaryButton
    secondaryButton:(NSString*)secondaryButton;
- (void)setIdentifier:(NSString*)identifier;
- (void)setOrigin:(NSString*)origin;
- (void)setNotificationId:(NSString*)notificationId;
- (void)setProfileId:(NSString*)profileId;
- (void)setIncognito:(BOOL)incognito;
- (void)setCreatorPid:(NSNumber*)pid;
- (void)setNotificationType:(NSNumber*)notificationType;
- (void)setRenotify:(BOOL)renotify;
- (void)setShowSettingsButton:(BOOL)showSettingsButton;
- (void)setIcon:(NSImage*)icon;

// Returns a representation of a notification that can be serialized.
// Another instance of NotificationBuilder can read this directly and generate
// a notification out of it via the |buildbuildUserNotification| method.
- (NSDictionary*)buildDictionary;

@end

#endif  // CHROME_BROWSER_UI_COCOA_NOTIFICATIONS_NOTIFICATION_BUILDER_BASE_H_
