/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;

public class IQReplyFilter
implements PacketFilter {
    private static final Logger LOGGER = Logger.getLogger(IQReplyFilter.class.getName());
    private final PacketFilter iqAndIdFilter;
    private final OrFilter fromFilter;
    private final String to;
    private final String local;
    private final String server;
    private final String packetId;

    public IQReplyFilter(IQ iqPacket, Connection conn) {
        if (iqPacket.getType() != IQ.Type.GET && iqPacket.getType() != IQ.Type.SET) {
            throw new IllegalArgumentException("IQ must be a request IQ, i.e. of type 'get' or 'set'.");
        }
        this.to = iqPacket.getTo();
        this.local = conn.getUser();
        if (this.local == null) {
            throw new IllegalArgumentException("Must have a local (user) JID set. Either you didn't configure one or you where not connected at least once");
        }
        this.server = conn.getServiceName().toLowerCase();
        this.packetId = iqPacket.getPacketID();
        OrFilter iqFilter = new OrFilter(new IQTypeFilter(IQ.Type.ERROR), new IQTypeFilter(IQ.Type.RESULT));
        PacketIDFilter idFilter = new PacketIDFilter(iqPacket.getPacketID());
        this.iqAndIdFilter = new AndFilter(iqFilter, idFilter);
        this.fromFilter = new OrFilter();
        this.fromFilter.addFilter(FromMatchesFilter.createFull(this.to));
        if (this.to == null) {
            this.fromFilter.addFilter(FromMatchesFilter.createBare(this.local));
            this.fromFilter.addFilter(FromMatchesFilter.createFull(this.server));
        } else if (this.to.equals(StringUtils.parseBareAddress(this.local))) {
            this.fromFilter.addFilter(FromMatchesFilter.createFull(null));
        }
    }

    @Override
    public boolean accept(Packet packet) {
        if (!this.iqAndIdFilter.accept(packet)) {
            return false;
        }
        if (this.fromFilter.accept(packet)) {
            return true;
        }
        String msg = String.format("Rejected potentially spoofed reply to IQ-packet. Filter settings: packetId=%s, to=%s, local=%s, server=%s. Received packet with from=%s", this.packetId, this.to, this.local, this.server, packet.getFrom());
        LOGGER.log(Level.WARNING, msg, packet);
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(": iqAndIdFilter (").append(this.iqAndIdFilter.toString()).append("), ");
        sb.append(": fromFilter (").append(this.fromFilter.toString()).append(')');
        return sb.toString();
    }
}

