/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.macosx;

import java.util.regex.Pattern;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactQuery;
import net.java.sip.communicator.service.contactsource.AsyncContactSourceService;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.EditableContactSourceService;
import net.java.sip.communicator.service.contactsource.PrefixedContactSourceService;

public class MacOSXAddrBookContactSourceService
extends AsyncContactSourceService
implements EditableContactSourceService,
PrefixedContactSourceService {
    public static final String MACOSX_ADDR_BOOK_PREFIX = "net.java.sip.communicator.plugin.addrbook.MACOSX_ADDR_BOOK_PREFIX";
    public static final String PNAME_MACOSX_ADDR_BOOK_SEARCH_FIELD_DISABLED = "net.java.sip.communicator.plugin.addrbook.MACOSX_ADDR_BOOK_SEARCH_FIELD_DISABLED";
    private long ptr = MacOSXAddrBookContactSourceService.start();
    private MacOSXAddrBookContactQuery latestQuery;

    public MacOSXAddrBookContactSourceService() {
        if (0L == this.ptr) {
            throw new IllegalStateException("ptr");
        }
        MacOSXAddrBookContactSourceService.setDelegate(this.ptr, new NotificationsDelegate());
    }

    public String getDisplayName() {
        return "Address Book";
    }

    public int getType() {
        return 1;
    }

    public ContactQuery createContactQuery(Pattern query) {
        if (this.latestQuery != null) {
            this.latestQuery.clear();
        }
        this.latestQuery = new MacOSXAddrBookContactQuery(this, query);
        return this.latestQuery;
    }

    private static native long start();

    public synchronized void stop() {
        if (0L != this.ptr) {
            if (this.latestQuery != null) {
                this.latestQuery.clear();
                this.latestQuery = null;
            }
            MacOSXAddrBookContactSourceService.stop(this.ptr);
            this.ptr = 0L;
        }
    }

    public String getPhoneNumberPrefix() {
        return AddrBookActivator.getConfigService().getString(MACOSX_ADDR_BOOK_PREFIX);
    }

    public int getIndex() {
        return -1;
    }

    private static native void stop(long var0);

    public static native void setDelegate(long var0, NotificationsDelegate var2);

    public MacOSXAddrBookContactQuery getLatestQuery() {
        return this.latestQuery;
    }

    public String createContact() {
        return MacOSXAddrBookContactQuery.createContact();
    }

    public void addEmptyContact(String id) {
        if (id != null && this.latestQuery != null) {
            this.latestQuery.addEmptyContact(id);
        }
    }

    public void deleteContact(String id) {
        if (id != null && MacOSXAddrBookContactQuery.deleteContact(id) && this.latestQuery != null) {
            this.latestQuery.deleted(id);
        }
    }

    public boolean canBeUsedToSearchContacts() {
        return !AddrBookActivator.getConfigService().getBoolean(PNAME_MACOSX_ADDR_BOOK_SEARCH_FIELD_DISABLED, false);
    }

    public int getBitness() {
        return -1;
    }

    public int getVersion() {
        return -1;
    }

    public int getNbRemainingNotifications() {
        return 0;
    }

    static {
        System.loadLibrary("jmacosxaddrbook");
    }

    public class NotificationsDelegate {
        public void inserted(long person) {
            if (MacOSXAddrBookContactSourceService.this.latestQuery != null) {
                MacOSXAddrBookContactSourceService.this.latestQuery.inserted(person);
            }
        }

        public void updated(long person) {
            if (MacOSXAddrBookContactSourceService.this.latestQuery != null) {
                MacOSXAddrBookContactSourceService.this.latestQuery.updated(person);
            }
        }

        public void deleted(String id) {
            if (MacOSXAddrBookContactSourceService.this.latestQuery != null) {
                MacOSXAddrBookContactSourceService.this.latestQuery.deleted(id);
            }
        }
    }
}

