/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.defaultresourcepack;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import net.java.sip.communicator.plugin.defaultresourcepack.DefaultColorPackImpl;
import net.java.sip.communicator.plugin.defaultresourcepack.DefaultImagePackImpl;
import net.java.sip.communicator.plugin.defaultresourcepack.DefaultLanguagePackImpl;
import net.java.sip.communicator.plugin.defaultresourcepack.DefaultSettingsPackImpl;
import net.java.sip.communicator.plugin.defaultresourcepack.DefaultSoundPackImpl;
import net.java.sip.communicator.service.resources.ColorPack;
import net.java.sip.communicator.service.resources.ImagePack;
import net.java.sip.communicator.service.resources.LanguagePack;
import net.java.sip.communicator.service.resources.SettingsPack;
import net.java.sip.communicator.service.resources.SoundPack;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class DefaultResourcePackActivator
implements BundleActivator {
    private Logger logger = Logger.getLogger(DefaultResourcePackActivator.class);
    static BundleContext bundleContext;
    private static Hashtable<String, Iterator<String>> ressourcesFiles;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        DefaultColorPackImpl colPackImpl = new DefaultColorPackImpl();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("ResourceName", "DefaultColorPack");
        bundleContext.registerService(ColorPack.class.getName(), (Object)colPackImpl, props);
        DefaultImagePackImpl imgPackImpl = new DefaultImagePackImpl();
        Hashtable<String, String> imgProps = new Hashtable<String, String>();
        imgProps.put("ResourceName", "DefaultImagePack");
        bundleContext.registerService(ImagePack.class.getName(), (Object)imgPackImpl, imgProps);
        DefaultLanguagePackImpl langPackImpl = new DefaultLanguagePackImpl();
        Hashtable<String, String> langProps = new Hashtable<String, String>();
        langProps.put("ResourceName", "DefaultLanguagePack");
        bundleContext.registerService(LanguagePack.class.getName(), (Object)langPackImpl, langProps);
        DefaultSettingsPackImpl setPackImpl = new DefaultSettingsPackImpl();
        Hashtable<String, String> setProps = new Hashtable<String, String>();
        setProps.put("ResourceName", "DefaultSettingsPack");
        bundleContext.registerService(SettingsPack.class.getName(), (Object)setPackImpl, setProps);
        DefaultSoundPackImpl sndPackImpl = new DefaultSoundPackImpl();
        Hashtable<String, String> sndProps = new Hashtable<String, String>();
        sndProps.put("ResourceName", "DefaultSoundPack");
        bundleContext.registerService(SoundPack.class.getName(), (Object)sndPackImpl, sndProps);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Default resources ... [REGISTERED]");
        }
    }

    public void stop(BundleContext bc) throws Exception {
    }

    protected static Iterator<String> findResourcePaths(String path, String pattern) {
        Iterator<String> bufferedResult = ressourcesFiles.get(path + pattern);
        if (bufferedResult != null) {
            return bufferedResult;
        }
        ArrayList<String> propertiesList = new ArrayList<String>();
        Enumeration propertiesUrls = bundleContext.getBundle().findEntries(path, pattern, false);
        if (propertiesUrls != null) {
            while (propertiesUrls.hasMoreElements()) {
                URL propertyUrl = (URL)propertiesUrls.nextElement();
                String propertyFilePath = propertyUrl.getPath().substring(1);
                propertyFilePath = propertyFilePath.replaceAll("/", ".");
                propertiesList.add(propertyFilePath);
            }
        }
        Iterator<String> result = propertiesList.iterator();
        ressourcesFiles.put(path + pattern, result);
        return result;
    }

    static {
        ressourcesFiles = new Hashtable();
    }
}

