/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;

public class Join
implements Command {
    private static final int END_OF_COMMAND_PREFIX = 6;
    private final IrcConnection connection;

    public Join(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.connection = connection;
    }

    public void execute(String source, String line) {
        String password;
        String channel;
        if (line.length() < 6) {
            throw new IllegalArgumentException("Missing channel to join.");
        }
        String part = line.substring(6);
        int indexOfSep = part.indexOf(32);
        if (indexOfSep == -1) {
            channel = part;
            password = "";
        } else {
            channel = part.substring(0, indexOfSep);
            password = part.substring(indexOfSep + 1);
        }
        if (!channel.matches("[^,\\n\\r\\s\\a]+")) {
            throw new IllegalArgumentException("Invalid chat room name specified.");
        }
        this.connection.getClient().joinChannel(channel, password);
    }

    public String help() {
        return "Usage: /join <channel> [password]";
    }
}

