/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.accountinfo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import net.java.sip.communicator.plugin.accountinfo.AccountInfoPanel;
import net.java.sip.communicator.plugin.accountinfo.Resources;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.service.gui.AbstractPluginComponent;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.protocol.AccountID;

public class AccountInfoMenuItemComponent
extends AbstractPluginComponent {
    private JMenuItem accountInfoMenuItem;
    private AccountID accountID = null;

    public AccountInfoMenuItemComponent(Container container, PluginComponentFactory parentFactory) {
        super(container, parentFactory);
    }

    public void setCurrentAccountID(AccountID accountID) {
        this.accountID = accountID;
        this.accountInfoMenuItem.setEnabled(accountID != null && accountID.isEnabled());
    }

    public Object getComponent() {
        if (this.accountInfoMenuItem == null) {
            this.accountInfoMenuItem = new JMenuItem(Resources.getString("plugin.accountinfo.TITLE"));
            this.accountInfoMenuItem.setIcon(Resources.getImage("plugin.contactinfo.CONTACT_INFO_ICON"));
            this.accountInfoMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccountInfoDialog dialog = new AccountInfoDialog(AccountInfoMenuItemComponent.this.accountID);
                    dialog.setVisible(true);
                }
            });
        }
        return this.accountInfoMenuItem;
    }

    public String getName() {
        return Resources.getString("plugin.accountinfo.TITLE");
    }

    public int getPositionIndex() {
        return 0;
    }

    static class AccountInfoDialog
    extends SIPCommDialog {
        private AccountInfoPanel accountInfoPanel = new AccountInfoPanel(this);

        private AccountInfoDialog(AccountID accountID) {
            this.setPreferredSize(new Dimension(600, 400));
            this.setTitle(Resources.getString("plugin.accountinfo.TITLE"));
            if (accountID != null) {
                this.accountInfoPanel.getAccountsComboBox().setSelectedItem((Object)this.accountInfoPanel.getAccountsTable().get(accountID));
            }
            this.add((Component)((Object)this.accountInfoPanel));
        }

        protected void close(boolean isEscaped) {
            this.setVisible(false);
            this.accountInfoPanel.dispose();
        }

        public void setVisible(boolean isVisible) {
            if (isVisible) {
                this.accountInfoPanel.setVisible(true);
            }
            super.setVisible(isVisible);
        }
    }
}

