/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.Map;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.slick.protocol.generic.AuthHandler;
import net.java.sip.communicator.slick.protocol.generic.TestOperationSetFileTransfer;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;

public class TestOperationSetFileTransferImpl
extends TestOperationSetFileTransfer {
    private static final Logger logger = Logger.getLogger(TestOperationSetFileTransferImpl.class);
    private JabberSlickFixture fixture = new JabberSlickFixture();
    private OperationSetPresence opSetPresence1 = null;
    private OperationSetPresence opSetPresence2 = null;
    private OperationSetFileTransfer opSetFT1 = null;
    private OperationSetFileTransfer opSetFT2 = null;
    private static Contact contact1 = null;
    private static Contact contact2 = null;

    @Override
    public Contact getContact1() {
        if (contact1 == null) {
            contact1 = this.opSetPresence1.findContactByID(this.fixture.userID2);
        }
        return contact1;
    }

    @Override
    public Contact getContact2() {
        if (contact2 == null) {
            contact2 = this.opSetPresence2.findContactByID(this.fixture.userID1);
        }
        return contact2;
    }

    @Override
    public void start() throws Exception {
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.opSetPresence1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        this.opSetFT1 = (OperationSetFileTransfer)supportedOperationSets1.get(OperationSetFileTransfer.class.getName());
        if (this.opSetFT1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the FileTransferOperationSets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.opSetPresence2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        this.opSetFT2 = (OperationSetFileTransfer)supportedOperationSets2.get(OperationSetFileTransfer.class.getName());
        if (this.opSetFT2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the FileTransferOperationSets");
        }
        this.prepareContactList();
    }

    @Override
    public void stop() throws Exception {
        this.fixture.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareContactList() throws Exception {
        Object object;
        if (this.getContact1() == null && this.getContact2() == null) {
            this.fixture.clearProvidersLists();
        }
        if (this.getContact1() == null) {
            Object o;
            object = o = new Object();
            synchronized (object) {
                o.wait(2000L);
            }
            try {
                this.opSetPresence1.setAuthorizationHandler((AuthorizationHandler)new AuthHandler());
                this.opSetPresence1.subscribe(this.fixture.userID2);
            }
            catch (OperationFailedException operationFailedException) {
                // empty catch block
            }
        }
        if (this.getContact2() == null) {
            try {
                this.opSetPresence2.setAuthorizationHandler((AuthorizationHandler)new AuthHandler());
                this.opSetPresence2.subscribe(this.fixture.userID1);
            }
            catch (OperationFailedException o) {
                // empty catch block
            }
            logger.info((Object)"will wait till the list prepare is completed");
            object = o = new Object();
            synchronized (object) {
                o.wait(4000L);
            }
        }
    }

    @Override
    public OperationSetFileTransfer getOpSetFilTransfer1() {
        return this.opSetFT1;
    }

    @Override
    public OperationSetFileTransfer getOpSetFilTransfer2() {
        return this.opSetFT2;
    }

    @Override
    public BundleContext getContext() {
        return JabberSlickFixture.bc;
    }

    @Override
    public boolean enableTestSendAndReceive() {
        return true;
    }

    @Override
    public boolean enableTestSenderCancelBeforeAccepted() {
        return false;
    }

    @Override
    public boolean enableTestReceiverDecline() {
        return true;
    }

    @Override
    public boolean enableTestReceiverCancelsWhileTransfering() {
        return false;
    }

    @Override
    public boolean enableTestSenderCancelsWhileTransfering() {
        return true;
    }
}

