/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientReadyCmd
extends ConnCommand {
    private final List<SnacFamilyInfo> infos;

    protected ClientReadyCmd(SnacPacket packet) {
        super(2);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        int num = snacData.getLength() / 8;
        ArrayList<SnacFamilyInfo> infos = new ArrayList<SnacFamilyInfo>(num);
        for (int i = 0; i < num; ++i) {
            infos.add(SnacFamilyInfo.readSnacFamilyInfo(snacData));
            snacData = snacData.subBlock(8);
        }
        this.infos = DefensiveTools.getUnmodifiable(infos);
    }

    public ClientReadyCmd(Collection<SnacFamilyInfo> infos) {
        super(2);
        this.infos = DefensiveTools.getSafeListCopy(infos, "infos");
    }

    public final List<SnacFamilyInfo> getSnacFamilyInfos() {
        return this.infos;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        if (this.infos != null) {
            for (SnacFamilyInfo info : this.infos) {
                info.write(out);
            }
        }
    }

    public String toString() {
        return "ClientReadyCmd: " + this.infos;
    }
}

