/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.tlv.TlvTools;

public final class Tlv
implements Writable {
    private final int type;
    private ByteBlock data;
    private final int totalSize;
    private final Writable writer;

    public Tlv(int type, byte[] data) {
        this(type, ByteBlock.wrap(data));
    }

    public static Tlv getStringInstance(int type, String string) {
        return new Tlv(type, ByteBlock.wrap(BinaryTools.getAsciiBytes(string)));
    }

    public static Tlv getUShortInstance(int type, int number) {
        return new Tlv(type, ByteBlock.wrap(BinaryTools.getUShort(number)));
    }

    public static Tlv getUIntInstance(int type, long number) {
        return new Tlv(type, ByteBlock.wrap(BinaryTools.getUInt(number)));
    }

    public static Tlv getUtf8Instance(int type, String string) {
        return new Tlv(type, BinaryTools.getUtf8Bytes(string));
    }

    public static boolean isValidTLV(ByteBlock tlvBytes) {
        if (tlvBytes.getLength() < 4) {
            return false;
        }
        int length = BinaryTools.getUShort(tlvBytes, 2);
        return length <= tlvBytes.getLength() - 4;
    }

    public Tlv(int type) {
        this(type, ByteBlock.EMPTY_BLOCK);
    }

    public Tlv(int type, Writable data) {
        DefensiveTools.checkRange(type, "type", 0);
        DefensiveTools.checkNull(data, "data");
        this.type = type;
        this.writer = data;
        this.data = data instanceof ByteBlock ? (ByteBlock)data : null;
        this.totalSize = -1;
    }

    public Tlv(ByteBlock tlvBytes) throws IllegalArgumentException {
        DefensiveTools.checkNull(tlvBytes, "tlvBytes");
        int blocklen = tlvBytes.getLength();
        if (blocklen < 4) {
            throw new IllegalArgumentException("data not long enough to be a TLV (length=" + blocklen + ")");
        }
        int length = BinaryTools.getUShort(tlvBytes, 2);
        if (length > blocklen - 4) {
            throw new IllegalArgumentException("data (length=" + blocklen + ") not long enough to fulfill " + "header-specified length (" + length + ")");
        }
        this.type = BinaryTools.getUShort(tlvBytes, 0);
        this.data = tlvBytes.subBlock(4, length);
        this.writer = this.data;
        this.totalSize = length + 4;
    }

    public final int getType() {
        return this.type;
    }

    public final synchronized ByteBlock getData() {
        if (this.data == null) {
            this.data = ByteBlock.createByteBlock(this.writer);
        }
        return this.data;
    }

    public final LiveWritable getDataWriter() {
        return this.writer;
    }

    public final String getDataAsString() {
        return BinaryTools.getAsciiString(this.data);
    }

    public String getDataAsUtf8() {
        return BinaryTools.getUtf8String(this.data);
    }

    public final int getDataAsUShort() {
        return BinaryTools.getUShort(this.data, 0);
    }

    public final long getDataAsUInt() {
        return BinaryTools.getUInt(this.data, 0);
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return 4 + this.data.getLength();
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.type);
        BinaryTools.writeUShort(out, (int)this.writer.getWritableLength());
        this.writer.write(out);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TLV: type=0x");
        buffer.append(Integer.toHexString(this.type));
        if (this.data == null) {
            buffer.append(" (no data block)");
        } else {
            int len = this.data.getLength();
            buffer.append(", length=" + len);
            if (len > 0) {
                CharsetDecoder ascii = Charset.forName("US-ASCII").newDecoder();
                CharBuffer chars = null;
                try {
                    chars = ascii.decode(ByteBuffer.wrap(this.data.toByteArray()));
                }
                catch (CharacterCodingException e) {
                    // empty catch block
                }
                boolean alternatevalue = false;
                if (chars != null) {
                    buffer.append(", ascii value=\"" + chars.toString() + "\"");
                    alternatevalue = true;
                }
                if (len == 2) {
                    buffer.append(", ushort value=" + this.getDataAsUShort());
                    alternatevalue = true;
                }
                if (len == 4) {
                    buffer.append(", uint value=" + this.getDataAsUInt());
                    alternatevalue = true;
                }
                if (TlvTools.isCompleteTlvChain(this.data)) {
                    buffer.append(", tlvchain value=" + TlvTools.readChain(this.data));
                    alternatevalue = true;
                }
                if (!alternatevalue) {
                    buffer.append(" - hex: ");
                } else {
                    buffer.append(": ");
                }
                buffer.append(BinaryTools.describeData(this.data));
            }
        }
        return buffer.toString();
    }
}

