/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.msghistory;

import net.java.sip.communicator.impl.msghistory.MessageHistoryServiceImpl;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MessageHistoryActivator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(MessageHistoryActivator.class);
    private static MessageHistoryServiceImpl msgHistoryService = null;
    private static ResourceManagementService resourcesService;
    private static MetaContactListService metaCListService;
    private static ConfigurationService configService;
    static BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        try {
            logger.logEntry();
            ServiceReference refHistory = bundleContext.getServiceReference(HistoryService.class.getName());
            HistoryService historyService = (HistoryService)bundleContext.getService(refHistory);
            msgHistoryService = new MessageHistoryServiceImpl();
            msgHistoryService.setHistoryService(historyService);
            msgHistoryService.start(bundleContext);
            bundleContext.registerService(MessageHistoryService.class.getName(), (Object)msgHistoryService, null);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Message History Service ...[REGISTERED]");
            }
        }
        finally {
            logger.logExit();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (msgHistoryService != null) {
            msgHistoryService.stop(bundleContext);
        }
    }

    public static MetaContactListService getContactListService() {
        if (metaCListService == null) {
            metaCListService = (MetaContactListService)ServiceUtils.getService((BundleContext)bundleContext, MetaContactListService.class);
        }
        return metaCListService;
    }

    public static MessageHistoryServiceImpl getMessageHistoryService() {
        return msgHistoryService;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resourcesService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }
}

