/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.securityconfig;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.credentialsstorage.MasterPasswordInputService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SecurityConfigActivator
implements BundleActivator {
    public static BundleContext bundleContext;
    private static ResourceManagementService resources;
    private static ConfigurationService configurationService;
    private static CredentialsStorageService credentialsStorageService;
    private static UIService uiService;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.securityconfig.DISABLED";
    private static final String MASTER_PASSWORD_DISABLED_PROP = "net.java.sip.communicator.plugin.securityconfig.masterpasswordconfig.DISABLED";

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        ConfigurationService cfg = SecurityConfigActivator.getConfigurationService();
        if (cfg.getBoolean(DISABLED_PROP, false)) {
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("FORM_TYPE", "GENERAL_TYPE");
        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.plugin.securityconfig.SecurityConfigurationPanel", this.getClass().getClassLoader(), "plugin.securityconfig.ICON", "plugin.securityconfig.TITLE", 20), properties);
        if (!cfg.getBoolean(MASTER_PASSWORD_DISABLED_PROP, false)) {
            properties = new Hashtable();
            ((Dictionary)properties).put("FORM_TYPE", "SECURITY_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.plugin.securityconfig.masterpassword.ConfigurationPanel", this.getClass().getClassLoader(), null, "plugin.securityconfig.masterpassword.TITLE", 3), properties);
        }
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resources;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }

    public static CredentialsStorageService getCredentialsStorageService() {
        if (credentialsStorageService == null) {
            credentialsStorageService = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        }
        return credentialsStorageService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public static List<AccountID> getAllAccountIDs() {
        Map<Object, ProtocolProviderFactory> providerFactoriesMap = SecurityConfigActivator.getProtocolProviderFactories();
        if (providerFactoriesMap == null) {
            return null;
        }
        Vector<AccountID> accountIDs = new Vector<AccountID>();
        for (ProtocolProviderFactory providerFactory : providerFactoriesMap.values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                accountIDs.add(accountID);
            }
        }
        return accountIDs;
    }

    private static Map<Object, ProtocolProviderFactory> getProtocolProviderFactories() {
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderFactory.class);
        Hashtable<Object, ProtocolProviderFactory> providerFactoriesMap = new Hashtable<Object, ProtocolProviderFactory>();
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                providerFactoriesMap.put(serRef.getProperty("PROTOCOL_NAME"), providerFactory);
            }
        }
        return providerFactoriesMap;
    }

    public static Map<AccountID, String> getAccountIDsWithSavedPasswords() {
        Map<Object, ProtocolProviderFactory> providerFactoriesMap = SecurityConfigActivator.getProtocolProviderFactories();
        if (providerFactoriesMap == null) {
            return null;
        }
        CredentialsStorageService credentialsStorageService = SecurityConfigActivator.getCredentialsStorageService();
        HashMap<AccountID, String> accountIDs = new HashMap<AccountID, String>();
        for (ProtocolProviderFactory providerFactory : providerFactoriesMap.values()) {
            String sourcePackageName = SecurityConfigActivator.getFactoryImplPackageName(providerFactory);
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                String accountPrefix = ProtocolProviderFactory.findAccountPrefix((BundleContext)bundleContext, (AccountID)accountID, (String)sourcePackageName);
                if (!credentialsStorageService.isStoredEncrypted(accountPrefix)) continue;
                accountIDs.put(accountID, accountPrefix);
            }
        }
        return accountIDs;
    }

    public static Map<String, String> getChatRoomsWithSavedPasswords() {
        Map<Object, ProtocolProviderFactory> providerFactoriesMap = SecurityConfigActivator.getProtocolProviderFactories();
        if (providerFactoriesMap == null) {
            return null;
        }
        CredentialsStorageService credentialsStorageService = SecurityConfigActivator.getCredentialsStorageService();
        HashMap<String, String> chatRoomIDs = new HashMap<String, String>();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = SecurityConfigActivator.getConfigurationService().getPropertyNamesByPrefix(prefix, true);
        for (ProtocolProviderFactory providerFactory : providerFactoriesMap.values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                for (String accountRootPropName : accounts) {
                    String accountName = SecurityConfigActivator.getConfigurationService().getString(accountRootPropName);
                    if (!accountID.getAccountUniqueID().equals(accountName)) continue;
                    List chatRooms = SecurityConfigActivator.getConfigurationService().getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
                    for (String chatRoomPropName : chatRooms) {
                        String chatRoomName = SecurityConfigActivator.getConfigurationService().getString(chatRoomPropName);
                        if (!credentialsStorageService.isStoredEncrypted(chatRoomPropName + ".password")) continue;
                        chatRoomIDs.put(chatRoomName + " " + resources.getI18NString("service.gui.VIA") + " " + accountID.getUserID(), chatRoomPropName + ".password");
                    }
                }
            }
        }
        return chatRoomIDs;
    }

    private static String getFactoryImplPackageName(ProtocolProviderFactory providerFactory) {
        String className = providerFactory.getClass().getName();
        return className.substring(0, className.lastIndexOf(46));
    }

    public static MasterPasswordInputService getMasterPasswordInputService() {
        return (MasterPasswordInputService)ServiceUtils.getService((BundleContext)bundleContext, MasterPasswordInputService.class);
    }
}

